/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl;

import com.eviware.soapui.support.UISupport;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicButtonUI;

public class RoundButton
extends JButton {
    protected int arc;
    private static boolean isMac = UISupport.isMac();

    public RoundButton(int arc) {
        this.arc = arc;
        if (isMac) {
            this.setUI(new BasicButtonUI());
            this.setBorder(BorderFactory.createEmptyBorder(2, 5, 3, 5));
        }
        this.setContentAreaFilled(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, this.arc, this.arc);
        super.paintComponent(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        g.setColor(isMac ? this.getForeground() : new Color(39, 104, 158));
        g.drawRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, this.arc, this.arc);
    }
}

