/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.autoupdate;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.autoupdate.SoapUIVersionInfo;
import com.eviware.soapui.support.UISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class NewSoapUIVersionAvailableDialog
extends JDialog {
    private ReadyApiUpdateDialogResult dialogResult;
    private static final String NEW_VERSION_AVAILABLE_MESSAGE = "New Version Available";
    private static final String NEW_VERSION_AVAILABLE_MESSAGE_EX = "A new version of SoapUI is available, please check the details below.";
    public static final String SKIPPED_VERSION_SETTING = "SkippedVersion";
    private SoapUIVersionInfo newProductVersion;
    private SoapUIVersionInfo curVersion;
    private String releaseNotes;

    public NewSoapUIVersionAvailableDialog(SoapUIVersionInfo version, SoapUIVersionInfo curVersion, String releaseNotes) {
        super(UISupport.getMainFrame(), true);
        this.newProductVersion = version;
        this.releaseNotes = releaseNotes;
        this.curVersion = curVersion;
        this.Init();
    }

    protected void Init() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)UISupport.buildDescription(NEW_VERSION_AVAILABLE_MESSAGE, NEW_VERSION_AVAILABLE_MESSAGE_EX, null), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)new JLabel("Current version:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        mainPanel.add((Component)new JLabel(this.curVersion.toString()), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        mainPanel.add((Component)new JLabel("New version:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        mainPanel.add((Component)new JLabel(this.newProductVersion.toString()), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        JEditorPane releaseNotesPane = this.createReleaseNotesPane();
        JScrollPane scb = new JScrollPane(releaseNotesPane);
        scb.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "Release notes"));
        mainPanel.add((Component)scb, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        JPanel toolbar = this.buildToolbar(this);
        mainPanel.add((Component)toolbar, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.setTitle("New Version Check");
        this.setIconImage(UISupport.createImageIcon("/SoapUI-OS_16-16.png").getImage());
        this.getContentPane().add(mainPanel);
        this.setSize(new Dimension(550, 440));
        this.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - this.getWidth() / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - this.getHeight() / 2);
    }

    public ReadyApiUpdateDialogResult showDialog() {
        this.setVisible(true);
        return this.dialogResult;
    }

    protected JEditorPane createReleaseNotesPane() {
        JEditorPane text = new JEditorPane();
        try {
            text.setPage(this.releaseNotes);
            text.setEditable(false);
        }
        catch (IOException e) {
            text.setText("No release notes");
            SoapUI.logError(e);
        }
        return text;
    }

    protected JPanel buildToolbar(JDialog dialog) {
        final JComboBox<String> choice = new JComboBox<String>();
        choice.addItem("1 day");
        choice.addItem("3 days");
        choice.addItem("7 days");
        choice.setSelectedIndex(0);
        this.dialogResult = ReadyApiUpdateDialogResult.DoNotUpdate;
        JButton remindMeLaterButton = new JButton("Remind me later");
        remindMeLaterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (choice.getSelectedIndex()) {
                    case 0: {
                        NewSoapUIVersionAvailableDialog.this.dialogResult = ReadyApiUpdateDialogResult.Delay_1Day;
                        break;
                    }
                    case 1: {
                        NewSoapUIVersionAvailableDialog.this.dialogResult = ReadyApiUpdateDialogResult.Delay_3Days;
                        break;
                    }
                    case 2: {
                        NewSoapUIVersionAvailableDialog.this.dialogResult = ReadyApiUpdateDialogResult.Delay_7Days;
                        break;
                    }
                    default: {
                        NewSoapUIVersionAvailableDialog.this.dialogResult = ReadyApiUpdateDialogResult.Delay_1Day;
                    }
                }
                NewSoapUIVersionAvailableDialog.this.setVisible(false);
            }
        });
        JButton downloadButton = new JButton("Download and install");
        downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSoapUIVersionAvailableDialog.this.dialogResult = ReadyApiUpdateDialogResult.Update;
                NewSoapUIVersionAvailableDialog.this.setVisible(false);
            }
        });
        JButton ignoreUpdate = new JButton(new IgnoreUpdateAction(this));
        JPanel toolbarPanel = new JPanel(new GridBagLayout());
        toolbarPanel.add(choice, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        toolbarPanel.add((Component)remindMeLaterButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        toolbarPanel.add((Component)new JPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        toolbarPanel.add((Component)ignoreUpdate, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        toolbarPanel.add((Component)downloadButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        return toolbarPanel;
    }

    static enum ReadyApiUpdateDialogResult {
        Update,
        Delay_1Day,
        Delay_3Days,
        Delay_7Days,
        DoNotUpdate,
        SkipThisVersion;

    }

    protected class IgnoreUpdateAction
    extends AbstractAction {
        private JDialog dialog;

        public IgnoreUpdateAction(JDialog dialog) {
            super("Ignore this update");
            this.dialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUI.getSettings().setString(NewSoapUIVersionAvailableDialog.SKIPPED_VERSION_SETTING, NewSoapUIVersionAvailableDialog.this.newProductVersion.toString());
            this.dialog.setVisible(false);
        }
    }
}

