/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.project.SaveStatus;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.model.workspace.WorkspaceListener;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;

public class SaveAllProjectsAction
extends AbstractSoapUIAction<WorkspaceImpl>
implements WorkspaceListener {
    public static final String SOAPUI_ACTION_ID = "SaveAllProjectsAction";

    public SaveAllProjectsAction() {
        super("Save All Projects", "Saves all projects in the current Workspace");
        Workspace workspace = SoapUI.getWorkspace();
        if (workspace == null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(workspace.getProjectCount() > 0);
            workspace.addWorkspaceListener(this);
        }
    }

    @Override
    public void perform(WorkspaceImpl workspace, Object param) {
        SaveStatus status = workspace.save(false);
        if (status == SaveStatus.SUCCESS) {
            if (param != null && param instanceof SoapUIActions) {
                Analytics.trackAction((SoapUIActions)((Object)param));
            } else {
                Analytics.trackAction(SoapUIActions.SAVE_ALL_PROJECTS);
            }
        }
    }

    @Override
    public void projectAdded(Project project) {
        this.setEnabled(true);
    }

    @Override
    public void projectChanged(Project project) {
    }

    @Override
    public void projectRemoved(Project project) {
        this.setEnabled(project.getWorkspace().getProjectCount() == 0);
    }

    @Override
    public void workspaceSwitched(Workspace workspace) {
        this.setEnabled(workspace.getProjectCount() > 0);
    }

    @Override
    public void workspaceSwitching(Workspace workspace) {
    }

    @Override
    public void projectClosed(Project project) {
    }

    @Override
    public void projectOpened(Project project) {
    }
}

