/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui;

import com.eviware.soapui.DefaultSoapUICore;
import com.eviware.soapui.RecentItemsListener;
import com.eviware.soapui.SoapUICore;
import com.eviware.soapui.SoapUIThreadCreator;
import com.eviware.soapui.StandaloneSoapUICore;
import com.eviware.soapui.SwingSoapUICore;
import com.eviware.soapui.actions.ShowSystemPropertiesAction;
import com.eviware.soapui.actions.SoapUIPreferencesAction;
import com.eviware.soapui.actions.SumbitUserInfoAction;
import com.eviware.soapui.actions.SwitchDesktopPanelAction;
import com.eviware.soapui.actions.VersionUpdateAction;
import com.eviware.soapui.analytics.Analytics;
import com.eviware.soapui.analytics.AnalyticsHelper;
import com.eviware.soapui.analytics.SoapUIActions;
import com.eviware.soapui.analytics.UniqueUserIdentifier;
import com.eviware.soapui.autoupdate.SoapUIAutoUpdaterUtils;
import com.eviware.soapui.autoupdate.SoapUIUpdateProvider;
import com.eviware.soapui.impl.RoundButton;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.rest.actions.explorer.EndpointExplorerAction;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.support.OpenUrlAction;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.PropertyHolderTable;
import com.eviware.soapui.impl.wsdl.support.HelpUrls;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.PanelBuilder;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.environment.EnvironmentListener;
import com.eviware.soapui.model.environment.Property;
import com.eviware.soapui.model.project.SaveStatus;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.settings.SettingsListener;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.util.PanelBuilderRegistry;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.model.workspace.WorkspaceFactory;
import com.eviware.soapui.monitor.MockEngine;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.settings.VersionUpdateSettings;
import com.eviware.soapui.support.DefaultHyperlinkListener;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIAction;
import com.eviware.soapui.support.action.SoapUIActionRegistry;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.ActionListBuilder;
import com.eviware.soapui.support.action.swing.ActionSupport;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JPropertiesTable;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.dnd.NavigatorDragAndDropable;
import com.eviware.soapui.support.dnd.SoapUIDragAndDropHandler;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistry;
import com.eviware.soapui.support.jnlp.WebstartUtilCore;
import com.eviware.soapui.support.listener.SoapUIListenerRegistry;
import com.eviware.soapui.support.log.InspectorLog4JMonitor;
import com.eviware.soapui.support.log.JLogList;
import com.eviware.soapui.support.log.Log4JMonitor;
import com.eviware.soapui.support.log.LogDisablingTestMonitorListener;
import com.eviware.soapui.support.monitor.MonitorPanel;
import com.eviware.soapui.support.monitor.RuntimeMemoryMonitorSource;
import com.eviware.soapui.support.preferences.UserPreferences;
import com.eviware.soapui.support.swing.MenuBuilderHelper;
import com.eviware.soapui.support.swing.MenuScroller;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.tools.CmdLineRunner;
import com.eviware.soapui.tools.SecureTools;
import com.eviware.soapui.ui.JDesktopPanelsList;
import com.eviware.soapui.ui.URLDesktopPanel;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.soapui.ui.desktop.DesktopRegistry;
import com.eviware.soapui.ui.desktop.NullDesktop;
import com.eviware.soapui.ui.desktop.SoapUIDesktop;
import com.eviware.soapui.ui.desktop.standalone.StandaloneDesktop;
import com.eviware.soapui.ui.navigator.Navigator;
import com.eviware.soapui.ui.navigator.NavigatorListener;
import com.eviware.soapui.ui.support.DesktopListenerAdapter;
import com.eviware.x.impl.swing.SwingDialogs;
import com.google.common.base.Objects;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.looks.HeaderStyle;
import com.smartbear.analytics.AnalyticsManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import javafx.application.Platform;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoapUI {
    public static final String DEFAULT_DESKTOP = "Default";
    public static final String CURRENT_SOAPUI_WORKSPACE = SoapUI.class.getName() + "@workspace";
    public static final Logger log = LogManager.getLogger(SoapUI.class);
    public static final String SOAPUI_VERSION = SoapUI.getVersion("soapui.version");
    public static final String PRODUCT_NAME = "SoapUI";
    public static final String DEFAULT_WORKSPACE_FILE = "default-soapui-workspace.xml";
    public static final String SOAPUI_SPLASH = "SoapUI-Spashscreen.png";
    public static final String SOAPUI_ABOUT = "SoapUI-blank.png";
    public static final String SOAPUI_TITLE = "/branded/branded.properties";
    public static final String PROPERTIES_TAB_PANEL_NAME = "PropertiesTabPanel";
    private static final String PROXY_ENABLED_ICON = "/Proxy_Turned-on.png";
    private static final String PROXY_DISABLED_ICON = "/Proxy_Turned-off.png";
    public static final String BUILDINFO_PROPERTIES = "/buildinfo.properties";
    public static final String STARTER_PAGE_HEADER = "SoapUI Start Page";
    public static final String STARTER_PAGE_TOOL_TIP = "Info on SoapUI";
    public static String FRAME_ICON = "/SoapUI-OS_16-16.png;/SoapUI-OS_24-24.png;/SoapUI-OS_32-32.png;/SoapUI-OS_48-48.png;/SoapUI-OS_256-256.png";
    public static String STARTER_PAGE_ERROR_URL = "file://" + System.getProperty("soapui.home", ".") + "/starter-page.html";
    private static final int DEFAULT_DESKTOP_ACTIONS_COUNT = 3;
    private static final int DEFAULT_MAX_THREADPOOL_SIZE = 200;
    private static final String BROWSER_DISABLED_SYSTEM_PROPERTY = "soapui.browser.disabled";
    public static final String PROJECT = "Project";
    public static final String SUITE = "Suite";
    public static final String STEP = "Step";
    public static final String CASE = "Case";
    public static final String ENABLED_PROJECT_ACTIONS = "EnabledWsdlProjectActions";
    public static final String TEST_SUITE_ACTIONS = "WsdlTestSuiteActions";
    public static final String TEST_CASE_ACTIONS = "WsdlTestCaseActions";
    public static final String TEST_STEP_ACTIONS = "WsdlTestStepActions";
    private static List<Object> logCache = new ArrayList<Object>();
    private static SoapUICore soapUICore;
    private static Timer soapUITimer;
    private static JFrame frame;
    private static Navigator navigator;
    private static SoapUIDesktop desktop;
    private static Workspace workspace;
    private static Log4JMonitor logMonitor;
    private static Logger errorLog;
    private static boolean isStandalone;
    private static boolean isCommandLine;
    private static TestMonitor testMonitor;
    private JMenu desktopMenu;
    private static JMenuBar menuBar;
    private JDesktopPanelsList desktopPanelsList;
    private static Boolean checkedGroovyLogMonitor;
    private static Boolean launchedTestRunner;
    private JPanel overviewPanel;
    private boolean saveOnExit = true;
    private InternalDesktopListener internalDesktopListener = new InternalDesktopListener();
    private JInspectorPanel mainInspector;
    private static AutoSaveTimerTask autoSaveTimerTask;
    private static String workspaceName;
    private static StringToStringMap projectOptions;
    private static URLDesktopPanel starterPageDesktopPanel;
    private static JXToolBar mainToolbar;
    private static String[] mainArgs;
    private static GCTimerTask gcTimerTask;
    private static JPanel endpointExplorerButtonPanel;
    private static JButton endpointExplorerButton;
    private static final ThreadPoolExecutor threadPool;
    private JTextField searchField;
    private static JToggleButton applyProxyButton;
    private static Logger groovyLogger;
    private static CmdLineRunner soapUIRunner;
    public static final String BACKUP_STARTER_PAGE_URL = "/starter-page/starter-page.html";

    private SoapUI() {
    }

    static String getVersion(String versionPropertyName) {
        String version = System.getProperty(versionPropertyName);
        if (version != null) {
            return version;
        }
        version = SoapUI.class.getPackage().getImplementationVersion();
        if (version != null) {
            return version;
        }
        try {
            Properties buildInfoProperties = new Properties();
            buildInfoProperties.load(SoapUI.class.getResourceAsStream(BUILDINFO_PROPERTIES));
            version = buildInfoProperties.getProperty("version");
            if (!StringUtils.isNullOrEmpty(version)) {
                return version;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "UNKNOWN VERSION";
    }

    private static int getMaxThreadpoolSize() {
        try {
            return Integer.parseInt(System.getProperty("soapui.threadpool.max"));
        }
        catch (Exception e) {
            return 200;
        }
    }

    public static boolean usingGraphicalEnvironment() {
        return !UISupport.isHeadless() && !SoapUI.isCommandLine();
    }

    private void buildUI() {
        log.info("Used java version: " + System.getProperty("java.version"));
        frame.addWindowListener(new MainFrameWindowListener());
        UISupport.setMainFrame(frame);
        navigator = new Navigator(workspace);
        navigator.addNavigatorListener(new InternalNavigatorListener());
        this.desktopPanelsList = new JDesktopPanelsList(desktop);
        this.mainInspector = JInspectorPanelFactory.build(this.buildContentPanel(), 2);
        this.mainInspector.addInspector(new JComponentInspector<JComponent>(this.buildMainPanel(), "Navigator", "The SoapUI Navigator", true));
        this.mainInspector.setCurrentInspector("Navigator");
        frame.setJMenuBar(this.buildMainMenu());
        frame.getContentPane().add((Component)this.buildToolbar(), "North");
        frame.getContentPane().add((Component)this.mainInspector.getComponent(), "Center");
        frame.setDefaultCloseOperation(0);
        this.mainInspector.setDividerLocation(250);
        this.mainInspector.setResizeWeight(0.1);
        navigator.selectModelItem(workspace);
        desktop.addDesktopListener(this.internalDesktopListener);
        ToolTipManager.sharedInstance().setInitialDelay(200);
        JTree mainTree = navigator.getMainTree();
        DragSource dragSource = DragSource.getDefaultDragSource();
        SoapUIDragAndDropHandler navigatorDragAndDropHandler = new SoapUIDragAndDropHandler(new NavigatorDragAndDropable(mainTree), 6);
        dragSource.createDefaultDragGestureRecognizer(mainTree, 3, navigatorDragAndDropHandler);
        desktop.init();
    }

    private JComponent buildToolbar() {
        mainToolbar = new JXToolBar();
        UISupport.setPreferredHeight(mainToolbar, 50);
        mainToolbar.setFloatable(false);
        mainToolbar.setRollover(true);
        mainToolbar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        mainToolbar.addSpace(20);
        mainToolbar.add(new NewProjectActionDelegate("/new-empty-project-icon.png", "Empty", "NewEmptyProjectAction", SoapUIActions.CREATE_EMPTY_PROJECT_FROM_TOOLBAR));
        mainToolbar.add(new NewProjectActionDelegate("/new-soap-project-icon.png", "SOAP", "NewWsdlProjectAction", SoapUIActions.CREATE_SOAP_PROJECT_FROM_TOOLBAR));
        mainToolbar.add(new NewProjectActionDelegate("/new-rest-project-icon.png", "REST", "NewRestProjectAction", SoapUIActions.CREATE_REST_PROJECT_FROM_TOOLBAR));
        mainToolbar.add(new ImportWsdlProjectActionDelegate());
        mainToolbar.add(new SaveAllActionDelegate());
        mainToolbar.addSpace(2);
        mainToolbar.add(new ShowOnlineHelpAction("Forum", "http://community.smartbear.com", "Opens the SoapUI Forum in a browser", "/forum.png"));
        mainToolbar.addSpace(2);
        mainToolbar.add(new ShowOnlineHelpAction("Trial", "/Downloads/download-soapui-pro-trial.html?utm_source=soapui&utm_medium=inproductupgrade&utm_campaign=protrial", "Apply for ReadyAPI Trial License", "/Trial_20-20.png"));
        mainToolbar.add(new PreferencesActionDelegate());
        applyProxyButton = (JToggleButton)mainToolbar.add(new JToggleButton(new ApplyProxyButtonAction()));
        SoapUI.updateProxyButtonAndTooltip();
        mainToolbar.addSpace(15);
        this.createToolbarSeparator();
        mainToolbar.addSpace(10);
        this.createEndpointExplorerButton();
        endpointExplorerButtonPanel.add(endpointExplorerButton);
        mainToolbar.add(endpointExplorerButtonPanel);
        mainToolbar.addSpace(10);
        this.createToolbarSeparator();
        mainToolbar.addGlue();
        this.searchField = new JTextField(20){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(Color.LIGHT_GRAY);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        };
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    SoapUI.doCommunitySearch(SoapUI.this.searchField.getText());
                }
            }
        });
        JLabel searchLabel = new JLabel("Search Forum");
        searchLabel.setPreferredSize(new Dimension((int)(searchLabel.getPreferredSize().getWidth() * 1.1), (int)searchLabel.getPreferredSize().getHeight()));
        mainToolbar.addFixed(searchLabel);
        mainToolbar.addSeparator(new Dimension(3, 3));
        mainToolbar.addFixed(this.searchField);
        mainToolbar.add(new ToolbarForumSearchAction());
        mainToolbar.add(new ShowOnlineHelpAction("/getting-started/help-in-soapui/help-in-soapui.html"));
        for (int i = 0; i < mainToolbar.getComponentCount(); ++i) {
            if (!(mainToolbar.getComponent(i) instanceof JComponent)) continue;
            ((JComponent)mainToolbar.getComponent(i)).setBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        }
        mainToolbar.setBorder(BorderFactory.createEmptyBorder());
        return mainToolbar;
    }

    public static void doCommunitySearch(String text) {
        String prefix = "/t5/forums/searchpage/tab/message?include_forums=true";
        String forum = "location=board%3ASoapUI_OS";
        String suffix = "&search_type=thread&filter=labels%2Clocation";
        String searchText = "&q=" + HttpUtils.urlEncodeWithUtf8(text.trim());
        String searchUrl = "http://community.smartbear.com" + prefix + forum + searchText + suffix;
        if (StringUtils.hasContent(text)) {
            Tools.openURL(searchUrl);
        } else {
            Tools.openURL("http://community.smartbear.com");
        }
    }

    private void createEndpointExplorerButton() {
        endpointExplorerButtonPanel = new JPanel(new BorderLayout());
        endpointExplorerButtonPanel.setPreferredSize(new Dimension(130, 32));
        endpointExplorerButtonPanel.setMaximumSize(new Dimension(130, 32));
        endpointExplorerButton = new RoundButton(6);
        endpointExplorerButton.setForeground(Color.WHITE);
        endpointExplorerButton.setBackground(new Color(52, 137, 209));
        endpointExplorerButton.setText("Endpoint Explorer");
        if (UISupport.isMac()) {
            endpointExplorerButton.setOpaque(false);
        }
        EndpointExplorerAction action = new EndpointExplorerAction();
        endpointExplorerButton.addActionListener(action);
        endpointExplorerButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseEntered(MouseEvent e) {
                endpointExplorerButton.setBackground(new Color(39, 104, 158));
                endpointExplorerButton.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                endpointExplorerButton.setBackground(new Color(52, 137, 209));
                endpointExplorerButton.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    private void createToolbarSeparator() {
        JPanel separatorPanel = new JPanel(new BorderLayout());
        separatorPanel.setPreferredSize(new Dimension(5, 40));
        separatorPanel.setMaximumSize(new Dimension(5, 40));
        JSeparator separator = new JSeparator();
        separator.setOrientation(1);
        separator.setBackground(new Color(112, 112, 112));
        separator.setLocation(10, 0);
        separatorPanel.add(separator);
        mainToolbar.add(separatorPanel);
    }

    private JMenuBar buildMainMenu() {
        menuBar = new JMenuBar(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            }
        };
        menuBar.setBorder(BorderFactory.createEmptyBorder());
        menuBar.add(this.buildFileMenu());
        menuBar.add(this.buildProjectMenu());
        menuBar.add(this.buildSuiteMenu());
        menuBar.add(this.buildCaseMenu());
        menuBar.add(this.buildStepMenu());
        menuBar.add(this.buildToolsMenu());
        menuBar.add(this.buildDesktopMenu());
        menuBar.add(this.buildHelpMenu());
        return menuBar;
    }

    public static ThreadPoolExecutor getThreadPool() {
        return threadPool;
    }

    public static Workspace getWorkspace() {
        return workspace;
    }

    private JMenu buildDesktopMenu() {
        this.desktopMenu = new JMenu("Desktop");
        this.desktopMenu.setMnemonic(68);
        this.desktopMenu.add(new SwitchDesktopPanelAction(this.desktopPanelsList));
        this.desktopMenu.add(new MaximizeDesktopAction((InspectorLog4JMonitor)logMonitor));
        this.desktopMenu.addSeparator();
        ActionSupport.addActions(desktop.getActions(), this.desktopMenu);
        return this.desktopMenu;
    }

    private JMenu buildProjectMenu() {
        JMenu projectMenu = MenuBuilderHelper.buildMenuForWorkspace(new JMenu(PROJECT), ENABLED_PROJECT_ACTIONS);
        return projectMenu;
    }

    private JMenu buildSuiteMenu() {
        JMenu suiteMenu = MenuBuilderHelper.buildMenuForWorkspace(new JMenu(SUITE), TEST_SUITE_ACTIONS);
        return suiteMenu;
    }

    private JMenu buildCaseMenu() {
        JMenu caseMenu = MenuBuilderHelper.buildMenuForWorkspace(new JMenu(CASE), TEST_CASE_ACTIONS);
        return caseMenu;
    }

    private JMenu buildStepMenu() {
        JMenu stepMenu = MenuBuilderHelper.buildMenuForWorkspace(new JMenu(STEP), TEST_STEP_ACTIONS);
        return stepMenu;
    }

    private JMenu buildHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        helpMenu.add(new ShowStarterPageAction());
        helpMenu.addSeparator();
        helpMenu.add(new ShowOnlineHelpAction("API Testing Dojo", "/dojo/overview.html"));
        helpMenu.add(new ShowOnlineHelpAction("Getting Started", "/Getting-Started/your-first-soapui-project.html"));
        helpMenu.add(new SearchForumAction());
        helpMenu.addSeparator();
        helpMenu.add(new ShowSystemPropertiesAction());
        helpMenu.addSeparator();
        helpMenu.add(new VersionUpdateAction());
        helpMenu.addSeparator();
        helpMenu.add(new ShowOnlineHelpAction("ReadyAPI Trial", "/Downloads/download-soapui-pro-trial.html?utm_source=soapui&utm_medium=inproductupgrade&utm_campaign=protrial", "Apply for ReadyAPI Trial License", "/Trial_16-16.png"));
        helpMenu.add(new OpenUrlAction("Privacy Policy", "http://www.soapui.org/Store-Info/privacy-policy.html"));
        helpMenu.addSeparator();
        helpMenu.add(new OpenUrlAction("soapui.org", "http://www.soapui.org"));
        helpMenu.add(new OpenUrlAction("smartbear.com", "http://www.smartbear.com"));
        helpMenu.addSeparator();
        helpMenu.add(new AboutAction());
        return helpMenu;
    }

    private JMenu buildToolsMenu() {
        JMenu toolsMenu = new JMenu("Tools");
        toolsMenu.setMnemonic(84);
        toolsMenu.add(SwingActionDelegate.createDelegate("WSToolsWsdl2JavaAction"));
        toolsMenu.add(SwingActionDelegate.createDelegate("JBossWSConsumeAction"));
        toolsMenu.addSeparator();
        toolsMenu.add(SwingActionDelegate.createDelegate("WSCompileAction"));
        toolsMenu.add(SwingActionDelegate.createDelegate("WSImportAction"));
        toolsMenu.addSeparator();
        toolsMenu.add(SwingActionDelegate.createDelegate("Axis1XWSDL2JavaAction"));
        toolsMenu.add(SwingActionDelegate.createDelegate("Axis2WSDL2CodeAction"));
        toolsMenu.add(SwingActionDelegate.createDelegate("CXFAction"));
        toolsMenu.add(SwingActionDelegate.createDelegate("XFireAction"));
        toolsMenu.add(SwingActionDelegate.createDelegate("OracleWsaGenProxyAction"));
        toolsMenu.addSeparator();
        toolsMenu.add(SwingActionDelegate.createDelegate("XmlBeans2Action"));
        toolsMenu.add(SwingActionDelegate.createDelegate("JaxbXjcAction"));
        toolsMenu.addSeparator();
        toolsMenu.add(SwingActionDelegate.createDelegate("DotNetWsdlAction"));
        toolsMenu.add(SwingActionDelegate.createDelegate("GSoapAction"));
        toolsMenu.addSeparator();
        toolsMenu.add(SwingActionDelegate.createDelegate("TcpMonAction"));
        return toolsMenu;
    }

    private JMenu buildFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        ActionList actions = ActionListBuilder.buildActions(workspace);
        actions.removeAction(actions.getActionCount() - 1);
        ActionSupport.addActions(actions, fileMenu);
        fileMenu.add(SoapUIPreferencesAction.getInstance());
        fileMenu.add(new SavePreferencesAction());
        fileMenu.add(new ImportPreferencesAction());
        fileMenu.addSeparator();
        fileMenu.add(this.buildRecentMenu());
        fileMenu.addSeparator();
        fileMenu.add(new ExitAction());
        fileMenu.add(new ExitWithoutSavingAction());
        return fileMenu;
    }

    private JMenuItem buildRecentMenu() {
        JMenu recentMenu = new JMenu("Recent");
        JMenu recentProjectsMenu = new JMenu("Projects");
        JMenu recentWorkspacesMenu = new JMenu("Workspaces");
        JMenu recentEditorsMenu = new JMenu("Editors");
        recentMenu.add(recentEditorsMenu);
        recentMenu.add(recentProjectsMenu);
        recentMenu.add(recentWorkspacesMenu);
        MenuScroller.setScrollerFor(recentEditorsMenu, 24, 125, 0, 1);
        MenuScroller.setScrollerFor(recentProjectsMenu, 24, 125, 0, 1);
        MenuScroller.setScrollerFor(recentWorkspacesMenu, 24, 125, 0, 1);
        RecentItemsListener recentItemsListener = new RecentItemsListener(recentWorkspacesMenu, recentProjectsMenu, recentEditorsMenu);
        workspace.addWorkspaceListener(recentItemsListener);
        desktop.addDesktopListener(recentItemsListener);
        return recentMenu;
    }

    static void addStandardPreferencesShortcutOnMac() {
        if (UISupport.isMac()) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent e) {
                    int modifiers = e.getModifiers();
                    if (e.getKeyChar() == ',' && (modifiers == 256 || modifiers == 4)) {
                        SoapUIPreferencesAction.getInstance().actionPerformed(new ActionEvent(frame, 1, "ShowPreferences"));
                    }
                    return false;
                }
            });
        }
    }

    public static JFrame getFrame() {
        return frame;
    }

    private JComponent buildMainPanel() {
        JInspectorPanel inspectorPanel = JInspectorPanelFactory.build(navigator);
        inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildOverviewPanel(), "Properties", "Properties for the currently selected item", true));
        inspectorPanel.setDividerLocation(500);
        inspectorPanel.setResizeWeight(0.6);
        inspectorPanel.setCurrentInspector("Properties");
        return inspectorPanel.getComponent();
    }

    private JComponent buildOverviewPanel() {
        this.overviewPanel = new JPanel(new BorderLayout());
        return this.overviewPanel;
    }

    private void setOverviewPanel(Component panel) {
        if (this.overviewPanel.getComponentCount() == 0 && panel == null) {
            return;
        }
        this.overviewPanel.removeAll();
        if (panel != null) {
            this.overviewPanel.add(panel, "Center");
        }
        this.overviewPanel.revalidate();
        this.overviewPanel.repaint();
    }

    private JComponent buildContentPanel() {
        return this.buildLogPanel(true, "SoapUI log");
    }

    private JComponent buildLogPanel(boolean hasDefault, String defaultName) {
        InspectorLog4JMonitor inspectorLog4JMonitor = new InspectorLog4JMonitor(desktop.getDesktopComponent());
        JComponent monitor = SoapUI.initLogMonitor(hasDefault, defaultName, inspectorLog4JMonitor);
        if (!SoapUI.getSettings().getBoolean(UISettings.SHOW_LOGS_AT_STARTUP)) {
            inspectorLog4JMonitor.activate(null);
        }
        MonitorPanel monitorPanel = new MonitorPanel(new RuntimeMemoryMonitorSource());
        monitorPanel.start();
        inspectorLog4JMonitor.addInspector(new JComponentInspector<MonitorPanel>(monitorPanel, "memory log", "Shows runtime memory consumption", true));
        return monitor;
    }

    public static JComponent initLogMonitor(boolean hasDefault, String defaultName, Log4JMonitor logMonitor) {
        SoapUI.logMonitor = logMonitor;
        logMonitor.addLogArea(defaultName, "com.eviware.soapui", hasDefault).setLevel(Level.DEBUG);
        logMonitor.addLogArea("http log", "org.apache.http.wire", false).setLevel(Level.DEBUG);
        logMonitor.addLogArea("jetty log", "jetty", false).setLevel(Level.INFO);
        logMonitor.addLogArea("error log", "soapui.errorlog", false).setLevel(Level.DEBUG);
        logMonitor.addLogArea("wsrm log", "wsrm", false).setLevel(Level.INFO);
        for (Object message : logCache) {
            logMonitor.logEvent(message);
        }
        return logMonitor.getComponent();
    }

    public static boolean isSelectingMostRecentlyUsedDesktopPanelOnClose() {
        return SoapUI.getSettings().getBoolean(UISettings.MRU_PANEL_SELECTOR, true);
    }

    public static synchronized void log(final Object msg) {
        if (logMonitor == null) {
            if (!isCommandLine && logCache.size() < 1000) {
                logCache.add(msg);
            }
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            logMonitor.logEvent(msg);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    logMonitor.logEvent(msg);
                }
            });
        }
    }

    private static void setBackgroundsToWhite() {
        UIManager.put("Button.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        UIManager.put("MenuBar.background", Color.WHITE);
        UIManager.put("ComboBox.background", Color.WHITE);
        UIManager.put("TableHeader.background", Color.WHITE);
        UIManager.put("ToolBar.background", Color.WHITE);
        UIManager.put("TabbedPane.background", Color.LIGHT_GRAY);
        UIManager.put("TabbedPane.selected", Color.WHITE);
        UIManager.put("Label.background", Color.WHITE);
        UIManager.put("CheckBox.background", Color.WHITE);
        UIManager.put("Desktop.background", Color.WHITE);
        UIManager.put("ProgressBar.background", Color.WHITE);
        UIManager.put("InternalFrame.background", Color.WHITE);
        UIManager.put("SplitPane.background", Color.WHITE);
        UIManager.put("ScrollBar.background", Color.WHITE);
        UIManager.put("Spinner.background", Color.WHITE);
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("ToggleButton.background", Color.WHITE);
        UIManager.put("Slider.background", Color.WHITE);
        UIManager.put("RadioButton.background", Color.WHITE);
        UIManager.put("ScrollPane.background", Color.WHITE);
    }

    public static void main(String[] args) throws Exception {
        WebstartUtilCore.init();
        SoapUI.setBackgroundsToWhite();
        mainArgs = args;
        SecureTools.setTrustSSL();
        SoapUIRunner soapuiRunner = new SoapUIRunner();
        SwingUtilities.invokeLater(soapuiRunner);
    }

    public static String[] getMainArgs() {
        return mainArgs;
    }

    public static SoapUI startSoapUI(String[] args, String title, SwingSoapUICore core) throws Exception {
        boolean isDebug;
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", PRODUCT_NAME);
        frame = new JFrame(title);
        frame.setIconImages(SoapUI.getFrameIcons());
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        isStandalone = true;
        soapUICore = core;
        AnalyticsHelper.initializeAnalytics();
        Analytics.trackSessionStart();
        boolean bl = isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
        if (isDebug) {
            Analytics.trackAction(SoapUIActions.PRODUCT_STARTED_IN_DEBUGGING_MODE);
        } else {
            Analytics.trackAction(SoapUIActions.PRODUCT_STARTED);
        }
        SoapUI soapUI = new SoapUI();
        Workspace workspace = null;
        Options options = SoapUI.initSoapUIOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (!SoapUI.processCommandLineArgs(cmd)) {
            System.exit(1);
        }
        if (workspaceName != null) {
            workspace = WorkspaceFactory.getInstance().openWorkspace(workspaceName, projectOptions);
            soapUICore.getSettings().setString(CURRENT_SOAPUI_WORKSPACE, workspaceName);
        } else {
            String workspaceFile = soapUICore.getSettings().getString(CURRENT_SOAPUI_WORKSPACE, System.getProperty("user.home") + File.separatorChar + DEFAULT_WORKSPACE_FILE);
            UISupport.setDialogs(new SwingDialogs(null));
            try {
                workspace = WorkspaceFactory.getInstance().openWorkspace(workspaceFile, projectOptions);
            }
            catch (Exception e) {
                if (UISupport.confirm("Failed to open workspace: [" + e.toString() + "], create new one instead?", "Error")) {
                    new File(workspaceFile).renameTo(new File(workspaceFile + ".bak"));
                    workspace = WorkspaceFactory.getInstance().openWorkspace(workspaceFile, projectOptions);
                }
                System.exit(1);
            }
        }
        core.prepareUI();
        soapUI.show(workspace);
        new WindowInitializationTask().run();
        core.afterStartup(workspace);
        String[] args2 = cmd.getArgs();
        if (args2 != null && args2.length > 0) {
            String arg = args2[0];
            if (arg.toUpperCase().endsWith(".WSDL") || arg.toUpperCase().endsWith(".WADL")) {
                SwingUtilities.invokeLater(new WsdlProjectCreator(arg));
            } else {
                try {
                    URL url = new URL(arg);
                    SwingUtilities.invokeLater(new RestProjectCreator(url));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (SoapUI.usingGraphicalEnvironment()) {
            if (workspace.isSupportInformationDialog() || SoapUI.getSettings().getBoolean(UISettings.SHOW_STAY_TUNED_DIALOG, true)) {
                SumbitUserInfoAction collector = new SumbitUserInfoAction();
                collector.show();
                SoapUI.getSettings().setBoolean(UISettings.SHOW_STAY_TUNED_DIALOG, false);
                workspace.setSupportInformationDialog(false);
            }
            if (SoapUI.getSettings().getBoolean(UISettings.SHOW_ENDPOINT_EXPLORER_ON_START, true)) {
                SoapUI.showEndpointExplorer();
            }
        }
        return soapUI;
    }

    public static List<Image> getFrameIcons() {
        ArrayList<Image> iconList = new ArrayList<Image>();
        for (String iconPath : FRAME_ICON.split(";")) {
            iconList.add(UISupport.createImageIcon(iconPath).getImage());
        }
        return iconList;
    }

    private static boolean processCommandLineArgs(CommandLine cmd) {
        if (cmd.hasOption('w')) {
            workspaceName = cmd.getOptionValue('w');
        }
        if (cmd.hasOption('p')) {
            for (String projectNamePassword : cmd.getOptionValues('p')) {
                String[] nameAndPassword = projectNamePassword.split(":");
                projectOptions.put(nameAndPassword[0], nameAndPassword[1]);
            }
        }
        return true;
    }

    private static Options initSoapUIOptions() {
        Options options = new Options();
        options.addOption("w", true, "Specified the name of the workspace xml file");
        options.addOption("p", true, "Sets project name and its password in format <project name>:<password>");
        return options;
    }

    public static SoapUICore getSoapUICore() {
        return soapUICore;
    }

    public static TestPropertyHolder getGlobalProperties() {
        return PropertyExpansionUtils.getGlobalProperties();
    }

    public static void setSoapUICore(SoapUICore soapUICore) {
        SoapUI.setSoapUICore(soapUICore, false);
    }

    public static void setSoapUICore(SoapUICore soapUICore, boolean isCommandLine) {
        SoapUI.soapUICore = soapUICore;
        SoapUI.isCommandLine = isCommandLine;
    }

    public static boolean isStandalone() {
        return isStandalone;
    }

    public static boolean isCommandLine() {
        return isCommandLine;
    }

    public static JMenuBar getMenuBar() {
        return menuBar;
    }

    private void show(Workspace workspace) {
        SoapUI.workspace = workspace;
        String desktopType = soapUICore.getSettings().getString(UISettings.DESKTOP_TYPE, DEFAULT_DESKTOP);
        desktop = DesktopRegistry.getInstance().createDesktop(desktopType, workspace);
        if (desktop == null) {
            desktop = new StandaloneDesktop(workspace);
        }
        if (testMonitor == null) {
            testMonitor = new TestMonitor();
        }
        soapUICore.getSettings().addSettingsListener(new SettingsListener(){

            @Override
            public void settingChanged(String name, String newValue, String oldValue) {
                if (name.equals(UISettings.DESKTOP_TYPE)) {
                    SoapUI.this.changeDesktop(DesktopRegistry.getInstance().createDesktop(newValue, workspace));
                }
            }

            @Override
            public void settingsReloaded() {
            }
        });
        this.buildUI();
        testMonitor.addTestMonitorListener(new LogDisablingTestMonitorListener());
        testMonitor.init(workspace);
        SoapUI.initAutoSaveTimer();
        SoapUI.initGCTimer();
    }

    private void changeDesktop(SoapUIDesktop newDesktop) {
        this.desktopPanelsList.setDesktop(newDesktop);
        desktop.removeDesktopListener(this.internalDesktopListener);
        desktop.transferTo(newDesktop);
        desktop.release();
        desktop = newDesktop;
        if (logMonitor instanceof InspectorLog4JMonitor) {
            ((InspectorLog4JMonitor)logMonitor).setContentComponent(desktop.getDesktopComponent());
        }
        desktop.addDesktopListener(this.internalDesktopListener);
        while (this.desktopMenu.getItemCount() > 3) {
            this.desktopMenu.remove(3);
        }
        ActionSupport.addActions(desktop.getActions(), this.desktopMenu);
        desktop.init();
    }

    protected boolean onExit() {
        if (this.saveOnExit) {
            Object question = "Exit SoapUI?";
            if (SoapUI.getTestMonitor().hasRunningTests()) {
                question = (String)question + "\n(Projects with running tests will not be saved)";
            }
            if (!UISupport.confirm((String)question, "Question")) {
                return false;
            }
            try {
                soapUICore.saveSettings();
                SaveStatus saveStatus = workspace.onClose();
                if (saveStatus == SaveStatus.CANCELLED || saveStatus == SaveStatus.FAILED) {
                    return false;
                }
            }
            catch (Exception e1) {
                SoapUI.logError(e1);
            }
            Analytics.trackAction(SoapUIActions.EXIT);
        } else {
            if (!UISupport.confirm("Exit SoapUI without saving?", "Question")) {
                this.saveOnExit = true;
                return false;
            }
            Analytics.trackAction(SoapUIActions.EXIT_WITHOUT_SAVE);
        }
        Analytics.trackSessionStop();
        Analytics.trackAction(AnalyticsManager.Category.MIXPANEL_PROFILE, null, UniqueUserIdentifier.getInstance().prepareUserProfile());
        SoapUI.shutdown();
        return true;
    }

    public static void shutdown() {
        soapUITimer.cancel();
    }

    public static void logError(Throwable e) {
        SoapUI.logError(e, null);
    }

    public static void logError(Throwable e, String message) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.toString();
        }
        log.error("An error occurred [" + msg + "], see error log for details");
        try {
            if (message != null) {
                errorLog.error(message);
            }
            errorLog.error(e.toString(), e);
        }
        catch (OutOfMemoryError e1) {
            e1.printStackTrace();
            System.gc();
        }
        if (!SoapUI.isStandalone() || "true".equals(System.getProperty("soapui.stacktrace"))) {
            e.printStackTrace();
        }
    }

    public static Logger getErrorLog() {
        return errorLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger ensureGroovyLog() {
        ThreadPoolExecutor threadPoolExecutor = threadPool;
        synchronized (threadPoolExecutor) {
            if (!checkedGroovyLogMonitor.booleanValue() || launchedTestRunner.booleanValue()) {
                groovyLogger = LogManager.getLogger((String)"groovy.log");
                Log4JMonitor logMonitor = SoapUI.getLogMonitor();
                if (logMonitor != null && !logMonitor.hasLogArea("groovy.log")) {
                    logMonitor.addLogArea("script log", "groovy.log", false);
                    checkedGroovyLogMonitor = true;
                } else if (logMonitor == null && launchedTestRunner.booleanValue()) {
                    checkedGroovyLogMonitor = true;
                    launchedTestRunner = false;
                }
            }
        }
        return groovyLogger;
    }

    public static boolean isBrowserDisabled() {
        return Boolean.valueOf(System.getProperty(BROWSER_DISABLED_SYSTEM_PROPERTY));
    }

    public static void updateProxyButtonAndTooltip() {
        if (applyProxyButton == null) {
            return;
        }
        applyProxyButton.setVerticalTextPosition(3);
        applyProxyButton.setHorizontalTextPosition(0);
        if (ProxyUtils.isProxyEnabled()) {
            applyProxyButton.setIcon(UISupport.createImageIcon(PROXY_ENABLED_ICON));
            if (ProxyUtils.isAutoProxy()) {
                applyProxyButton.getAction().putValue("ShortDescription", "Proxy Setting: Automatic");
            } else {
                applyProxyButton.getAction().putValue("ShortDescription", "Proxy Setting: Manual");
            }
        } else {
            applyProxyButton.setIcon(UISupport.createImageIcon(PROXY_DISABLED_ICON));
            applyProxyButton.getAction().putValue("ShortDescription", "Proxy Setting: None");
        }
        applyProxyButton.setSelected(ProxyUtils.isProxyEnabled());
        UIManager.put("ToggleButton.select", Color.WHITE);
        SwingUtilities.updateComponentTreeUI(applyProxyButton);
    }

    public static void showStarterPage() {
        if (starterPageDesktopPanel == null || starterPageDesktopPanel.isClosed()) {
            try {
                starterPageDesktopPanel = new URLDesktopPanel(STARTER_PAGE_HEADER, STARTER_PAGE_TOOL_TIP, null, SoapUI.class.getResource(BACKUP_STARTER_PAGE_URL).toString());
            }
            catch (Exception e) {
                SoapUI.logError(e);
                return;
            }
        }
        UISupport.showDesktopPanel(starterPageDesktopPanel);
        starterPageDesktopPanel.navigate(HelpUrls.STARTER_PAGE_URL, SoapUI.class.getResource(BACKUP_STARTER_PAGE_URL).toString(), true);
    }

    private static void showEndpointExplorer() {
        new EndpointExplorerAction().actionPerformed(null);
    }

    public static TestMonitor getTestMonitor() {
        if (testMonitor == null) {
            testMonitor = new TestMonitor();
        }
        return testMonitor;
    }

    public static void setTestMonitor(TestMonitor monitor) {
        testMonitor = monitor;
    }

    public static Log4JMonitor getLogMonitor() {
        return logMonitor;
    }

    public static void setLogMonitor(Log4JMonitor monitor) {
        logMonitor = monitor;
    }

    public static SoapUIDesktop getDesktop() {
        if (desktop == null) {
            desktop = new NullDesktop();
        }
        return desktop;
    }

    public static void setDesktop(SoapUIDesktop desktop) {
        SoapUI.desktop = desktop;
    }

    public static Navigator getNavigator() {
        return navigator;
    }

    public static SoapUIActionRegistry getActionRegistry() {
        if (soapUICore == null) {
            soapUICore = new DefaultSoapUICore();
        }
        return soapUICore.getActionRegistry();
    }

    public static void setNavigator(Navigator navigator) {
        SoapUI.navigator = navigator;
    }

    public static void setWorkspace(Workspace workspace) {
        SoapUI.workspace = workspace;
    }

    public static void setStandalone(boolean standalone) {
        isStandalone = standalone;
    }

    public static SoapUIListenerRegistry getListenerRegistry() {
        if (soapUICore == null) {
            soapUICore = DefaultSoapUICore.createDefault();
        }
        return soapUICore.getListenerRegistry();
    }

    public static SoapUIFactoryRegistry getFactoryRegistry() {
        if (soapUICore == null) {
            soapUICore = DefaultSoapUICore.createDefault();
        }
        return soapUICore.getFactoryRegistry();
    }

    public static Settings getSettings() {
        if (soapUICore == null) {
            soapUICore = DefaultSoapUICore.createDefault();
        }
        return soapUICore.getSettings();
    }

    public static void importPreferences(File file) throws Exception {
        if (soapUICore != null) {
            soapUICore.importSettings(file);
        }
    }

    public static MockEngine getMockEngine() {
        if (soapUICore == null) {
            soapUICore = DefaultSoapUICore.createDefault();
        }
        return soapUICore.getMockEngine();
    }

    public static String saveSettings() throws Exception {
        return soapUICore == null ? null : soapUICore.saveSettings();
    }

    public static void initDefaultCore() {
        if (soapUICore == null) {
            soapUICore = DefaultSoapUICore.createDefault();
        }
    }

    public static void initAutoSaveTimer() {
        Settings settings = SoapUI.getSettings();
        long interval = settings.getLong(UISettings.AUTO_SAVE_INTERVAL, 0L);
        if (autoSaveTimerTask != null) {
            if (interval == 0L) {
                SoapUI.log("Cancelling AutoSave Timer");
            }
            autoSaveTimerTask.cancel();
            autoSaveTimerTask = null;
        }
        if (interval > 0L) {
            autoSaveTimerTask = new AutoSaveTimerTask();
            SoapUI.log("Scheduling autosave every " + interval + " minutes");
            soapUITimer.schedule((TimerTask)autoSaveTimerTask, interval * 1000L * 60L, interval * 1000L * 60L);
        }
    }

    public static void initGCTimer() {
        Settings settings = SoapUI.getSettings();
        long interval = settings.getLong(UISettings.GC_INTERVAL, 60L);
        if (gcTimerTask != null) {
            if (interval == 0L) {
                SoapUI.log("Cancelling GC Timer");
            }
            gcTimerTask.cancel();
            gcTimerTask = null;
        }
        if (interval > 0L) {
            gcTimerTask = new GCTimerTask();
            SoapUI.log("Scheduling garbage collection every " + interval + " seconds");
            soapUITimer.schedule((TimerTask)gcTimerTask, interval * 1000L, interval * 1000L);
        }
    }

    public static JXToolBar getToolBar() {
        return mainToolbar;
    }

    public static void setLaunchedTestRunner(Boolean launchedTestRunner) {
        SoapUI.launchedTestRunner = launchedTestRunner;
    }

    public static void updateProxyFromSettings() {
        ProxyUtils.setProxyEnabled(SoapUI.getSettings().getBoolean(ProxySettings.ENABLE_PROXY));
        ProxyUtils.setAutoProxy(SoapUI.getSettings().getBoolean(ProxySettings.AUTO_PROXY));
        ProxyUtils.setGlobalProxy(SoapUI.getSettings());
        SoapUI.updateProxyButtonAndTooltip();
    }

    public static Timer getSoapUITimer() {
        return soapUITimer;
    }

    public static void setCmdLineRunner(CmdLineRunner abstractSoapUIRunner) {
        soapUIRunner = abstractSoapUIRunner;
    }

    public static CmdLineRunner getCmdLineRunner() {
        return soapUIRunner;
    }

    public static boolean isAutoUpdateVersion() {
        return SoapUI.getSettings().getBoolean(VersionUpdateSettings.AUTO_CHECK_VERSION_UPDATE);
    }

    static {
        soapUITimer = new Timer();
        errorLog = LogManager.getLogger((String)"soapui.errorlog");
        checkedGroovyLogMonitor = false;
        launchedTestRunner = false;
        projectOptions = new StringToStringMap();
        threadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(SoapUI.getMaxThreadpoolSize(), new SoapUIThreadCreator());
        try {
            Platform.setImplicitExit((boolean)false);
        }
        catch (NoClassDefFoundError e) {
            log.warn("Could not find jfxrt.jar. Internal browser will be disabled.");
            System.setProperty(BROWSER_DISABLED_SYSTEM_PROPERTY, Boolean.TRUE.toString());
        }
    }

    private final class InternalDesktopListener
    extends DesktopListenerAdapter {
        private InternalDesktopListener() {
        }

        @Override
        public void desktopPanelSelected(DesktopPanel desktopPanel) {
            ModelItem modelItem = desktopPanel.getModelItem();
            if (modelItem != null) {
                navigator.selectModelItem(modelItem);
            }
        }
    }

    private final class MainFrameWindowListener
    extends WindowAdapter {
        private MainFrameWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (SoapUI.this.onExit()) {
                frame.dispose();
            }
        }

        @Override
        public void windowClosed(WindowEvent event) {
            threadPool.shutdown();
            try {
                threadPool.awaitTermination(1500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                threadPool.shutdownNow();
                Thread.currentThread().interrupt();
            }
            System.out.println("exiting..");
            SoapUI.getSoapUITimer().cancel();
            System.exit(0);
        }
    }

    public class InternalNavigatorListener
    implements NavigatorListener {
        private PropertyHolderTable selectedPropertyHolderTable = null;

        @Override
        public void nodeSelected(SoapUITreeNode treeNode) {
            if (treeNode == null) {
                SoapUI.this.setOverviewPanel(null);
            } else {
                PanelBuilder<ModelItem> panelBuilder;
                ModelItem modelItem = treeNode.getModelItem();
                if (this.selectedPropertyHolderTable != null) {
                    this.selectedPropertyHolderTable.release();
                    this.selectedPropertyHolderTable = null;
                }
                if (modelItem instanceof TestPropertyHolder && (!(modelItem instanceof WsdlProject) || ((WsdlProject)modelItem).isOpen())) {
                    this.selectedPropertyHolderTable = new PropertyHolderTable((TestPropertyHolder)((Object)modelItem));
                    if (modelItem instanceof WsdlProject) {
                        WsdlProject project = (WsdlProject)modelItem;
                        EnvironmentListener environmentListener = new EnvironmentListener(){

                            @Override
                            public void propertyValueChanged(Property property) {
                                InternalNavigatorListener.this.selectedPropertyHolderTable.getPropertiesModel().fireTableDataChanged();
                            }
                        };
                        project.addEnvironmentListener(environmentListener);
                        this.selectedPropertyHolderTable.setEnvironmentListener(environmentListener);
                        project.addProjectListener(this.selectedPropertyHolderTable.getProjectListener());
                    }
                }
                if ((panelBuilder = PanelBuilderRegistry.getPanelBuilder(modelItem)) != null && panelBuilder.hasOverviewPanel()) {
                    Component overviewPanel = panelBuilder.buildOverviewPanel(modelItem);
                    if (this.selectedPropertyHolderTable != null) {
                        JTabbedPane tabs = new JTabbedPane();
                        tabs.setName(SoapUI.PROPERTIES_TAB_PANEL_NAME);
                        if (overviewPanel instanceof JPropertiesTable) {
                            JPropertiesTable t = (JPropertiesTable)overviewPanel;
                            tabs.addTab(t.getTitle(), overviewPanel);
                            t.setTitle(null);
                        } else {
                            tabs.addTab("Overview", overviewPanel);
                        }
                        tabs.addTab(((TestPropertyHolder)((Object)modelItem)).getPropertiesLabel(), this.selectedPropertyHolderTable);
                        overviewPanel = UISupport.createTabPanel(tabs, false);
                    }
                    SoapUI.this.setOverviewPanel(overviewPanel);
                } else {
                    SoapUI.this.setOverviewPanel(null);
                }
            }
        }
    }

    static class NewProjectActionDelegate
    extends AbstractAction {
        String actionId;
        private SoapUIActions analyticAction;

        public NewProjectActionDelegate(String icon, String name, String actionId) {
            this(icon, name, actionId, null);
        }

        public NewProjectActionDelegate(String icon, String name, String actionId, SoapUIActions analyticAction) {
            this.putValue("SmallIcon", UISupport.createImageIcon(icon));
            if (name.equals("Empty")) {
                this.putValue("ShortDescription", "Creates an empty project");
            } else {
                this.putValue("ShortDescription", "Creates a new " + name + " project");
            }
            this.putValue("Name", name);
            this.actionId = actionId;
            this.analyticAction = analyticAction;
        }

        public void setShortDescription(String description) {
            this.putValue("ShortDescription", description);
        }

        public void setName(String name) {
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUI.getActionRegistry().getAction(this.actionId).perform(workspace, (Object)this.analyticAction);
        }
    }

    private static class ImportWsdlProjectActionDelegate
    extends AbstractAction {
        public ImportWsdlProjectActionDelegate() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/import_toolbar_icon.png"));
            this.putValue("ShortDescription", "Imports an existing SoapUI Project into the current workspace");
            this.putValue("Name", "Import");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUI.getActionRegistry().getAction("ImportWsdlProjectAction").perform(workspace, (Object)SoapUIActions.IMPORT_PROJECT_FROM_TOOLBAR);
        }
    }

    private static class SaveAllActionDelegate
    extends AbstractAction {
        public SaveAllActionDelegate() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/Save-all.png"));
            this.putValue("ShortDescription", "Saves all projects in the current workspace");
            this.putValue("Name", "Save All");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUI.getActionRegistry().getAction("SaveAllProjectsAction").perform(workspace, (Object)SoapUIActions.SAVE_ALL_PROJECTS_FROM_TOOLBAR);
        }
    }

    private class PreferencesActionDelegate
    extends AbstractAction {
        public PreferencesActionDelegate() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/preferences_toolbar_icon.png"));
            this.putValue("ShortDescription", "Sets Global SoapUI Preferences");
            this.putValue("Name", "Preferences");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUIPreferencesAction.getInstance().actionPerformed(null);
            Analytics.trackAction(SoapUIActions.OPEN_PREFERENCES_FROM_TOOLBAR);
        }
    }

    private class ApplyProxyButtonAction
    extends AbstractAction {
        public ApplyProxyButtonAction() {
            this.putValue("Name", "Proxy");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ProxyUtils.isProxyEnabled()) {
                SoapUI.getSettings().setBoolean(ProxySettings.ENABLE_PROXY, false);
                Analytics.trackAction(SoapUIActions.TURN_OFF_PROXY_FROM_TOOLBAR);
            } else {
                if (!ProxyUtils.isAutoProxy() && this.emptyManualSettings()) {
                    SoapUI.getSettings().setBoolean(ProxySettings.AUTO_PROXY, true);
                }
                SoapUI.getSettings().setBoolean(ProxySettings.ENABLE_PROXY, true);
                Analytics.trackAction(SoapUIActions.TURN_ON_PROXY_FROM_TOOLBAR);
            }
            SoapUI.updateProxyFromSettings();
        }

        private boolean emptyManualSettings() {
            return StringUtils.isNullOrEmpty(SoapUI.getSettings().getString(ProxySettings.HOST, "")) || StringUtils.isNullOrEmpty(SoapUI.getSettings().getString(ProxySettings.PORT, ""));
        }
    }

    private class ToolbarForumSearchAction
    extends AbstractAction {
        public ToolbarForumSearchAction() {
            this.putValue("ShortDescription", "Searches the Smartbear Community Forum");
            this.putValue("SmallIcon", UISupport.createImageIcon("/find.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUI.doCommunitySearch(SoapUI.this.searchField.getText());
        }
    }

    public class MaximizeDesktopAction
    extends AbstractAction {
        private JLogList lastLog;
        private int lastMainDividerLocation;
        private final InspectorLog4JMonitor log4JMonitor;
        private int lastLogDividerLocation;

        public MaximizeDesktopAction(InspectorLog4JMonitor log4JMonitor) {
            super("Maximize Desktop");
            this.log4JMonitor = log4JMonitor;
            this.putValue("ShortDescription", "Hides/Shows the Navigator and Log tabs");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu M"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SoapUI.this.mainInspector.getCurrentInspector() != null || logMonitor.getCurrentLog() != null) {
                this.lastMainDividerLocation = SoapUI.this.mainInspector.getDividerLocation();
                SoapUI.this.mainInspector.deactivate();
                this.lastLog = logMonitor.getCurrentLog();
                this.lastLogDividerLocation = this.log4JMonitor.getDividerLocation();
                this.log4JMonitor.deactivate();
            } else {
                SoapUI.this.mainInspector.setCurrentInspector("Navigator");
                SoapUI.this.mainInspector.setDividerLocation(this.lastMainDividerLocation == 0 ? 250 : this.lastMainDividerLocation);
                this.log4JMonitor.setCurrentLog(this.lastLog);
                this.log4JMonitor.setDividerLocation(this.lastLogDividerLocation == 0 ? 500 : this.lastLogDividerLocation);
            }
        }
    }

    private static class ShowStarterPageAction
    extends AbstractAction {
        public ShowStarterPageAction() {
            super("Starter Page");
            this.putValue("ShortDescription", "Shows the starter page");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUI.showStarterPage();
        }
    }

    private class SearchForumAction
    extends AbstractAction {
        public SearchForumAction() {
            super("Search Forum");
            this.putValue("ShortDescription", "Searches the Smartbear Community Forum");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = UISupport.prompt("Search Text", "Search Community Forum", "");
            if (text == null) {
                return;
            }
            SoapUI.doCommunitySearch(text);
        }
    }

    private static class AboutAction
    extends AbstractAction {
        private static final String COPYRIGHT = "2004-" + Calendar.getInstance().get(1) + " smartbear.com";
        private static final String SOAPUI_WEBSITE = "http://www.soapui.org";
        private static final String SMARTBEAR_WEBSITE = "http://www.smartbear.com";

        public AboutAction() {
            super("About SoapUI");
            this.putValue("ShortDescription", "Shows information on SoapUI");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            URI splashURI = null;
            try {
                splashURI = UISupport.findSplash(SoapUI.SOAPUI_ABOUT).toURI();
            }
            catch (URISyntaxException e1) {
                SoapUI.logError(e1);
            }
            Properties buildInfoProperties = new Properties();
            try {
                buildInfoProperties.load(SoapUI.class.getResourceAsStream(SoapUI.BUILDINFO_PROPERTIES));
            }
            catch (Exception exception) {
                SoapUI.logError(exception, "Could not read build info properties");
            }
            Font font = UISupport.getEditorFont();
            String fontFamily = font.getFamily();
            String info = "<html><body style=\"margin:0;padding:0;\"><div style=\"flex: 1;background-image: url(" + splashURI + "); background-repeat: no-repeat;width: 457px;height: 301px;\"><p style=\"margin-top: 85px;margin-left: 30px;color:black;\"><font size=\"13px\" face=\"" + fontFamily + "\">SoapUI " + SOAPUI_VERSION + "<br>Copyright (C) " + COPYRIGHT + "<br><a href=\"http://www.soapui.org\">http://www.soapui.org</a> | <a href=\"http://www.smartbear.com\">http://www.smartbear.com</a><br><br>Build Date: " + (String)Objects.firstNonNull((Object)buildInfoProperties.getProperty("build.date"), (Object)"UNKNOWN BUILD DATE") + "<br></font></p></div></body></html>";
            JDialog dialog = new JDialog();
            dialog.setIconImages(SoapUI.getFrameIcons());
            dialog.setTitle("About SoapUI");
            dialog.setModal(true);
            dialog.setResizable(false);
            JPanel panel = new JPanel(new BorderLayout());
            JEditorPane editorPane = new JEditorPane("text/html", info);
            editorPane.setBorder(BorderFactory.createEmptyBorder());
            editorPane.setCaretPosition(0);
            editorPane.setEditable(false);
            editorPane.addHyperlinkListener(new DefaultHyperlinkListener(editorPane));
            JPanel buttonBar = ButtonBarFactory.buildRightAlignedBar((JButton)new JButton(new OkAction("OK", dialog)));
            buttonBar.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
            panel.add((Component)buttonBar, "South");
            dialog.getRootPane().setContentPane(panel);
            dialog.setSize(new Dimension(493, 310));
            dialog.add(editorPane);
            UISupport.showDialog(dialog);
        }

        private final class OkAction
        extends AbstractAction {
            private JDialog dialog;

            public OkAction(String name, JDialog dialog) {
                super(name);
                this.dialog = dialog;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.dialog.setVisible(false);
            }
        }
    }

    private class SavePreferencesAction
    extends AbstractAction {
        public SavePreferencesAction() {
            super("Save Preferences");
            this.putValue("ShortDescription", "Saves all global preferences");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                soapUICore.saveSettings();
                Analytics.trackAction(SoapUIActions.SAVE_PREFERENCES);
            }
            catch (Exception e1) {
                SoapUI.logError(e1, "There was an error when attempting to save your preferences");
                UISupport.showErrorMessage(e1);
            }
        }
    }

    public static class ImportPreferencesAction
    extends AbstractAction {
        public static final String IMPORT_PREFERENCES_ACTION_NAME = "Import Preferences";

        public ImportPreferencesAction() {
            super(IMPORT_PREFERENCES_ACTION_NAME);
            this.putValue("ShortDescription", "Imports SoapUI Settings from another settings-file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                File file = UISupport.getFileDialogs().open(null, IMPORT_PREFERENCES_ACTION_NAME, ".xml", "SoapUI Settings XML (*.xml)", null);
                if (file != null) {
                    soapUICore.importSettings(file);
                    Analytics.trackAction(SoapUIActions.IMPORT_PREFERENCES);
                }
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super("Exit");
            this.putValue("ShortDescription", "Saves all projects and exits SoapUI");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu Q"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUI.this.saveOnExit = true;
            WindowEvent windowEvent = new WindowEvent(frame, 201);
            Analytics.trackAction(SoapUIActions.EXIT);
            frame.dispatchEvent(windowEvent);
        }
    }

    private class ExitWithoutSavingAction
    extends AbstractAction {
        public ExitWithoutSavingAction() {
            super("Exit without saving");
            this.putValue("ShortDescription", "Exits SoapUI without saving");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("ctrl shift Q"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SoapUI.this.saveOnExit = false;
            WindowEvent windowEvent = new WindowEvent(frame, 201);
            frame.dispatchEvent(windowEvent);
        }
    }

    private static final class SoapUIRunner
    implements Runnable {
        private SoapUIRunner() {
        }

        @Override
        public void run() {
            boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
            StandaloneSoapUICore standaloneSoapUICore = new StandaloneSoapUICore(true);
            SoapUIUpdateProvider updateProvider = SoapUIAutoUpdaterUtils.getProvider();
            if (!isDebug && SoapUI.getSettings().getBoolean(VersionUpdateSettings.AUTO_CHECK_VERSION_UPDATE)) {
                updateProvider.start();
            }
            SoapUI.addStandardPreferencesShortcutOnMac();
            Properties props = new Properties();
            try {
                props.load(SoapUI.class.getResourceAsStream(SoapUI.SOAPUI_TITLE));
                Object brandedTitleExt = props.getProperty("soapui.app.title");
                brandedTitleExt = !StringUtils.isNullOrEmpty((String)brandedTitleExt) ? " - " + (String)brandedTitleExt : "";
                SoapUI.startSoapUI(mainArgs, "SoapUI " + SOAPUI_VERSION + " " + (String)brandedTitleExt, standaloneSoapUICore);
                if (SoapUI.getSettings().getBoolean(UISettings.SHOW_STARTUP_PAGE) && !SoapUI.isBrowserDisabled()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SoapUI.showStarterPage();
                        }
                    });
                }
                if (SoapUI.isCommandLine()) {
                    Analytics.trackAction(SoapUIActions.PRODUCT_STARTED_FROM_CMD);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    protected static class WindowInitializationTask
    implements Runnable {
        protected WindowInitializationTask() {
        }

        @Override
        public void run() {
            this.expandWindow(frame);
            frame.setVisible(true);
        }

        private void expandWindow(JFrame frame) {
            UserPreferences userPreferences = new UserPreferences();
            Rectangle savedWindowBounds = userPreferences.getSoapUIWindowBounds();
            if (savedWindowBounds == null || !this.windowFullyVisibleOnScreen(savedWindowBounds)) {
                Rectangle availableScreenArea = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                frame.setBounds(availableScreenArea);
            } else {
                frame.setBounds(savedWindowBounds);
                if (!UISupport.isMac()) {
                    frame.setExtendedState(userPreferences.getSoapUIExtendedState());
                }
            }
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    try {
                        JFrame frame = (JFrame)event.getWindow();
                        UserPreferences userPreferences = new UserPreferences();
                        userPreferences.setSoapUIWindowBounds(frame.getBounds());
                        userPreferences.setSoapUIExtendedState(frame.getExtendedState());
                    }
                    catch (BackingStoreException e) {
                        SoapUI.logError(e, "Could not save SoapUI window bounds");
                    }
                }
            });
        }

        private boolean windowFullyVisibleOnScreen(Rectangle windowBounds) {
            Rectangle bargainBounds = new Rectangle(windowBounds.x + 12, windowBounds.y + 12, windowBounds.width * 4 / 5, windowBounds.height * 4 / 5);
            for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                if (!graphicsDevice.getDefaultConfiguration().getBounds().contains(bargainBounds)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class WsdlProjectCreator
    implements Runnable {
        private final String arg;

        public WsdlProjectCreator(String arg) {
            this.arg = arg;
        }

        @Override
        public void run() {
            SoapUIAction action = SoapUI.getActionRegistry().getAction("NewWsdlProjectAction");
            if (action != null) {
                action.perform(SoapUI.getWorkspace(), this.arg);
            }
        }
    }

    private static final class RestProjectCreator
    implements Runnable {
        private final URL arg;

        public RestProjectCreator(URL arg) {
            this.arg = arg;
        }

        @Override
        public void run() {
            try {
                WsdlProject project = (WsdlProject)SoapUI.getWorkspace().createProject(this.arg.getHost(), null);
                SoapUIAction action = SoapUI.getActionRegistry().getAction("NewRestServiceAction");
                if (action != null) {
                    action.perform(project, this.arg);
                }
            }
            catch (SoapUIException e) {
                e.printStackTrace();
            }
        }
    }

    private static class AutoSaveTimerTask
    extends TimerTask {
        private AutoSaveTimerTask() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SoapUI.log("Autosaving Workspace");
                    WorkspaceImpl workspaceImplementation = (WorkspaceImpl)SoapUI.getWorkspace();
                    if (workspaceImplementation != null) {
                        workspaceImplementation.save(false, true);
                    }
                }
            });
        }
    }

    private static class GCTimerTask
    extends TimerTask {
        private GCTimerTask() {
        }

        @Override
        public void run() {
            System.gc();
        }
    }
}

