/*
 * Decompiled with CFR 0.152.
 */
package xmlparser;

import commandline.Debug;
import commandline.HaltHandler;
import core.Starter;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openqa.selenium.By;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlConfigReader {
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private Document document;
    private Element root;
    private String xmlFilename;
    private Map<String, String> Parameters = new HashMap<String, String>();
    private int method = 0;
    boolean empty_paramtoinject_flag = false;

    public int getMethod() {
        return this.method;
    }

    public XmlConfigReader(String xmlConfigFile_Name) {
        this.factory = DocumentBuilderFactory.newInstance();
        this.xmlFilename = xmlConfigFile_Name;
        try {
            this.builder = this.factory.newDocumentBuilder();
            this.document = this.builder.parse(new File(xmlConfigFile_Name));
        }
        catch (ParserConfigurationException e) {
            Debug.printError("ERROR: unable to parse the XML configuration file.\n" + e.getMessage());
            HaltHandler.quit_nok();
        }
        catch (IOException e) {
            Debug.printError("ERROR: unable to open the XML configuration file.\n" + e.getMessage());
            HaltHandler.quit_nok();
        }
        catch (SAXException e) {
            Debug.printError("ERROR: unable to parse the XML configuration file.\n" + e.getMessage());
            HaltHandler.quit_nok();
        }
        this.root = this.document.getDocumentElement();
        this.checkType();
    }

    private void checkType() {
        NodeList list1 = this.root.getElementsByTagName("get");
        NodeList list2 = this.root.getElementsByTagName("post");
        if (list1.getLength() == 0 && list2.getLength() == 0) {
            Debug.printError("ERROR: invalid use case ( " + this.xmlFilename + " )");
            HaltHandler.quit_nok();
        }
        if (list1.getLength() != 0) {
            this.method = 1;
        } else if (list2.getLength() != 0) {
            this.method = 2;
            this.setParameters();
        }
    }

    private String getCompleteTargetURL() {
        String url = this.GetTargetUrl() + "?";
        NodeList list = this.root.getElementsByTagName("parameter");
        for (int i = 0; i < list.getLength(); ++i) {
            url = url + "&" + list.item(i).getTextContent();
        }
        return url;
    }

    private String GetTargetUrl() {
        String targetURL = this.getTextContentByName("targeturl");
        if (targetURL == null) {
            Debug.printError("ERROR: missing <targeturl> ( " + this.xmlFilename + " )");
            HaltHandler.quit_nok();
        }
        return targetURL;
    }

    private String GetReflectionUrl() {
        return this.getTextContentByName("reflectionurl");
    }

    private String GetParamToInject() {
        String param = this.getTextContentByName("paramtoinject");
        if (param == null) {
            Debug.printError("ERROR: missing <paramtoinject> ( " + this.xmlFilename + " ).");
            HaltHandler.quit_nok();
        }
        if (param.equals("") && !this.empty_paramtoinject_flag) {
            String t_url = this.GetTargetUrl();
            Debug.print("INFO: <paramtoinject> is empty ( " + this.xmlFilename + " ). Injecting in the form of: " + (t_url.endsWith("/") ? t_url : t_url + "/") + "injection");
            this.empty_paramtoinject_flag = true;
        }
        return param;
    }

    private String getTextContentByName(String tagName) {
        if (this.root.getElementsByTagName(tagName).getLength() != 0) {
            return this.root.getElementsByTagName(tagName).item(0).getTextContent();
        }
        return null;
    }

    private void setParameters() {
        NodeList list = this.root.getElementsByTagName("parameter");
        for (int i = 0; i < list.getLength(); ++i) {
            NodeList subChild = list.item(i).getChildNodes();
            String name = subChild.item(1).getTextContent();
            String value = subChild.item(3).getTextContent();
            this.Parameters.put(name, value);
        }
    }

    public void commonInject(WebDriver driver, String injection, int delay) {
        if (delay != 0) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Debug.printError("Error: " + e.getMessage());
                HaltHandler.quit_nok();
            }
        }
        if (this.method == 1) {
            String target_url;
            block51: {
                target_url = "";
                try {
                    target_url = this.GetParamToInject().equals("") ? (this.GetTargetUrl().endsWith("/") ? this.GetTargetUrl() : this.GetTargetUrl() + "/") + URLEncoder.encode(injection, "UTF-8") : this.getCompleteTargetURL() + "&" + this.GetParamToInject() + "=" + URLEncoder.encode(injection, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Debug.printError("\nERROR: unable to encode the target URL");
                    HaltHandler.quit_nok();
                }
                try {
                    if (Starter.getCurrentBrowser() != null && Starter.getCurrentBrowser().contains("Chrome") && (this.GetReflectionUrl() == null || this.GetReflectionUrl().equals(""))) {
                        try {
                            driver.get("data:text/html,<a href='" + URLEncoder.encode(target_url, "UTF-8") + "'>go</click>");
                        }
                        catch (UnsupportedEncodingException e) {
                            Debug.printError("\nERROR: unable to encode the target URL");
                            HaltHandler.quit_nok();
                        }
                        driver.findElements(By.xpath("//a")).get(0).click();
                        break block51;
                    }
                    driver.get(target_url);
                }
                catch (UnhandledAlertException e) {
                    Starter.refreshDriver();
                    Debug.printError("\nERROR: the last injection resulted in a denial of service! Starting a new driver to continue the injection process");
                }
                catch (WebDriverException e) {
                    Starter.refreshDriver();
                    Debug.printError("\nINFO: an alert dialog window was blocking the injection process, starting a new driver...");
                }
            }
            if (this.GetReflectionUrl() != null && !this.GetReflectionUrl().equals("")) {
                if (Starter.getCurrentBrowser() != null && Starter.getCurrentBrowser().contains("Chrome")) {
                    try {
                        driver.get("data:text/html,<a href='" + URLEncoder.encode(target_url, "UTF-8") + "'>go</click>");
                    }
                    catch (UnsupportedEncodingException e) {
                        Debug.printError("\nERROR: unable to encode the target URL");
                        HaltHandler.quit_nok();
                    }
                    driver.findElements(By.xpath("//a")).get(0).click();
                } else {
                    driver.get(this.GetReflectionUrl());
                }
            }
        } else if (this.method == 2) {
            NodeList commands = this.root.getElementsByTagName("name");
            NodeList targets = this.root.getElementsByTagName("target");
            NodeList values = this.root.getElementsByTagName("value");
            if (commands.getLength() == 0 || targets.getLength() == 0 || values.getLength() == 0) {
                Debug.printError("ERROR: malformed <command> tags ( " + this.xmlFilename + " )");
                HaltHandler.quit_nok();
            } else if (commands.getLength() - this.Parameters.size() != targets.getLength() || commands.getLength() != values.getLength()) {
                Debug.printError("ERROR: malformed <command> tags ( " + this.xmlFilename + " )");
                HaltHandler.quit_nok();
            }
            for (int i = this.Parameters.size(); i < commands.getLength(); ++i) {
                String name = commands.item(i).getTextContent();
                String target = this.root.getElementsByTagName("target").item(i - this.Parameters.size()).getTextContent();
                String value = this.root.getElementsByTagName("value").item(i).getTextContent();
                WebElement ele = null;
                try {
                    if (target.startsWith("id=")) {
                        ele = driver.findElement(By.id(target.replace("id=", "")));
                    } else if (target.startsWith("xpath=")) {
                        ele = driver.findElement(By.xpath(target.replace("xpath=", "")));
                    } else if (target.startsWith("name=")) {
                        ele = driver.findElement(By.name(target.replace("name=", "")));
                    }
                }
                catch (Exception e) {
                    Debug.printError("\nERROR: unable select the element [" + target + "]");
                    Starter.brokenPage();
                }
                if (name.equals("open")) {
                    try {
                        if (value.equals("noforce")) {
                            if (XmlConfigReader.stripFragmentFromCurrentURL(driver).equals(target)) continue;
                            driver.get(target);
                            continue;
                        }
                        driver.get(target);
                    }
                    catch (UnhandledAlertException e) {
                        Starter.refreshDriver();
                        Debug.printError("\nERROR: the last injection resulted in a denial of service! Starting a new browser instance to continue the injection process");
                    }
                    catch (WebDriverException e) {
                        Starter.refreshDriver();
                        Debug.printError("\nERROR: the last injection resulted in a denial of service! Starting a new browser instance to continue the injection process");
                    }
                    continue;
                }
                if (name.equals("type")) {
                    try {
                        if (value.startsWith("${") && value.endsWith("}")) {
                            if (value.substring(2, value.length() - 1).equals("RANDOM")) {
                                ele.sendKeys("" + new Random().nextInt(100000));
                                continue;
                            }
                            if (value.substring(2, value.length() - 1).equals("RANDOM_EMAIL")) {
                                ele.sendKeys(new Random().nextInt(100000) + "@" + new Random().nextInt(100000) + ".org");
                                continue;
                            }
                            if (value.substring(2, value.length() - 1).equals("INJECTION")) {
                                ele.sendKeys(injection != null ? injection : "");
                                continue;
                            }
                            ele.sendKeys(this.Parameters.get(value.toLowerCase().replace("$", "").replace("{", "").replace("}", "")));
                            continue;
                        }
                        if (value.equals("")) {
                            ele.clear();
                            continue;
                        }
                        ele.sendKeys(value);
                    }
                    catch (NullPointerException e) {
                        Debug.printError("\nERROR: cannot find the element defined through [" + target + "]");
                        Starter.brokenPage();
                    }
                    continue;
                }
                if (name.equals("submit")) {
                    try {
                        ele.submit();
                    }
                    catch (NullPointerException e) {
                        Debug.printError("\nERROR: cannot find the element defined through [" + target + "]");
                        Starter.brokenPage();
                    }
                    continue;
                }
                if (name.equals("deleteCookies")) {
                    try {
                        driver.manage().deleteAllCookies();
                    }
                    catch (NullPointerException e) {
                        Debug.printError("\nERROR: cannot find the element defined through [" + target + "]");
                        Starter.brokenPage();
                    }
                    continue;
                }
                if (!name.equals("click")) continue;
                try {
                    ele.click();
                    continue;
                }
                catch (NullPointerException e) {
                    Debug.printError("\nERROR: cannot find the element defined through [" + target + "]");
                    Starter.brokenPage();
                }
            }
        }
    }

    private static String stripFragmentFromCurrentURL(WebDriver current_driver) {
        String current_url = current_driver.getCurrentUrl();
        int t = current_url.indexOf("#");
        if (t != -1) {
            return current_url.substring(0, t);
        }
        return current_url;
    }

    public static String generateReflectedConfigFile(String targetURL, String targetParam) {
        URL tmp = null;
        LinkedList<String> parameters = null;
        String params = "";
        try {
            tmp = new URL(targetURL);
        }
        catch (MalformedURLException e) {
            Debug.printError("ERROR: unable to parse the supplied URL (" + targetURL + ")");
            HaltHandler.quit_nok();
        }
        if (tmp.getQuery() != null) {
            parameters = XmlConfigReader.getQueryMap(tmp.getQuery());
            for (String p : parameters) {
                params = params + "\t\t\t<parameter>" + p.split("=")[0] + (p.split("=")[1].equals("") ? "" : "=" + p.split("=")[1]);
                params = params + "</parameter>\n";
            }
        }
        return "<root>\n\t<get>\n\t\t<parameters>\n\t\t\t<targeturl>" + (targetURL.split("\\?") != null ? targetURL.split("\\?")[0] : targetURL) + "</targeturl>\n\t\t\t<paramtoinject>" + targetParam + "</paramtoinject>\n" + params + "\t\t</parameters>\n\t</get>\n</root>\n";
    }

    public static LinkedList<String> getQueryMap(String query) {
        String[] params = query.split("&");
        LinkedList<String> parameters = new LinkedList<String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = null;
            if (param.split("=").length == 2) {
                value = param.split("=")[1];
            }
            parameters.add(name + "=" + (value == null ? "" : value));
        }
        return parameters;
    }
}

