/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import org.openqa.selenium.safari.SafariDriverConnection;
import org.webbitserver.BaseWebSocketHandler;
import org.webbitserver.WebSocketConnection;

class SafariDriverWebSocketHandler
extends BaseWebSocketHandler {
    private static final Logger LOG = Logger.getLogger(SafariDriverWebSocketHandler.class.getName());
    private final BlockingQueue<SafariDriverConnection> connectionQueue;
    private final Map<WebSocketConnection, SafariDriverConnection> connections;

    public SafariDriverWebSocketHandler(BlockingQueue<SafariDriverConnection> connectionQueue) {
        this.connectionQueue = Preconditions.checkNotNull(connectionQueue);
        this.connections = Maps.newHashMap();
    }

    public void onOpen(WebSocketConnection connection) throws Exception {
        LOG.info("Connection opened");
        SafariDriverConnection safariConnection = new SafariDriverConnection(connection);
        this.connectionQueue.put(safariConnection);
        this.connections.put(connection, safariConnection);
    }

    public void onClose(WebSocketConnection connection) throws Exception {
        LOG.info("Connection closed");
        if (this.connections.remove(connection) == null) {
            LOG.warning("Closed unregistered connection");
        }
    }

    public void onMessage(WebSocketConnection connection, String msg) throws Throwable {
        LOG.fine("Received message: " + msg);
        SafariDriverConnection safariConnection = this.connections.get(connection);
        if (safariConnection == null) {
            LOG.warning("Received message from unregistered connection");
        } else {
            safariConnection.onMessage(msg);
        }
    }
}

