/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.JsonException;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.webbitserver.WebSocketConnection;

class SafariDriverConnection {
    private static final Logger LOG = Logger.getLogger(SafariDriverConnection.class.getName());
    private final WebSocketConnection connection;
    private final BlockingQueue<SafariCommand> commands;
    private final BlockingQueue<Response> responses;

    public SafariDriverConnection(WebSocketConnection connection) {
        this.connection = connection;
        this.commands = new LinkedBlockingQueue<SafariCommand>();
        this.responses = new LinkedBlockingQueue<Response>();
    }

    public Response send(Command command) throws InterruptedException {
        Preconditions.checkState(this.commands.peek() == null, "Currently waiting on a command response");
        SafariCommand safariCommand = new SafariCommand(command);
        this.commands.put(safariCommand);
        String rawJsonCommand = new BeanToJsonConverter().convert(safariCommand);
        try {
            JSONObject message = new JSONObject().put("origin", "webdriver").put("type", "command").put("command", new JSONObject(rawJsonCommand));
            this.connection.send(message.toString());
        }
        catch (JSONException e) {
            throw new JsonException(e);
        }
        return this.responses.poll(3L, TimeUnit.MINUTES);
    }

    void onMessage(String message) {
        Response response;
        LOG.info("Processing message: " + message);
        SafariCommand command = (SafariCommand)this.commands.poll();
        if (command == null) {
            LOG.warning("Was not expecting a response!");
            return;
        }
        try {
            JSONObject jsonResponse = new JSONObject(message);
            response = new JsonToBeanConverter().convert(Response.class, jsonResponse.getJSONObject("response").toString());
            if (response.getStatus() == 0) {
                Preconditions.checkArgument(command.getId().equals(jsonResponse.getString("id")), "Response ID<%s> does not match command ID<%s>", jsonResponse.getString("id"), command.getId());
            }
        }
        catch (Exception e) {
            response = new Response(command.getSessionId());
            response.setStatus(new ErrorCodes().toStatusCode(e));
            response.setValue(new WebDriverException("Invalid response", e));
        }
        if (!this.responses.offer(response)) {
            LOG.warning("Unable to offer response");
        }
    }

    private static class SafariCommand
    extends Command {
        private final UUID id = UUID.randomUUID();

        private SafariCommand(Command command) {
            super(command.getSessionId(), command.getName(), command.getParameters());
        }

        public String getId() {
            return this.id.toString();
        }
    }
}

