/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.html5;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.html5.DatabaseStorage;
import org.openqa.selenium.html5.ResultSet;
import org.openqa.selenium.html5.ResultSetRows;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.InterfaceImplementation;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;

public class AddDatabaseStorage
implements AugmenterProvider {
    @Override
    public Class<?> getDescribedInterface() {
        return DatabaseStorage.class;
    }

    @Override
    public InterfaceImplementation getImplementation(Object value) {
        return new InterfaceImplementation(){

            @Override
            public Object invoke(ExecuteMethod executeMethod, Object self, Method method, Object ... args) {
                String databaseName = (String)args[0];
                String query = (String)args[1];
                Object[] arguments = (Object[])args[2];
                query.replaceAll("\"", "\\\"");
                Iterable<Object> convertedArgs = Iterables.transform(Lists.newArrayList(arguments), new WebElementToJsonConverter());
                ImmutableMap<String, ArrayList<Object>> params = ImmutableMap.of("dbName", databaseName, "query", query, "args", Lists.newArrayList(convertedArgs));
                Map resultAsMap = (Map)executeMethod.execute("executeSQL", params);
                ResultSet rs = new ResultSet(((Long)resultAsMap.get("insertId")).intValue(), ((Long)resultAsMap.get("rowsAffected")).intValue(), new ResultSetRows((List)resultAsMap.get("rows")));
                return rs;
            }
        };
    }
}

