/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.ie.InternetExplorerDriverServer;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerElement;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;
import org.openqa.selenium.remote.service.DriverCommandExecutor;

public class InternetExplorerDriver
extends RemoteWebDriver
implements TakesScreenshot {
    public static final String INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS = "ignoreProtectedModeSettings";
    private InternetExplorerDriverServer server;
    private WindowsProxyManager proxyManager;
    private boolean useLegacyServer = false;

    public InternetExplorerDriver() {
        this.assertOnWindows();
        this.setup(DesiredCapabilities.internetExplorer(), 0);
    }

    public InternetExplorerDriver(Capabilities capabilities) {
        this.assertOnWindows();
        this.proxyManager = new WindowsProxyManager(true, "webdriver-ie", 0, 0);
        this.prepareProxy(capabilities);
        this.setup(capabilities, 0);
    }

    public InternetExplorerDriver(int port) {
        this.assertOnWindows();
        this.setup(DesiredCapabilities.internetExplorer(), port);
    }

    public InternetExplorerDriver(InternetExplorerDriverService service) {
        this(service, (Capabilities)DesiredCapabilities.internetExplorer());
    }

    public InternetExplorerDriver(InternetExplorerDriverService service, Capabilities capabilities) {
        this.assertOnWindows();
        this.setCommandExecutor(new DriverCommandExecutor(service));
        this.startSession(capabilities);
    }

    @Override
    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    @Override
    public <X> X getScreenshotAs(OutputType<X> target) {
        String base64 = this.execute("screenshot").getValue().toString();
        return target.convertFromBase64Png(base64);
    }

    protected void assertOnWindows() {
        Platform current = Platform.getCurrent();
        if (!current.is(Platform.WINDOWS)) {
            throw new WebDriverException(String.format("You appear to be running %s. The IE driver only runs on Windows.", new Object[]{current}));
        }
    }

    private void setup(Capabilities capabilities, int port) {
        this.setupService(capabilities.is("useLegacyInternalServer"), port);
        this.startSession(capabilities);
    }

    private void setupService(boolean useLegacyInternalServer, int port) {
        if (useLegacyInternalServer) {
            this.setupLegacyServer(port);
        } else {
            try {
                InternetExplorerDriverService service = new InternetExplorerDriverService.Builder().usingPort(port).build();
                this.setCommandExecutor(new DriverCommandExecutor(service));
            }
            catch (IllegalStateException ex) {
                System.err.println(ex.getMessage());
                this.setupLegacyServer(port);
            }
        }
    }

    @Override
    protected void startSession(Capabilities desiredCapabilities) {
        this.setElementConverter(new JsonToWebElementConverter(this){

            @Override
            protected RemoteWebElement newRemoteWebElement() {
                return new InternetExplorerElement(InternetExplorerDriver.this);
            }
        });
        super.startSession(desiredCapabilities);
    }

    private void setupLegacyServer(int port) {
        this.useLegacyServer = true;
        this.server = new InternetExplorerDriverServer(port);
        this.startClient();
        this.setCommandExecutor(new HttpCommandExecutor(this.server.getUrl()));
    }

    @Override
    protected void startClient() {
        if (this.useLegacyServer) {
            this.server.start();
        }
    }

    @Override
    protected void stopClient() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private void prepareProxy(Capabilities caps) {
        if (caps == null || caps.getCapability("proxy") == null) {
            return;
        }
        this.proxyManager.backupRegistrySettings();
        this.proxyManager.changeRegistrySettings(caps);
        Thread cleanupThread = new Thread(){

            @Override
            public void run() {
                InternetExplorerDriver.this.proxyManager.restoreRegistrySettings(true);
            }
        };
        Runtime.getRuntime().addShutdownHook(cleanupThread);
    }
}

