/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.AbstractCSSRuleImpl;
import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.stylesheets.MediaList;

public class CSSMediaRuleImpl
extends AbstractCSSRuleImpl
implements CSSMediaRule,
Serializable {
    private static final long serialVersionUID = 6603734096445214651L;
    private MediaList media = null;
    private CSSRuleList cssRules = null;

    public void setMedia(MediaList media) {
        this.media = media;
    }

    public void setCssRules(CSSRuleList cssRules) {
        this.cssRules = cssRules;
    }

    public CSSMediaRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, MediaList media) {
        super(parentStyleSheet, parentRule);
        this.media = media;
    }

    public CSSMediaRuleImpl() {
    }

    public short getType() {
        return 4;
    }

    public String getCssText() {
        StringBuffer sb = new StringBuffer("@media ");
        sb.append(this.getMedia().toString()).append(" {");
        for (int i = 0; i < this.getCssRules().getLength(); ++i) {
            CSSRule rule = this.getCssRules().item(i);
            sb.append(rule.getCssText()).append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    public void setCssText(String cssText) throws DOMException {
        if (this.parentStyleSheet != null && this.parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 4) {
                throw new DOMExceptionImpl(13, 7);
            }
            this.media = ((CSSMediaRuleImpl)r).media;
            this.cssRules = ((CSSMediaRuleImpl)r).cssRules;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public MediaList getMedia() {
        return this.media;
    }

    public CSSRuleList getCssRules() {
        if (this.cssRules == null) {
            this.cssRules = new CSSRuleListImpl();
        }
        return this.cssRules;
    }

    public int insertRule(String rule, int index) throws DOMException {
        if (this.parentStyleSheet != null && this.parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(rule));
            CSSOMParser parser = new CSSOMParser();
            parser.setParentStyleSheet(this.parentStyleSheet);
            CSSRule r = parser.parseRule(is);
            ((CSSRuleListImpl)this.getCssRules()).insert(r, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        return index;
    }

    public void deleteRule(int index) throws DOMException {
        if (this.parentStyleSheet != null && this.parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            ((CSSRuleListImpl)this.getCssRules()).delete(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DOMExceptionImpl(1, 1, e.getMessage());
        }
    }

    public void setRuleList(CSSRuleListImpl rules) {
        this.cssRules = rules;
    }

    public String toString() {
        return this.getCssText();
    }
}

