/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.ContextFactory;
import net.sourceforge.htmlunit.corejs.javascript.debug.DebuggableScript;
import net.sourceforge.htmlunit.corejs.javascript.tools.debugger.Main;
import net.sourceforge.htmlunit.corejs.javascript.tools.debugger.ScopeProvider;
import net.sourceforge.htmlunit.corejs.javascript.tools.debugger.SourceProvider;
import org.apache.commons.lang.StringUtils;

public final class WebClientUtils {
    private WebClientUtils() {
    }

    public static void attachVisualDebugger(final WebClient client) {
        ScopeProvider sp = null;
        HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
        Main main = Main.mainEmbedded((ContextFactory)cf, sp, "HtmlUnit JavaScript Debugger");
        SourceProvider sourceProvider = new SourceProvider(){

            public String getSource(DebuggableScript script) {
                String sourceName = script.getSourceName();
                if (sourceName.endsWith("(eval)")) {
                    return null;
                }
                if (sourceName.startsWith("script in ")) {
                    sourceName = StringUtils.substringBetween(sourceName, "script in ", " from");
                    for (WebWindow ww : client.getWebWindows()) {
                        WebResponse wr = ww.getEnclosedPage().getWebResponse();
                        if (!sourceName.equals(wr.getWebRequest().getUrl().toString())) continue;
                        return wr.getContentAsString();
                    }
                }
                return null;
            }
        };
        main.setSourceProvider(sourceProvider);
    }
}

