/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.xml;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomProcessingInstruction;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLAttr;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDOMParseError;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLSerializer;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLDocument
extends Document {
    private static final Log LOG = LogFactory.getLog(XMLDocument.class);
    private boolean async_ = true;
    private boolean preserveWhiteSpace_;
    private XMLDOMParseError parseError_;

    public XMLDocument() {
        this(null);
    }

    public XMLDocument(WebWindow enclosingWindow) {
        if (enclosingWindow != null) {
            try {
                XmlPage page = new XmlPage((WebResponse)null, enclosingWindow);
                this.setDomNode(page);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError("IOException: " + e);
            }
        }
    }

    public void jsxSet_async(boolean async) {
        this.async_ = async;
    }

    public boolean jsxGet_async() {
        return this.async_;
    }

    public boolean jsxFunction_load(String xmlSource) {
        if (this.async_ && LOG.isDebugEnabled()) {
            LOG.debug("XMLDocument.load(): 'async' is true, currently treated as false.");
        }
        try {
            HtmlPage htmlPage = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
            WebRequest request = new WebRequest(htmlPage.getFullyQualifiedUrl(xmlSource));
            WebResponse webResponse = this.getWindow().getWebWindow().getWebClient().loadWebResponse(request);
            XmlPage page = new XmlPage(webResponse, this.getWindow().getWebWindow(), false);
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            XMLDOMParseError parseError = this.jsxGet_parseError();
            parseError.setErrorCode(-1);
            parseError.setFilepos(1);
            parseError.setLine(1);
            parseError.setLinepos(1);
            parseError.setReason(e.getMessage());
            parseError.setSrcText("xml");
            parseError.setUrl(xmlSource);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error parsing XML from '" + xmlSource + "'", e);
            }
            return false;
        }
    }

    public boolean jsxFunction_loadXML(String strXML) {
        try {
            WebWindow webWindow = this.getWindow().getWebWindow();
            URL hackUrl = new URL("http://-htmlunit-internal/XMLDocument.loadXML");
            StringWebResponse webResponse = new StringWebResponse(strXML, hackUrl);
            XmlPage page = new XmlPage(webResponse, webWindow);
            this.setDomNode(page);
            return true;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error parsing XML\n" + strXML, e);
            }
            return false;
        }
    }

    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        Node scriptable;
        if (domNode instanceof DomElement && !(domNode instanceof HtmlElement)) {
            scriptable = new Element();
        } else if (domNode instanceof DomAttr) {
            Attr attribute = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_134) ? new XMLAttr() : new Attr();
            scriptable = attribute;
        } else {
            return super.makeScriptableFor(domNode);
        }
        scriptable.setPrototype(this.getPrototype(scriptable.getClass()));
        scriptable.setParentScope(this.getParentScope());
        ((SimpleScriptable)scriptable).setDomNode(domNode);
        return scriptable;
    }

    protected void initParentScope(DomNode domNode, SimpleScriptable scriptable) {
        scriptable.setParentScope(this.getParentScope());
    }

    public XMLDOMParseError jsxGet_parseError() {
        if (this.parseError_ == null) {
            this.parseError_ = new XMLDOMParseError();
            this.parseError_.setPrototype(this.getPrototype(this.parseError_.getClass()));
            this.parseError_.setParentScope(this.getParentScope());
        }
        return this.parseError_;
    }

    public String jsxGet_xml() {
        XMLSerializer seralizer = new XMLSerializer();
        seralizer.setParentScope(this.getWindow());
        seralizer.setPrototype(this.getPrototype(seralizer.getClass()));
        return seralizer.jsxFunction_serializeToString(this.jsxGet_documentElement());
    }

    public boolean jsxGet_preserveWhiteSpace() {
        return this.preserveWhiteSpace_;
    }

    public void jsxSet_preserveWhiteSpace(boolean preserveWhiteSpace) {
        this.preserveWhiteSpace_ = preserveWhiteSpace;
    }

    public void jsxFunction_setProperty(String name, String value) {
    }

    public HTMLCollection jsxFunction_selectNodes(final String expression) {
        boolean attributeChangeSensitive = expression.contains("@");
        String description = "XMLDocument.selectNodes('" + expression + "')";
        final SgmlPage page = this.getPage();
        HTMLCollection collection = new HTMLCollection(page.getDocumentElement(), attributeChangeSensitive, description){

            @Override
            protected List<Object> computeElements() {
                ArrayList<Object> list = new ArrayList<Object>(page.getByXPath(expression));
                return list;
            }
        };
        return collection;
    }

    public Object jsxFunction_selectSingleNode(String expression) {
        HTMLCollection collection = this.jsxFunction_selectNodes(expression);
        if (collection.jsxGet_length() > 0) {
            return collection.get(0, (Scriptable)collection);
        }
        return null;
    }

    public HTMLCollection jsxFunction_getElementsByTagName(final String tagName) {
        DomNode firstChild = ((DomNode)this.getDomNodeOrDie()).getFirstChild();
        if (firstChild == null) {
            return HTMLCollection.emptyCollection(this.getWindow());
        }
        HTMLCollection collection = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false, "XMLDocument.getElementsByTagName"){

            protected boolean isMatching(DomNode node) {
                return node.getLocalName().equals(tagName);
            }
        };
        return collection;
    }

    public Object jsxFunction_getElementById(String id) {
        XmlPage xmlPage = (XmlPage)this.getDomNodeOrDie();
        Object domElement = xmlPage.getFirstByXPath("//*[@id = \"" + id + "\"]");
        if (domElement == null) {
            return null;
        }
        if (domElement instanceof HtmlElement) {
            return ((HtmlElement)domElement).getScriptObject();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getElementById(" + id + "): no HTML DOM node found with this ID");
        }
        return null;
    }

    public Object jsxFunction_nodeFromID(String id) {
        return null;
    }

    public Object jsxFunction_createProcessingInstruction(String target, String data) {
        DomProcessingInstruction node = ((XmlPage)this.getPage()).createProcessingInstruction(target, data);
        return this.getScriptableFor(node);
    }

    public Object jsxFunction_createCDATASection(String data) {
        DomCDataSection node = ((XmlPage)this.getPage()).createCDATASection(data);
        return this.getScriptableFor(node);
    }

    public Object jsxFunction_createNode(Object type, String name, Object namespaceURI) {
        switch ((short)Context.toNumber(type)) {
            case 1: {
                return this.jsxFunction_createElementNS((String)namespaceURI, name);
            }
            case 2: {
                return this.jsxFunction_createAttribute(name);
            }
        }
        throw Context.reportRuntimeError("xmlDoc.createNode(): Unsupported type " + (short)Context.toNumber(type));
    }
}

