/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLLinkElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLStyleElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

public class StyleSheetList
extends SimpleScriptable {
    private HTMLCollection nodes_;

    public StyleSheetList() {
    }

    public StyleSheetList(HTMLDocument document) {
        this.setParentScope(document);
        this.setPrototype(this.getPrototype(this.getClass()));
        boolean cssEnabled = this.getWindow().getWebWindow().getWebClient().isCssEnabled();
        this.nodes_ = cssEnabled ? new HTMLCollection((DomNode)document.getDomNodeOrDie(), true, "stylesheets"){

            protected boolean isMatching(DomNode node) {
                return node instanceof HtmlStyle || node instanceof HtmlLink && "stylesheet".equalsIgnoreCase(((HtmlLink)node).getAttribute("rel"));
            }

            protected HTMLCollection.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                HtmlElement node = event.getHtmlElement();
                if (node instanceof HtmlLink && "rel".equalsIgnoreCase(event.getName())) {
                    return HTMLCollection.EffectOnCache.RESET;
                }
                return HTMLCollection.EffectOnCache.NONE;
            }
        } : HTMLCollection.emptyCollection(this.getWindow());
    }

    public int jsxGet_length() {
        return this.nodes_.jsxGet_length();
    }

    public Object jsxFunction_item(int index) {
        if (index < 0) {
            throw Context.reportRuntimeError("Invalid negative index: " + index);
        }
        if (index >= this.nodes_.jsxGet_length()) {
            return Context.getUndefinedValue();
        }
        HTMLElement element = (HTMLElement)this.nodes_.jsxFunction_item(index);
        CSSStyleSheet sheet = element instanceof HTMLStyleElement ? ((HTMLStyleElement)element).jsxGet_sheet() : ((HTMLLinkElement)element).getSheet();
        return sheet;
    }

    public Object get(int index, Scriptable start) {
        if (this == start) {
            return this.jsxFunction_item(index);
        }
        return super.get(index, start);
    }
}

