/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Range;
import com.gargoylesoftware.htmlunit.javascript.host.TextRange;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selection
extends SimpleScriptable {
    private String type_ = "None";

    @Override
    public Object getDefaultValue(Class<?> hint) {
        boolean ff = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_176);
        if (ff && (String.class.equals(hint) || hint == null)) {
            StringBuilder sb = new StringBuilder();
            for (org.w3c.dom.ranges.Range r : this.getRanges()) {
                sb.append(((Object)r).toString());
            }
            return sb.toString();
        }
        return super.getDefaultValue(hint);
    }

    public Node jsxGet_anchorNode() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return null;
        }
        return (Node)this.getScriptableNullSafe(last.getStartContainer());
    }

    public int jsxGet_anchorOffset() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return 0;
        }
        return last.getStartOffset();
    }

    public Node jsxGet_focusNode() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return null;
        }
        return (Node)this.getScriptableNullSafe(last.getEndContainer());
    }

    public int jsxGet_focusOffset() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last == null) {
            return 0;
        }
        return last.getEndOffset();
    }

    public boolean jsxGet_isCollapsed() {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        return ranges.isEmpty() || ranges.size() == 1 && ranges.get(0).getCollapsed();
    }

    public int jsxGet_rangeCount() {
        return this.getRanges().size();
    }

    public String jsxGet_type() {
        return this.type_;
    }

    public TextRange jsxFunction_createRange() {
        org.w3c.dom.ranges.Range first = this.getFirstRange();
        TextRange range = first != null ? new TextRange(first) : new TextRange(new SimpleRange());
        range.setParentScope(this.getParentScope());
        range.setPrototype(this.getPrototype(range.getClass()));
        return range;
    }

    public void jsxFunction_addRange(Range range) {
        this.getRanges().add(range.toW3C());
    }

    public void jsxFunction_removeRange(Range range) {
        this.getRanges().remove(range.toW3C());
    }

    public void jsxFunction_removeAllRanges() {
        this.getRanges().clear();
    }

    public Range jsxFunction_getRangeAt(int index) {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        if (index < 0 || index >= ranges.size()) {
            throw Context.reportRuntimeError("Invalid range index: " + index);
        }
        org.w3c.dom.ranges.Range range = ranges.get(index);
        Range jsRange = new Range(range);
        jsRange.setParentScope(this.getWindow());
        jsRange.setPrototype(this.getPrototype(Range.class));
        return jsRange;
    }

    public void jsxFunction_collapse(Node parentNode, int offset) {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        ranges.clear();
        ranges.add(new SimpleRange((org.w3c.dom.Node)parentNode.getDomNodeOrDie(), offset));
    }

    public void jsxFunction_collapseToEnd() {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last != null) {
            List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
            ranges.clear();
            ranges.add(last);
            last.collapse(false);
        }
    }

    public void jsxFunction_collapseToStart() {
        org.w3c.dom.ranges.Range first = this.getFirstRange();
        if (first != null) {
            List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
            ranges.clear();
            ranges.add(first);
            first.collapse(true);
        }
    }

    public void jsxFunction_empty() {
        this.type_ = "None";
    }

    public void jsxFunction_extend(Node parentNode, int offset) {
        org.w3c.dom.ranges.Range last = this.getLastRange();
        if (last != null) {
            last.setEnd((org.w3c.dom.Node)parentNode.getDomNodeOrDie(), offset);
        }
    }

    public void jsxFunction_selectAllChildren(Node parentNode) {
        List<org.w3c.dom.ranges.Range> ranges = this.getRanges();
        ranges.clear();
        ranges.add(new SimpleRange((org.w3c.dom.Node)parentNode.getDomNodeOrDie()));
    }

    private List<org.w3c.dom.ranges.Range> getRanges() {
        HtmlPage page = (HtmlPage)this.getWindow().getDomNodeOrDie();
        return page.getSelectionRanges();
    }

    private org.w3c.dom.ranges.Range getFirstRange() {
        org.w3c.dom.ranges.Range first = null;
        for (org.w3c.dom.ranges.Range range : this.getRanges()) {
            org.w3c.dom.Node rangeStart;
            if (first == null) {
                first = range;
                continue;
            }
            org.w3c.dom.Node firstStart = first.getStartContainer();
            if ((firstStart.compareDocumentPosition(rangeStart = range.getStartContainer()) & 2) == 0) continue;
            first = range;
        }
        return first;
    }

    private org.w3c.dom.ranges.Range getLastRange() {
        org.w3c.dom.ranges.Range last = null;
        for (org.w3c.dom.ranges.Range range : this.getRanges()) {
            org.w3c.dom.Node rangeStart;
            if (last == null) {
                last = range;
                continue;
            }
            org.w3c.dom.Node lastStart = last.getStartContainer();
            if ((lastStart.compareDocumentPosition(rangeStart = range.getStartContainer()) & 4) == 0) continue;
            last = range;
        }
        return last;
    }

    private SimpleScriptable getScriptableNullSafe(Object object) {
        SimpleScriptable scriptable = object != null ? this.getScriptableFor(object) : null;
        return scriptable;
    }
}

