/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.BoxObject;
import com.gargoylesoftware.htmlunit.javascript.host.DOMImplementation;
import com.gargoylesoftware.htmlunit.javascript.host.DocumentFragment;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.EventNode;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.XPathNSResolver;
import com.gargoylesoftware.htmlunit.javascript.host.XPathResult;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.IOException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DocumentType;

public class Document
extends EventNode {
    private static final Log LOG = LogFactory.getLog(Document.class);
    private Window window_;
    private DOMImplementation implementation_;
    private String designMode_;

    public void setWindow(Window window) {
        this.window_ = window;
    }

    public Location jsxGet_location() {
        return this.window_.jsxGet_location();
    }

    public void jsxSet_location(String location) throws IOException {
        this.window_.jsxSet_location(location);
    }

    public String jsxGet_referrer() {
        String referrer = this.getPage().getWebResponse().getWebRequest().getAdditionalHeaders().get("Referer");
        if (referrer == null) {
            return "";
        }
        return referrer;
    }

    public Element jsxGet_documentElement() {
        DomElement documentElement = this.getPage().getDocumentElement();
        if (documentElement == null) {
            return null;
        }
        return (Element)this.getScriptableFor(documentElement);
    }

    public SimpleScriptable jsxGet_doctype() {
        DocumentType documentType = this.getPage().getDoctype();
        if (documentType == null) {
            return null;
        }
        return this.getScriptableFor(documentType);
    }

    public String jsxGet_designMode() {
        if (this.designMode_ == null) {
            this.designMode_ = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_30) ? (this.getWindow().getWebWindow() instanceof FrameWindow ? "Inherit" : "Off") : "off";
        }
        return this.designMode_;
    }

    public void jsxSet_designMode(String mode) {
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_31);
        if (ie) {
            if (!("on".equalsIgnoreCase(mode) || "off".equalsIgnoreCase(mode) || "inherit".equalsIgnoreCase(mode))) {
                throw Context.reportRuntimeError("Invalid document.designMode value '" + mode + "'.");
            }
            if (!(this.getWindow().getWebWindow() instanceof FrameWindow)) {
                return;
            }
            if ("on".equalsIgnoreCase(mode)) {
                this.designMode_ = "On";
            } else if ("off".equalsIgnoreCase(mode)) {
                this.designMode_ = "Off";
            } else if ("inherit".equalsIgnoreCase(mode)) {
                this.designMode_ = "Inherit";
            }
        } else if ("on".equalsIgnoreCase(mode)) {
            this.designMode_ = "on";
            SgmlPage page = this.getPage();
            if (page instanceof HtmlPage) {
                HtmlPage htmlPage = (HtmlPage)page;
                DomNode child = htmlPage.getBody().getFirstChild();
                DomNode rangeNode = child != null ? child : htmlPage.getBody();
                htmlPage.setSelectionRange(new SimpleRange(rangeNode, 0));
            }
        } else if ("off".equalsIgnoreCase(mode)) {
            this.designMode_ = "off";
        }
    }

    protected SgmlPage getPage() {
        return (SgmlPage)this.getDomNodeOrDie();
    }

    public Object jsxGet_defaultView() {
        return this.getWindow();
    }

    public Object jsxFunction_createDocumentFragment() {
        DomDocumentFragment fragment = ((DomNode)this.getDomNodeOrDie()).getPage().createDomDocumentFragment();
        DocumentFragment node = new DocumentFragment();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(node.getClass()));
        node.setDomNode(fragment);
        return this.getScriptableFor(fragment);
    }

    public Attr jsxFunction_createAttribute(String attributeName) {
        return (Attr)this.getPage().createAttribute(attributeName).getScriptObject();
    }

    public BoxObject jsxFunction_getBoxObjectFor(HTMLElement element) {
        return element.getBoxObject();
    }

    public Object jsxFunction_importNode(Node importedNode, boolean deep) {
        return ((DomNode)importedNode.getDomNodeOrDie()).cloneNode(deep).getScriptObject();
    }

    public DOMImplementation jsxGet_implementation() {
        if (this.implementation_ == null) {
            this.implementation_ = new DOMImplementation();
            this.implementation_.setParentScope(this.getWindow());
            this.implementation_.setPrototype(this.getPrototype(this.implementation_.getClass()));
        }
        return this.implementation_;
    }

    public void jsxFunction_captureEvents(String type) {
    }

    public XPathNSResolver jsxFunction_createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope(this.getWindow());
        resolver.setPrototype(this.getPrototype(resolver.getClass()));
        return resolver;
    }

    public Object jsxFunction_createTextNode(String newData) {
        Object result = NOT_FOUND;
        try {
            DomText domNode = new DomText(((DomNode)this.getDomNodeOrDie()).getPage(), newData);
            SimpleScriptable jsElement = this.getScriptableFor(domNode);
            if (jsElement == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("createTextNode(" + newData + ") cannot return a result as there isn't a JavaScript object for the DOM node " + domNode.getClass().getName());
                }
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public Object jsxFunction_createComment(String comment) {
        DomComment domNode = new DomComment(((DomNode)this.getDomNodeOrDie()).getPage(), comment);
        return this.getScriptableFor(domNode);
    }

    public XPathResult jsxFunction_evaluate(String expression, Node contextNode, Object resolver, int type, Object result) {
        XPathResult xPathResult = (XPathResult)result;
        if (xPathResult == null) {
            xPathResult = new XPathResult();
            xPathResult.setParentScope(this.getParentScope());
            xPathResult.setPrototype(this.getPrototype(xPathResult.getClass()));
        }
        xPathResult.init(((DomNode)contextNode.getDomNodeOrDie()).getByXPath(expression), type);
        return xPathResult;
    }

    public Object jsxFunction_createElement(String tagName) {
        Object result = NOT_FOUND;
        try {
            BrowserVersion browserVersion = this.getBrowserVersion();
            if (tagName.startsWith("<") && tagName.endsWith(">") && browserVersion.hasFeature(BrowserVersionFeatures.GENERATED_153) && !(tagName = tagName.substring(1, tagName.length() - 1)).matches("\\w+")) {
                LOG.error("Unexpected exception occurred while parsing HTML snippet");
                throw Context.reportRuntimeError("Unexpected exception occurred while parsing HTML snippet: " + tagName);
            }
            SgmlPage page = this.getPage();
            org.w3c.dom.Element element = page.createElement(tagName);
            SimpleScriptable jsElement = this.getScriptableFor(element);
            if (jsElement == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("createElement(" + tagName + ") cannot return a result as there isn't a JavaScript object for the element " + element.getClass().getName());
                }
            } else {
                result = jsElement;
            }
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public Object jsxFunction_createElementNS(String namespaceURI, String qualifiedName) {
        BrowserVersion browserVersion = this.getBrowserVersion();
        org.w3c.dom.Element element = browserVersion.hasFeature(BrowserVersionFeatures.XUL_SUPPORT) && "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul".equals(namespaceURI) ? new HtmlDivision(namespaceURI, qualifiedName, this.getPage(), null) : ("http://www.w3.org/1999/xhtml".equals(namespaceURI) ? this.getPage().createElementNS(namespaceURI, qualifiedName) : new DomElement(namespaceURI, qualifiedName, this.getPage(), null));
        return this.getScriptableFor(element);
    }

    public HTMLCollection jsxFunction_getElementsByTagName(String tagName) {
        HTMLCollection collection;
        String description = "Document.getElementsByTagName('" + tagName + "')";
        if ("*".equals(tagName)) {
            collection = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false, description){

                protected boolean isMatching(DomNode node) {
                    return true;
                }
            };
        } else {
            final boolean useLocalName = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_32);
            final String tagNameLC = tagName.toLowerCase();
            collection = new HTMLCollection((DomNode)this.getDomNodeOrDie(), false, description){

                protected boolean isMatching(DomNode node) {
                    if (useLocalName) {
                        return tagNameLC.equalsIgnoreCase(node.getLocalName());
                    }
                    return tagNameLC.equalsIgnoreCase(node.getNodeName());
                }
            };
        }
        return collection;
    }

    public Object jsxFunction_getElementsByTagNameNS(Object namespaceURI, final String localName) {
        String description = "Document.getElementsByTagNameNS('" + namespaceURI + "', '" + localName + "')";
        DomElement domNode = this.getPage().getDocumentElement();
        final String prefix = namespaceURI != null && !"*".equals("*") ? XmlUtil.lookupPrefix(domNode, Context.toString(namespaceURI)) : null;
        HTMLCollection collection = new HTMLCollection(domNode, false, description){

            protected boolean isMatching(DomNode node) {
                if (!localName.equals(node.getLocalName())) {
                    return false;
                }
                if (prefix == null) {
                    return true;
                }
                return true;
            }
        };
        return collection;
    }
}

