/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.background;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaScriptJobManagerImpl
implements JavaScriptJobManager {
    private final transient WeakReference<WebWindow> window_;
    private transient PriorityQueue<JavaScriptJob> scheduledJobsQ_ = new PriorityQueue();
    private transient ArrayList<Integer> cancelledJobs_ = new ArrayList();
    private transient JavaScriptJob currentlyRunningJob_ = null;
    private static final AtomicInteger NEXT_JOB_ID_ = new AtomicInteger(1);
    private static final Log LOG = LogFactory.getLog(JavaScriptJobManagerImpl.class);

    public JavaScriptJobManagerImpl(WebWindow window) {
        this.window_ = new WeakReference<WebWindow>(window);
    }

    public synchronized int getJobCount() {
        return this.scheduledJobsQ_.size() + (this.currentlyRunningJob_ != null ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addJob(JavaScriptJob job, Page page) {
        WebWindow w = this.getWindow();
        if (w == null) {
            return 0;
        }
        if (w.getEnclosedPage() != page) {
            return 0;
        }
        int id = NEXT_JOB_ID_.getAndIncrement();
        job.setId(id);
        JavaScriptJobManagerImpl javaScriptJobManagerImpl = this;
        synchronized (javaScriptJobManagerImpl) {
            this.scheduledJobsQ_.add(job);
            if (LOG.isDebugEnabled()) {
                LOG.debug("\twindow is: " + this.getWindow());
                LOG.debug("\tadded job: " + job.toString());
                LOG.debug("after adding job to the queue, the queue is: ");
                this.printQueue();
            }
            this.notify();
        }
        return id;
    }

    public synchronized void removeJob(int id) {
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            int jobId = job.getId();
            if (jobId != id) continue;
            this.scheduledJobsQ_.remove(job);
            break;
        }
        this.cancelledJobs_.add(id);
        this.notify();
    }

    public synchronized void stopJob(int id) {
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            int jobId = job.getId();
            if (jobId != id) continue;
            this.scheduledJobsQ_.remove(job);
            break;
        }
        this.cancelledJobs_.add(id);
        this.notify();
    }

    public synchronized void removeAllJobs() {
        if (this.currentlyRunningJob_ != null) {
            this.cancelledJobs_.add(this.currentlyRunningJob_.getId());
        }
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            this.cancelledJobs_.add(job.getId());
        }
        this.scheduledJobsQ_.clear();
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForJobs(long timeoutMillis) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Waiting for all jobs to finish (will wait max " + timeoutMillis + " millis).");
        }
        if (timeoutMillis > 0L) {
            long now = System.currentTimeMillis();
            long end = now + timeoutMillis;
            while (this.getJobCount() > 0 && now < end) {
                try {
                    JavaScriptJobManagerImpl javaScriptJobManagerImpl = this;
                    synchronized (javaScriptJobManagerImpl) {
                        this.wait(end - now);
                    }
                    now = System.currentTimeMillis();
                }
                catch (InterruptedException e) {
                    LOG.error("InterruptedException while in waitForJobs", e);
                }
            }
        }
        int jobs = this.getJobCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished waiting for all jobs to finish (final job count is " + jobs + ").");
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForJobsStartingBefore(long delayMillis) {
        boolean currentJob;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Waiting for all jobs that have execution time before " + delayMillis + " to finish");
        }
        long targetExecutionTime = System.currentTimeMillis() + delayMillis;
        JavaScriptJob earliestJob = this.getEarliestJob();
        JavaScriptJobManagerImpl javaScriptJobManagerImpl = this;
        synchronized (javaScriptJobManagerImpl) {
            currentJob = this.currentlyRunningJob_ != null && this.currentlyRunningJob_.getTargetExecutionTime() < targetExecutionTime;
        }
        long interval = Math.max(40L, delayMillis);
        while (currentJob || earliestJob != null && earliestJob.getTargetExecutionTime() < targetExecutionTime) {
            try {
                JavaScriptJobManagerImpl javaScriptJobManagerImpl2 = this;
                synchronized (javaScriptJobManagerImpl2) {
                    this.wait(interval);
                }
            }
            catch (InterruptedException e) {
                LOG.error("InterruptedException while in waitForJobsStartingBefore", e);
            }
            earliestJob = this.getEarliestJob();
            JavaScriptJobManagerImpl e = this;
            synchronized (e) {
                currentJob = this.currentlyRunningJob_ != null && this.currentlyRunningJob_.getTargetExecutionTime() < targetExecutionTime;
            }
        }
        int jobs = this.getJobCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished waiting for all jobs that have target execution time earlier than " + targetExecutionTime + ", final job count is " + jobs);
        }
        return jobs;
    }

    public synchronized void shutdown() {
        this.scheduledJobsQ_.clear();
        this.notify();
    }

    private WebWindow getWindow() {
        return (WebWindow)this.window_.get();
    }

    private void printQueue() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("------ printing JavaScript job queue -----");
            LOG.debug("number of jobs on the queue: " + this.scheduledJobsQ_.size());
            for (JavaScriptJob job : this.scheduledJobsQ_) {
                LOG.debug("\tJob target execution time:" + job.getTargetExecutionTime());
                LOG.debug("\tjob to string: " + job.toString());
                LOG.debug("\tjob id: " + job.getId());
            }
            LOG.debug("------------------------------------------");
        }
    }

    public JavaScriptJob getEarliestJob() {
        return this.scheduledJobsQ_.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runSingleJob(JavaScriptJob givenJob) {
        assert (givenJob != null);
        JavaScriptJob job = this.scheduledJobsQ_.peek();
        if (job != givenJob) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (job.getTargetExecutionTime() > currentTime) {
            return false;
        }
        JavaScriptJobManagerImpl javaScriptJobManagerImpl = this;
        synchronized (javaScriptJobManagerImpl) {
            if (this.scheduledJobsQ_.remove(job)) {
                this.currentlyRunningJob_ = job;
            }
        }
        boolean isPeriodicJob = job.isPeriodic();
        if (isPeriodicJob) {
            long jobPeriod = job.getPeriod().longValue();
            long timeDifference = currentTime - job.getTargetExecutionTime();
            timeDifference = timeDifference / jobPeriod * jobPeriod + jobPeriod;
            job.setTargetExecutionTime(job.getTargetExecutionTime() + timeDifference);
            JavaScriptJobManagerImpl javaScriptJobManagerImpl2 = this;
            synchronized (javaScriptJobManagerImpl2) {
                if (!this.cancelledJobs_.contains(job.getId())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Reschedulling job " + job);
                    }
                    this.scheduledJobsQ_.add(job);
                    this.notify();
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            String periodicJob = isPeriodicJob ? "interval " : "";
            LOG.debug("Starting " + periodicJob + "job " + job);
        }
        try {
            job.run();
        }
        catch (RuntimeException e) {
            LOG.error("Job run failed with unexpected RuntimeException: " + e.getMessage(), e);
        }
        finally {
            JavaScriptJobManagerImpl e = this;
            synchronized (e) {
                if (job == this.currentlyRunningJob_) {
                    this.currentlyRunningJob_ = null;
                }
                this.notify();
            }
        }
        if (LOG.isDebugEnabled()) {
            String periodicJob = isPeriodicJob ? "interval " : "";
            LOG.debug("Finished " + (String)periodicJob + "job " + job);
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.scheduledJobsQ_ = new PriorityQueue();
        this.cancelledJobs_ = new ArrayList();
        this.currentlyRunningJob_ = null;
    }
}

