/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlCaption;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTableBody;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableFooter;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.TableRowGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTable
extends HtmlElement {
    public static final String TAG_NAME = "table";

    HtmlTable(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    public final HtmlTableCell getCellAt(int rowIndex, int columnIndex) {
        RowIterator rowIterator = this.getRowIterator();
        int rowNo = 0;
        while (rowIterator.hasNext()) {
            HtmlTableRow row = rowIterator.nextRow();
            HtmlTableRow.CellIterator cellIterator = row.getCellIterator();
            int colNo = 0;
            while (cellIterator.hasNext()) {
                HtmlTableCell cell = cellIterator.nextCell();
                if (rowNo <= rowIndex && rowNo + cell.getRowSpan() > rowIndex && colNo <= columnIndex && colNo + cell.getColumnSpan() > columnIndex) {
                    return cell;
                }
                ++colNo;
            }
            ++rowNo;
        }
        return null;
    }

    private RowIterator getRowIterator() {
        return new RowIterator();
    }

    public List<HtmlTableRow> getRows() {
        ArrayList<HtmlTableRow> result = new ArrayList<HtmlTableRow>();
        RowIterator iterator = this.getRowIterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return Collections.unmodifiableList(result);
    }

    public HtmlTableRow getRow(int index) throws IndexOutOfBoundsException {
        int count = 0;
        RowIterator iterator = this.getRowIterator();
        while (iterator.hasNext()) {
            HtmlTableRow next = iterator.nextRow();
            if (count == index) {
                return next;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException();
    }

    public final int getRowCount() {
        int count = 0;
        RowIterator iterator = this.getRowIterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    public final HtmlTableRow getRowById(String id) throws ElementNotFoundException {
        RowIterator iterator = new RowIterator();
        while (iterator.hasNext()) {
            HtmlTableRow row = iterator.next();
            if (!row.getAttribute("id").equals(id)) continue;
            return row;
        }
        throw new ElementNotFoundException("tr", "id", id);
    }

    public String getCaptionText() {
        for (HtmlElement element : this.getChildElements()) {
            if (!(element instanceof HtmlCaption)) continue;
            return element.asText();
        }
        return null;
    }

    public HtmlTableHeader getHeader() {
        for (HtmlElement element : this.getChildElements()) {
            if (!(element instanceof HtmlTableHeader)) continue;
            return (HtmlTableHeader)element;
        }
        return null;
    }

    public HtmlTableFooter getFooter() {
        for (HtmlElement element : this.getChildElements()) {
            if (!(element instanceof HtmlTableFooter)) continue;
            return (HtmlTableFooter)element;
        }
        return null;
    }

    public List<HtmlTableBody> getBodies() {
        ArrayList<HtmlTableBody> bodies = new ArrayList<HtmlTableBody>();
        for (HtmlElement element : this.getChildElements()) {
            if (!(element instanceof HtmlTableBody)) continue;
            bodies.add((HtmlTableBody)element);
        }
        return bodies;
    }

    public final String getSummaryAttribute() {
        return this.getAttribute("summary");
    }

    public final String getWidthAttribute() {
        return this.getAttribute("width");
    }

    public final String getBorderAttribute() {
        return this.getAttribute("border");
    }

    public final String getFrameAttribute() {
        return this.getAttribute("frame");
    }

    public final String getRulesAttribute() {
        return this.getAttribute("rules");
    }

    public final String getCellSpacingAttribute() {
        return this.getAttribute("cellspacing");
    }

    public final String getCellPaddingAttribute() {
        return this.getAttribute("cellpadding");
    }

    public final String getAlignAttribute() {
        return this.getAttribute("align");
    }

    public final String getBgcolorAttribute() {
        return this.getAttribute("bgcolor");
    }

    @Override
    protected boolean isBlock() {
        return true;
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowIterator
    implements Iterator<HtmlTableRow>,
    Iterable<HtmlTableRow> {
        private HtmlTableRow nextRow_;
        private TableRowGroup currentGroup_;

        public RowIterator() {
            this.setNextRow(HtmlTable.this.getFirstChild());
        }

        @Override
        public boolean hasNext() {
            return this.nextRow_ != null;
        }

        @Override
        public HtmlTableRow next() throws NoSuchElementException {
            return this.nextRow();
        }

        @Override
        public void remove() throws IllegalStateException {
            if (this.nextRow_ == null) {
                throw new IllegalStateException();
            }
            DomNode sibling = this.nextRow_.getPreviousSibling();
            if (sibling != null) {
                sibling.remove();
            }
        }

        public HtmlTableRow nextRow() throws NoSuchElementException {
            if (this.nextRow_ != null) {
                HtmlTableRow result = this.nextRow_;
                this.setNextRow(this.nextRow_.getNextSibling());
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextRow(DomNode node) {
            this.nextRow_ = null;
            for (DomNode next = node; next != null; next = next.getNextSibling()) {
                if (next instanceof HtmlTableRow) {
                    this.nextRow_ = (HtmlTableRow)next;
                    return;
                }
                if (this.currentGroup_ != null || !(next instanceof TableRowGroup)) continue;
                this.currentGroup_ = (TableRowGroup)next;
                this.setNextRow(next.getFirstChild());
                return;
            }
            if (this.currentGroup_ != null) {
                TableRowGroup group = this.currentGroup_;
                this.currentGroup_ = null;
                this.setNextRow(group.getNextSibling());
            }
        }

        @Override
        public Iterator<HtmlTableRow> iterator() {
            return this;
        }
    }
}

