/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlUnitCookieStore
implements CookieStore,
Serializable {
    private final List<Cookie> cookies_ = new ArrayList<Cookie>();
    private final CookieIdentityComparator comparator_ = new CookieIdentityComparator();

    HtmlUnitCookieStore() {
    }

    @Override
    public synchronized void addCookie(Cookie cookie) {
        if (cookie == null) {
            return;
        }
        int index = this.findCookieIndex(cookie);
        if (cookie.isExpired(new Date())) {
            if (index != -1) {
                this.cookies_.remove(index);
            }
        } else if (index == -1) {
            this.cookies_.add(cookie);
        } else {
            this.cookies_.set(index, cookie);
        }
    }

    private int findCookieIndex(Cookie cookie) {
        for (int i = 0; i < this.cookies_.size(); ++i) {
            Cookie curCookie = this.cookies_.get(i);
            if (this.comparator_.compare(cookie, curCookie) != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies_);
    }

    @Override
    public synchronized boolean clearExpired(Date date) {
        if (date == null) {
            return false;
        }
        boolean removed = false;
        Iterator<Cookie> it = this.cookies_.iterator();
        while (it.hasNext()) {
            if (!it.next().isExpired(date)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public synchronized void clear() {
        this.cookies_.clear();
    }
}

