/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.google.common.io.Resources;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.seleniumemulation.ElementFinder;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;
import org.openqa.selenium.io.TemporaryFilesystem;

public class AttachFile
extends SeleneseCommand<Void> {
    private final ElementFinder finder;

    public AttachFile(ElementFinder finder) {
        this.finder = finder;
    }

    @Override
    protected Void handleSeleneseCommand(WebDriver driver, String locator, String value) {
        File file = this.downloadFile(value);
        WebElement element = this.finder.findElement(driver, locator);
        element.clear();
        element.sendKeys(file.getAbsolutePath());
        return null;
    }

    private File downloadFile(String name) {
        URL url = this.getUrl(name);
        File dir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("attachFile", "dir");
        File outputTo = new File(dir, url.getFile());
        if (!outputTo.getParentFile().mkdirs()) {
            throw new SeleniumException("Cannot create file for upload: " + outputTo);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputTo);
            Resources.copy((URL)url, (OutputStream)fos);
        }
        catch (IOException iOException) {}
        return outputTo;
    }

    private URL getUrl(String name) {
        try {
            return new URL(name);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SeleniumException("Malformed URL: " + name);
        }
    }
}

