require 'poet'

class EnableUAC < Poet::Scanner
	self.mod_name = "Enable UAC"
	self.description = "Enable the UAC registry setting on target(s)."
	self.invasive = true

	def setup
		# Print title
		puts 
		title = "UAC Confiugration Editor Status"
		puts color_header(title)
	end

	def run(username, password, host)
		# enable uac
		options = "--uninstall --system //#{host}"
		cmd = "CMD /C reg ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Policies\\System /v EnableLUA /t REG_DWORD /d 1 /f"
		uac = winexe(options, cmd)
		if uac =~ /The operation completed successfully/
			print_good("#{host.ljust(15)} - UAC Now Enabled")
			@success = @success + 1
		else
			print_bad("#{host.ljust(15)} - Issues Modifying Registry")
			@failed = @failed + 1
		end
	end

	def finish
		# summary
		puts "\nUAC Enabled: #{@success}"
		puts "\nUAC Failed: #{@failed}\n\n"

		# Return to menu
		print "Press enter to Return to Enumeration Menu"
		gets
	end
end