/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.time.ZoneOffset;

abstract class UcoObject {
    @SerializedName(value="@id")
    private String id;
    @SerializedName(value="@type")
    private final String type;
    private String createdTime;
    private String modifiedTime;
    private String description;
    private String name;
    private String tag;

    UcoObject(String id, String type) {
        this.id = id;
        this.type = type;
    }

    String getId() {
        return this.id;
    }

    UcoObject setCreatedTime(Long createdTime) {
        if (createdTime != null) {
            this.createdTime = Instant.ofEpochSecond(createdTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    UcoObject setModifiedTime(Long modifiedTime) {
        if (modifiedTime != null) {
            this.modifiedTime = Instant.ofEpochSecond(modifiedTime).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    UcoObject setId(String id) {
        this.id = id;
        return this;
    }

    UcoObject setDescription(String description) {
        this.description = description;
        return this;
    }

    UcoObject setName(String name) {
        this.name = name;
        return this;
    }

    UcoObject setTag(String tag) {
        this.tag = tag;
        return this;
    }

    String getType() {
        return this.type;
    }

    String getCreatedTime() {
        return this.createdTime;
    }

    String getModifiedTime() {
        return this.modifiedTime;
    }

    String getDescription() {
        return this.description;
    }

    String getName() {
        return this.name;
    }

    String getTag() {
        return this.tag;
    }
}

