/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.caseuco;

import java.time.Instant;
import java.time.ZoneOffset;
import org.sleuthkit.caseuco.Facet;

class DigitalAccount
extends Facet {
    private String displayName;
    private String lastLoginTime;

    DigitalAccount() {
        super(DigitalAccount.class.getSimpleName());
    }

    DigitalAccount setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    DigitalAccount setLastLoginTime(Long time) {
        if (time != null) {
            this.lastLoginTime = Instant.ofEpochSecond(time).atOffset(ZoneOffset.UTC).toString();
        }
        return this;
    }

    String getDisplayName() {
        return this.displayName;
    }

    String getLastLoginTime() {
        return this.lastLoginTime;
    }
}

