/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel.blackboardutils.attributes;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GeoWaypoints
implements Iterable<Waypoint> {
    private final List<Waypoint> points = new ArrayList<Waypoint>();

    public void addPoint(Waypoint wayPoint) {
        if (wayPoint == null) {
            throw new IllegalArgumentException("addPoint was passed a null waypoint");
        }
        this.points.add(wayPoint);
    }

    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    @Override
    public Iterator<Waypoint> iterator() {
        return this.points.iterator();
    }

    public static class Waypoint {
        @SerializedName(value="TSK_GEO_LATITUDE")
        private final Double latitude;
        @SerializedName(value="TSK_GEO_LONGITUDE")
        private final Double longitude;
        @SerializedName(value="TSK_GEO_ALTITUDE")
        private final Double altitude;
        @SerializedName(value="TSK_NAME")
        private final String name;

        public Waypoint(Double latitude, Double longitude, Double altitude, String name) {
            if (latitude == null) {
                throw new IllegalArgumentException("Constructor was passed null latitude");
            }
            if (longitude == null) {
                throw new IllegalArgumentException("Constructor was passed null longitude");
            }
            this.latitude = latitude;
            this.longitude = longitude;
            this.altitude = altitude;
            this.name = name;
        }

        public Double getLatitude() {
            return this.latitude;
        }

        public Double getLongitude() {
            return this.longitude;
        }

        public Double getAltitude() {
            return this.altitude;
        }

        public String getName() {
            return this.name;
        }
    }
}

