/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel.blackboardutils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sleuthkit.datamodel.Blackboard;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.DataArtifact;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.blackboardutils.ArtifactHelperBase;
import org.sleuthkit.datamodel.blackboardutils.attributes.BlackboardJsonAttrUtil;
import org.sleuthkit.datamodel.blackboardutils.attributes.GeoAreaPoints;
import org.sleuthkit.datamodel.blackboardutils.attributes.GeoTrackPoints;
import org.sleuthkit.datamodel.blackboardutils.attributes.GeoWaypoints;

public final class GeoArtifactsHelper
extends ArtifactHelperBase {
    private static final BlackboardAttribute.Type WAYPOINTS_ATTR_TYPE = new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_WAYPOINTS);
    private static final BlackboardAttribute.Type TRACKPOINTS_ATTR_TYPE = new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_TRACKPOINTS);
    private static final BlackboardAttribute.Type AREAPOINTS_ATTR_TYPE = new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_AREAPOINTS);
    private static final BlackboardArtifact.Type GPS_TRACK_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_TRACK);
    private static final BlackboardArtifact.Type GPS_ROUTE_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_ROUTE);
    private static final BlackboardArtifact.Type GPS_AREA_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_AREA);
    private final String programName;

    public GeoArtifactsHelper(SleuthkitCase caseDb, String moduleName, String programName, Content srcContent, Long ingestJobId) {
        super(caseDb, moduleName, srcContent, ingestJobId);
        this.programName = programName;
    }

    @Deprecated
    public GeoArtifactsHelper(SleuthkitCase caseDb, String moduleName, String programName, Content srcContent) {
        this(caseDb, moduleName, programName, srcContent, null);
    }

    public BlackboardArtifact addTrack(String trackName, GeoTrackPoints trackPoints, List<BlackboardAttribute> moreAttributes) throws TskCoreException, Blackboard.BlackboardException {
        if (trackPoints == null || trackPoints.isEmpty()) {
            throw new IllegalArgumentException(String.format("addTrack was passed a null or empty list of track points", new Object[0]));
        }
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        if (trackName != null) {
            attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME, this.getModuleName(), trackName));
        }
        attributes.add(BlackboardJsonAttrUtil.toAttribute(TRACKPOINTS_ATTR_TYPE, this.getModuleName(), trackPoints));
        if (this.programName != null) {
            attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME, this.getModuleName(), this.programName));
        }
        if (moreAttributes != null) {
            attributes.addAll(moreAttributes);
        }
        Content content = this.getContent();
        DataArtifact artifact = content.newDataArtifact(GPS_TRACK_TYPE, attributes);
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(artifact, this.getModuleName(), ingestJobId.orElse(null));
        return artifact;
    }

    public BlackboardArtifact addRoute(String routeName, Long creationTime, GeoWaypoints wayPoints, List<BlackboardAttribute> moreAttributes) throws TskCoreException, Blackboard.BlackboardException {
        if (wayPoints == null || wayPoints.isEmpty()) {
            throw new IllegalArgumentException(String.format("addRoute was passed a null or empty list of waypoints", new Object[0]));
        }
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        attributes.add(BlackboardJsonAttrUtil.toAttribute(WAYPOINTS_ATTR_TYPE, this.getModuleName(), wayPoints));
        if (routeName != null) {
            attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME, this.getModuleName(), routeName));
        }
        if (creationTime != null) {
            attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME, this.getModuleName(), (long)creationTime));
        }
        if (this.programName != null) {
            attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME, this.getModuleName(), this.programName));
        }
        if (moreAttributes != null) {
            attributes.addAll(moreAttributes);
        }
        Content content = this.getContent();
        DataArtifact artifact = content.newDataArtifact(GPS_ROUTE_TYPE, attributes);
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(artifact, this.getModuleName(), ingestJobId.orElse(null));
        return artifact;
    }

    public BlackboardArtifact addArea(String areaName, GeoAreaPoints areaPoints, List<BlackboardAttribute> moreAttributes) throws TskCoreException, Blackboard.BlackboardException {
        if (areaPoints == null || areaPoints.isEmpty()) {
            throw new IllegalArgumentException(String.format("addArea was passed a null or empty list of points", new Object[0]));
        }
        ArrayList<BlackboardAttribute> attributes = new ArrayList<BlackboardAttribute>();
        attributes.add(BlackboardJsonAttrUtil.toAttribute(AREAPOINTS_ATTR_TYPE, this.getModuleName(), areaPoints));
        if (areaName != null) {
            attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME, this.getModuleName(), areaName));
        }
        if (this.programName != null) {
            attributes.add(new BlackboardAttribute(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME, this.getModuleName(), this.programName));
        }
        if (moreAttributes != null) {
            attributes.addAll(moreAttributes);
        }
        Content content = this.getContent();
        DataArtifact artifact = content.newDataArtifact(GPS_AREA_TYPE, attributes);
        Optional<Long> ingestJobId = this.getIngestJobId();
        this.getSleuthkitCase().getBlackboard().postArtifact(artifact, this.getModuleName(), ingestJobId.orElse(null));
        return artifact;
    }
}

