/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel.blackboardutils;

import java.util.Collection;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.SleuthkitCase;

class ArtifactHelperBase {
    private final SleuthkitCase caseDb;
    private final Content srcContent;
    private final String moduleName;
    private final Long ingestJobId;

    ArtifactHelperBase(SleuthkitCase caseDb, String moduleName, Content srcContent, Long ingestJobId) {
        this.moduleName = moduleName;
        this.srcContent = srcContent;
        this.caseDb = caseDb;
        this.ingestJobId = ingestJobId;
    }

    Content getContent() {
        return this.srcContent;
    }

    SleuthkitCase getSleuthkitCase() {
        return this.caseDb;
    }

    String getModuleName() {
        return this.moduleName;
    }

    Optional<Long> getIngestJobId() {
        return Optional.ofNullable(this.ingestJobId);
    }

    void addAttributeIfNotNull(BlackboardAttribute.ATTRIBUTE_TYPE attributeType, String attrValue, Collection<BlackboardAttribute> attributes) {
        if (!StringUtils.isEmpty((CharSequence)attrValue)) {
            attributes.add(new BlackboardAttribute(attributeType, this.getModuleName(), attrValue));
        }
    }

    void addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE attributeType, long attrValue, Collection<BlackboardAttribute> attributes) {
        if (attrValue > 0L) {
            attributes.add(new BlackboardAttribute(attributeType, this.getModuleName(), attrValue));
        }
    }

    void addAttributeIfNotZero(BlackboardAttribute.ATTRIBUTE_TYPE attributeType, int attrValue, Collection<BlackboardAttribute> attributes) {
        if (attrValue > 0) {
            attributes.add(new BlackboardAttribute(attributeType, this.getModuleName(), attrValue));
        }
    }
}

