/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.sleuthkit.datamodel.AbstractContent;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.FileSystem;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.SleuthkitJNI;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.VolumeSystem;

public class Volume
extends AbstractContent {
    private long addr;
    private long startSector;
    private long lengthInSectors;
    private long flags;
    private String desc;
    private volatile long volumeHandle = 0L;
    private volatile String uniquePath;
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");

    protected Volume(SleuthkitCase db, long obj_id, long addr, long startSector, long lengthInSectors, long flags, String desc) {
        super(db, obj_id, "vol" + Long.toString(addr));
        this.addr = addr;
        this.startSector = startSector;
        this.lengthInSectors = lengthInSectors;
        this.uniquePath = null;
        this.flags = flags;
        this.desc = !desc.equals("") ? desc : bundle.getString("Volume.desc.text");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buf, long offset, long len) throws TskCoreException {
        Volume volume = this;
        synchronized (volume) {
            Content myParent = this.getParent();
            if (!(myParent instanceof VolumeSystem)) {
                throw new TskCoreException(bundle.getString("Volume.read.exception.msg1.text"));
            }
            VolumeSystem parentVs = (VolumeSystem)myParent;
            if (parentVs.getType().equals((Object)TskData.TSK_VS_TYPE_ENUM.TSK_VS_TYPE_APFS)) {
                throw new TskCoreException("Reading APFS pool volumes not yet supported");
            }
            if (this.volumeHandle == 0L) {
                this.volumeHandle = SleuthkitJNI.openVsPart(parentVs.getVolumeSystemHandle(), this.addr);
            }
        }
        return SleuthkitJNI.readVsPart(this.volumeHandle, buf, offset, len);
    }

    @Override
    public void close() {
        this.volumeHandle = 0L;
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public long getSize() {
        return this.lengthInSectors * 512L;
    }

    @Override
    public String getUniquePath() throws TskCoreException {
        if (this.uniquePath == null) {
            Content myParent;
            Object tempUniquePath = "";
            String name = this.getName();
            if (!name.isEmpty()) {
                tempUniquePath = "/vol_" + name;
            }
            if ((myParent = this.getParent()) != null) {
                tempUniquePath = myParent.getUniquePath() + (String)tempUniquePath;
            }
            this.uniquePath = tempUniquePath;
        }
        return this.uniquePath;
    }

    public long getAddr() {
        return this.addr;
    }

    public long getStart() {
        return this.startSector;
    }

    public long getLength() {
        return this.lengthInSectors;
    }

    public long getFlags() {
        return this.flags;
    }

    public String getFlagsAsString() {
        return Volume.vsFlagToString(this.flags);
    }

    public String getDescription() {
        return this.desc;
    }

    public static String vsFlagToValue(long vsFlag) {
        String result = "";
        for (TskData.TSK_VS_PART_FLAG_ENUM flag : TskData.TSK_VS_PART_FLAG_ENUM.values()) {
            if (flag.getVsFlag() != vsFlag) continue;
            result = flag.toString();
        }
        return result;
    }

    public static long valueToVsFlag(String vsFlag) {
        long result = 0L;
        for (TskData.TSK_VS_PART_FLAG_ENUM flag : TskData.TSK_VS_PART_FLAG_ENUM.values()) {
            if (!flag.toString().equals(vsFlag)) continue;
            result = flag.getVsFlag();
        }
        return result;
    }

    public static String vsFlagToString(long vsFlag) {
        String result = "";
        long allocFlag = TskData.TSK_VS_PART_FLAG_ENUM.TSK_VS_PART_FLAG_ALLOC.getVsFlag();
        long unallocFlag = TskData.TSK_VS_PART_FLAG_ENUM.TSK_VS_PART_FLAG_UNALLOC.getVsFlag();
        long metaFlag = TskData.TSK_VS_PART_FLAG_ENUM.TSK_VS_PART_FLAG_META.getVsFlag();
        long allFlag = TskData.TSK_VS_PART_FLAG_ENUM.TSK_VS_PART_FLAG_ALL.getVsFlag();
        if ((vsFlag & allocFlag) == allocFlag) {
            result = bundle.getString("Volume.vsFlagToString.allocated");
        }
        if ((vsFlag & unallocFlag) == unallocFlag) {
            result = bundle.getString("Volume.vsFlagToString.unallocated");
        }
        return result;
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public <T> T accept(ContentVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public List<Content> getChildren() throws TskCoreException {
        return this.getSleuthkitCase().getVolumeChildren(this);
    }

    @Override
    public List<Long> getChildrenIds() throws TskCoreException {
        return this.getSleuthkitCase().getVolumeChildrenIds(this);
    }

    public List<FileSystem> getFileSystems() throws TskCoreException {
        List<Content> children = this.getChildren();
        ArrayList<FileSystem> fileSystems = new ArrayList<FileSystem>();
        for (Content child : children) {
            if (!(child instanceof FileSystem)) continue;
            fileSystems.add((FileSystem)child);
        }
        return fileSystems;
    }

    @Override
    public String toString(boolean preserveState) {
        return super.toString(preserveState) + "Volume [\taddr " + this.addr + "\tdesc " + this.desc + "\tflags " + this.flags + "\tlength " + this.lengthInSectors + "\tstart " + this.startSector + "]\t";
    }
}

