/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.sleuthkit.datamodel.AbstractFile;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.CollectionUtils;
import org.sleuthkit.datamodel.CommManagerSqlStringUtils;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TimelineEvent;
import org.sleuthkit.datamodel.TimelineEventArtifactTypeImpl;
import org.sleuthkit.datamodel.TimelineEventDescriptionWithTime;
import org.sleuthkit.datamodel.TimelineEventType;
import org.sleuthkit.datamodel.TimelineFilter;
import org.sleuthkit.datamodel.TimelineLevelOfDetail;
import org.sleuthkit.datamodel.TskCoreException;

public final class TimelineManager {
    private static final Logger logger = Logger.getLogger(TimelineManager.class.getName());
    private static final ImmutableList<TimelineEventType> ROOT_CATEGORY_AND_FILESYSTEM_TYPES = ImmutableList.of((Object)TimelineEventType.ROOT_EVENT_TYPE, (Object)TimelineEventType.WEB_ACTIVITY, (Object)TimelineEventType.MISC_TYPES, (Object)TimelineEventType.FILE_SYSTEM, (Object)TimelineEventType.FILE_ACCESSED, (Object)TimelineEventType.FILE_CHANGED, (Object)TimelineEventType.FILE_CREATED, (Object)TimelineEventType.FILE_MODIFIED);
    private static final ImmutableList<TimelineEventType> PREDEFINED_EVENT_TYPES = new ImmutableList.Builder().addAll(TimelineEventType.WEB_ACTIVITY.getChildren()).addAll(TimelineEventType.MISC_TYPES.getChildren()).build();
    private static final Set<Integer> ARTIFACT_TYPE_IDS = Stream.of(BlackboardArtifact.ARTIFACT_TYPE.values()).map(artType -> artType.getTypeID()).collect(Collectors.toSet());
    private final SleuthkitCase caseDB;
    private static final Long MAX_TIMESTAMP_TO_ADD = Instant.now().getEpochSecond() + 394200000L;
    private final Map<Long, TimelineEventType> eventTypeIDMap = new HashMap<Long, TimelineEventType>();

    TimelineManager(SleuthkitCase caseDB) throws TskCoreException {
        this.caseDB = caseDB;
        ArrayList<TimelineEventType> fullList = new ArrayList<TimelineEventType>();
        fullList.addAll((Collection<TimelineEventType>)ROOT_CATEGORY_AND_FILESYSTEM_TYPES);
        fullList.addAll((Collection<TimelineEventType>)PREDEFINED_EVENT_TYPES);
        caseDB.acquireSingleUserCaseWriteLock();
        try (SleuthkitCase.CaseDbConnection con = caseDB.getConnection();
             PreparedStatement pStatement = con.prepareStatement(this.insertOrIgnore(" INTO tsk_event_types(event_type_id, display_name, super_type_id) VALUES (?, ?, ?)"), 2);){
            for (TimelineEventType type : fullList) {
                pStatement.setLong(1, type.getTypeID());
                pStatement.setString(2, SleuthkitCase.escapeSingleQuotes(type.getDisplayName()));
                if (type != type.getParent()) {
                    pStatement.setLong(3, type.getParent().getTypeID());
                } else {
                    pStatement.setNull(3, 4);
                }
                con.executeUpdate(pStatement);
                this.eventTypeIDMap.put(type.getTypeID(), type);
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to initialize timeline event types", ex);
        }
        finally {
            caseDB.releaseSingleUserCaseWriteLock();
        }
    }

    public Interval getSpanningInterval(Collection<Long> eventIDs) throws TskCoreException {
        if (eventIDs.isEmpty()) {
            return null;
        }
        String query = "SELECT Min(time) as minTime, Max(time) as maxTime FROM tsk_events WHERE event_id IN (" + CommManagerSqlStringUtils.buildCSVString(eventIDs) + ")";
        this.caseDB.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection con = this.caseDB.getConnection();
             Statement stmt = con.createStatement();
             ResultSet results = stmt.executeQuery(query);){
            if (results.next()) {
                Interval interval = new Interval(results.getLong("minTime") * 1000L, (results.getLong("maxTime") + 1L) * 1000L, DateTimeZone.UTC);
                return interval;
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error executing get spanning interval query: " + query, ex);
        }
        finally {
            this.caseDB.releaseSingleUserCaseReadLock();
        }
        return null;
    }

    public Interval getSpanningInterval(Interval timeRange, TimelineFilter.RootFilter filter, DateTimeZone timeZone) throws TskCoreException {
        long start = timeRange.getStartMillis() / 1000L;
        long end = timeRange.getEndMillis() / 1000L;
        String sqlWhere = this.getSQLWhere(filter);
        String augmentedEventsTablesSQL = TimelineManager.getAugmentedEventsTablesSQL(filter);
        String queryString = " SELECT (SELECT Max(time) FROM " + augmentedEventsTablesSQL + "\t\t\t WHERE time <=" + start + " AND " + sqlWhere + ") AS start,\t\t (SELECT Min(time)  FROM " + augmentedEventsTablesSQL + "\t\t\t WHERE time >= " + end + " AND " + sqlWhere + ") AS end";
        this.caseDB.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection con = this.caseDB.getConnection();
             Statement stmt = con.createStatement();
             ResultSet results = stmt.executeQuery(queryString);){
            if (results.next()) {
                long start2 = results.getLong("start");
                long end2 = results.getLong("end");
                if (end2 == 0L) {
                    end2 = this.getMaxEventTime();
                }
                Interval interval = new Interval(start2 * 1000L, (end2 + 1L) * 1000L, timeZone);
                return interval;
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Failed to get MIN time.", ex);
        }
        finally {
            this.caseDB.releaseSingleUserCaseReadLock();
        }
        return null;
    }

    public TimelineEvent getEventById(long eventID) throws TskCoreException {
        String sql = "SELECT * FROM  " + TimelineManager.getAugmentedEventsTablesSQL(false) + " WHERE event_id = " + eventID;
        this.caseDB.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection con = this.caseDB.getConnection();
             Statement stmt = con.createStatement();
             ResultSet results = stmt.executeQuery(sql);){
            if (results.next()) {
                int typeID = results.getInt("event_type_id");
                TimelineEventType type = this.getEventType(typeID).orElseThrow(() -> TimelineManager.newEventTypeMappingException(typeID));
                TimelineEvent timelineEvent = new TimelineEvent(eventID, results.getLong("data_source_obj_id"), results.getLong("content_obj_id"), results.getLong("artifact_id"), results.getLong("time"), type, results.getString("full_description"), results.getString("med_description"), results.getString("short_description"), TimelineManager.intToBoolean(results.getInt("hash_hit")), TimelineManager.intToBoolean(results.getInt("tagged")));
                return timelineEvent;
            }
        }
        catch (SQLException sqlEx) {
            throw new TskCoreException("Error while executing query " + sql, sqlEx);
        }
        finally {
            this.caseDB.releaseSingleUserCaseReadLock();
        }
        return null;
    }

    public List<Long> getEventIDs(Interval timeRange, TimelineFilter.RootFilter filter) throws TskCoreException {
        Long endTime;
        Long startTime = timeRange.getStartMillis() / 1000L;
        if (Objects.equals(startTime, endTime = Long.valueOf(timeRange.getEndMillis() / 1000L))) {
            Long l = endTime;
            endTime = endTime + 1L;
        }
        ArrayList<Long> resultIDs = new ArrayList<Long>();
        String query = "SELECT tsk_events.event_id AS event_id FROM " + TimelineManager.getAugmentedEventsTablesSQL(filter) + " WHERE time >=  " + startTime + " AND time <" + endTime + " AND " + this.getSQLWhere(filter) + " ORDER BY time ASC";
        this.caseDB.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection con = this.caseDB.getConnection();
             Statement stmt = con.createStatement();
             ResultSet results = stmt.executeQuery(query);){
            while (results.next()) {
                resultIDs.add(results.getLong("event_id"));
            }
        }
        catch (SQLException sqlEx) {
            throw new TskCoreException("Error while executing query " + query, sqlEx);
        }
        finally {
            this.caseDB.releaseSingleUserCaseReadLock();
        }
        return resultIDs;
    }

    public Long getMaxEventTime() throws TskCoreException {
        this.caseDB.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection con = this.caseDB.getConnection();
             Statement stms = con.createStatement();
             ResultSet results = stms.executeQuery(STATEMENTS.GET_MAX_TIME.getSQL());){
            if (results.next()) {
                Long l = results.getLong("max");
                return l;
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error while executing query " + STATEMENTS.GET_MAX_TIME.getSQL(), ex);
        }
        finally {
            this.caseDB.releaseSingleUserCaseReadLock();
        }
        return -1L;
    }

    public Long getMinEventTime() throws TskCoreException {
        this.caseDB.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection con = this.caseDB.getConnection();
             Statement stms = con.createStatement();
             ResultSet results = stms.executeQuery(STATEMENTS.GET_MIN_TIME.getSQL());){
            if (results.next()) {
                Long l = results.getLong("min");
                return l;
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error while executing query " + STATEMENTS.GET_MAX_TIME.getSQL(), ex);
        }
        finally {
            this.caseDB.releaseSingleUserCaseReadLock();
        }
        return -1L;
    }

    public Optional<TimelineEventType> getEventType(long eventTypeID) {
        if (eventTypeID == 22L) {
            return Optional.of(TimelineEventType.MISC_TYPES);
        }
        return Optional.ofNullable(this.eventTypeIDMap.get(eventTypeID));
    }

    public ImmutableList<TimelineEventType> getEventTypes() {
        return ImmutableList.copyOf(this.eventTypeIDMap.values());
    }

    private String insertOrIgnore(String query) {
        switch (this.caseDB.getDatabaseType()) {
            case POSTGRESQL: {
                return " INSERT " + query + " ON CONFLICT DO NOTHING ";
            }
            case SQLITE: {
                return " INSERT OR IGNORE " + query;
            }
        }
        throw new UnsupportedOperationException("Unsupported DB type: " + this.caseDB.getDatabaseType().name());
    }

    public List<Long> getEventIDsForArtifact(BlackboardArtifact artifact) throws TskCoreException {
        ArrayList<Long> eventIDs = new ArrayList<Long>();
        String query = "SELECT event_id FROM tsk_events  LEFT JOIN tsk_event_descriptions on ( tsk_events.event_description_id = tsk_event_descriptions.event_description_id )  WHERE artifact_id = " + artifact.getArtifactID();
        this.caseDB.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection con = this.caseDB.getConnection();
             Statement stmt = con.createStatement();
             ResultSet results = stmt.executeQuery(query);){
            while (results.next()) {
                eventIDs.add(results.getLong("event_id"));
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error executing getEventIDsForArtifact query.", ex);
        }
        finally {
            this.caseDB.releaseSingleUserCaseReadLock();
        }
        return eventIDs;
    }

    public Set<Long> getEventIDsForContent(Content content, boolean includeDerivedArtifacts) throws TskCoreException {
        this.caseDB.acquireSingleUserCaseWriteLock();
        try {
            SleuthkitCase.CaseDbConnection conn = this.caseDB.getConnection();
            try {
                Set<Long> set = this.getEventAndDescriptionIDs(conn, content.getId(), includeDerivedArtifacts).keySet();
                if (conn != null) {
                    conn.close();
                }
                return set;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.caseDB.releaseSingleUserCaseWriteLock();
        }
    }

    private Long addEventDescription(long dataSourceObjId, long fileObjId, Long artifactID, String fullDescription, String medDescription, String shortDescription, boolean hasHashHits, boolean tagged, SleuthkitCase.CaseDbConnection connection) throws TskCoreException, DuplicateException {
        String tableValuesClause = "tsk_event_descriptions ( data_source_obj_id, content_obj_id, artifact_id,   full_description, med_description, short_description,  hash_hit, tagged  ) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        String insertDescriptionSql = this.getSqlIgnoreConflict(tableValuesClause);
        this.caseDB.acquireSingleUserCaseWriteLock();
        try {
            Long l;
            block19: {
                ResultSet generatedKeys;
                block17: {
                    Long l2;
                    block18: {
                        PreparedStatement insertDescriptionStmt = connection.getPreparedStatement(insertDescriptionSql, 1);
                        insertDescriptionStmt.clearParameters();
                        insertDescriptionStmt.setLong(1, dataSourceObjId);
                        insertDescriptionStmt.setLong(2, fileObjId);
                        if (artifactID == null) {
                            insertDescriptionStmt.setNull(3, 4);
                        } else {
                            insertDescriptionStmt.setLong(3, artifactID);
                        }
                        insertDescriptionStmt.setString(4, fullDescription);
                        insertDescriptionStmt.setString(5, medDescription);
                        insertDescriptionStmt.setString(6, shortDescription);
                        insertDescriptionStmt.setInt(7, TimelineManager.booleanToInt(hasHashHits));
                        insertDescriptionStmt.setInt(8, TimelineManager.booleanToInt(tagged));
                        int row = insertDescriptionStmt.executeUpdate();
                        if (row < 1) {
                            Long l3 = null;
                            return l3;
                        }
                        generatedKeys = insertDescriptionStmt.getGeneratedKeys();
                        try {
                            if (!generatedKeys.next()) break block17;
                            l2 = generatedKeys.getLong(1);
                            if (generatedKeys == null) break block18;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (generatedKeys != null) {
                                    try {
                                        generatedKeys.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SQLException ex) {
                                throw new TskCoreException("Failed to insert event description.", ex);
                            }
                        }
                        generatedKeys.close();
                    }
                    return l2;
                }
                l = null;
                if (generatedKeys == null) break block19;
                generatedKeys.close();
            }
            return l;
        }
        finally {
            this.caseDB.releaseSingleUserCaseWriteLock();
        }
    }

    private Long getEventDescription(long dataSourceObjId, long fileObjId, Long artifactID, String fullDescription, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String query = "SELECT event_description_id FROM tsk_event_descriptions WHERE data_source_obj_id = " + dataSourceObjId + " AND content_obj_id = " + fileObjId + " AND artifact_id " + (String)(artifactID != null ? " = " + artifactID : "IS null") + " AND full_description " + (String)(fullDescription != null ? "= '" + SleuthkitCase.escapeSingleQuotes(fullDescription) + "'" : "IS null");
        this.caseDB.acquireSingleUserCaseReadLock();
        try (ResultSet resultSet = connection.createStatement().executeQuery(query);){
            if (resultSet.next()) {
                long id = resultSet.getLong(1);
                Long l = id;
                return l;
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Failed to get description, dataSource=%d, fileObjId=%d, artifactId=%d", dataSourceObjId, fileObjId, artifactID), ex);
        }
        finally {
            this.caseDB.releaseSingleUserCaseReadLock();
        }
        return null;
    }

    Collection<TimelineEvent> addEventsForNewFile(AbstractFile file, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        Set<TimelineEvent> events = this.addEventsForNewFileQuiet(file, connection);
        events.stream().map(TimelineEventAddedEvent::new).forEach(this.caseDB::fireTSKEvent);
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<TimelineEvent> addEventsForNewFileQuiet(AbstractFile file, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        HashSet<TimelineEvent> events;
        block10: {
            ImmutableMap timeMap = ImmutableMap.of((Object)TimelineEventType.FILE_CREATED, (Object)file.getCrtime(), (Object)TimelineEventType.FILE_ACCESSED, (Object)file.getAtime(), (Object)TimelineEventType.FILE_CHANGED, (Object)file.getCtime(), (Object)TimelineEventType.FILE_MODIFIED, (Object)file.getMtime());
            if ((Long)Collections.max(timeMap.values()) <= 0L) {
                return Collections.emptySet();
            }
            String description = file.getParentPath() + file.getName();
            long fileObjId = file.getId();
            events = new HashSet<TimelineEvent>();
            this.caseDB.acquireSingleUserCaseWriteLock();
            try {
                Long descriptionID = this.addEventDescription(file.getDataSourceObjectId(), fileObjId, null, description, null, null, false, false, connection);
                if (descriptionID == null) {
                    descriptionID = this.getEventDescription(file.getDataSourceObjectId(), fileObjId, null, description, connection);
                }
                if (descriptionID != null) {
                    for (Map.Entry timeEntry : timeMap.entrySet()) {
                        Long time = (Long)timeEntry.getValue();
                        if (time > 0L && time < MAX_TIMESTAMP_TO_ADD) {
                            TimelineEventType type = (TimelineEventType)timeEntry.getKey();
                            long eventID = this.addEventWithExistingDescription(time, type, descriptionID, connection);
                            events.add(new TimelineEvent(eventID, descriptionID, fileObjId, null, time, type, description, null, null, false, false));
                            continue;
                        }
                        if (time < MAX_TIMESTAMP_TO_ADD) continue;
                        logger.log(Level.WARNING, String.format("Date/Time discarded from Timeline for %s for file %s with Id %d", ((TimelineEventType)timeEntry.getKey()).getDisplayName(), file.getParentPath() + file.getName(), file.getId()));
                    }
                    break block10;
                }
                throw new TskCoreException(String.format("Failed to get event description for file id = %d", fileObjId));
            }
            catch (DuplicateException dupEx) {
                logger.log(Level.SEVERE, "Attempt to make file event duplicate.", dupEx);
            }
            finally {
                this.caseDB.releaseSingleUserCaseWriteLock();
            }
        }
        return events;
    }

    Set<TimelineEvent> addArtifactEvents(BlackboardArtifact artifact) throws TskCoreException {
        HashSet<TimelineEvent> newEvents = new HashSet<TimelineEvent>();
        if (artifact.getArtifactTypeID() == BlackboardArtifact.ARTIFACT_TYPE.TSK_TL_EVENT.getTypeID()) {
            TimelineEventType eventType2;
            BlackboardAttribute attribute = artifact.getAttribute(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TL_EVENT_TYPE));
            if (attribute == null) {
                eventType2 = TimelineEventType.STANDARD_ARTIFACT_CATCH_ALL;
            } else {
                long eventTypeID = attribute.getValueLong();
                eventType2 = this.eventTypeIDMap.getOrDefault(eventTypeID, TimelineEventType.STANDARD_ARTIFACT_CATCH_ALL);
            }
            try {
                this.addArtifactEvent(((TimelineEventArtifactTypeImpl)TimelineEventType.STANDARD_ARTIFACT_CATCH_ALL).makeEventDescription(artifact), eventType2, artifact).ifPresent(newEvents::add);
            }
            catch (DuplicateException ex) {
                logger.log(Level.SEVERE, this.getDuplicateExceptionMessage(artifact, "Attempt to make a timeline event artifact duplicate"), ex);
            }
        } else {
            Set eventTypesForArtifact = this.eventTypeIDMap.values().stream().filter(TimelineEventArtifactTypeImpl.class::isInstance).map(TimelineEventArtifactTypeImpl.class::cast).filter(eventType -> eventType.getArtifactTypeID() == artifact.getArtifactTypeID()).collect(Collectors.toSet());
            boolean duplicateExists = false;
            for (TimelineEventArtifactTypeImpl eventType3 : eventTypesForArtifact) {
                try {
                    this.addArtifactEvent(eventType3.makeEventDescription(artifact), eventType3, artifact).ifPresent(newEvents::add);
                }
                catch (DuplicateException ex) {
                    duplicateExists = true;
                    logger.log(Level.SEVERE, this.getDuplicateExceptionMessage(artifact, "Attempt to make artifact event duplicate"), ex);
                }
            }
            if (!duplicateExists && newEvents.isEmpty()) {
                try {
                    this.addOtherEventDesc(artifact).ifPresent(newEvents::add);
                }
                catch (DuplicateException ex) {
                    logger.log(Level.SEVERE, this.getDuplicateExceptionMessage(artifact, "Attempt to make 'other' artifact event duplicate"), ex);
                }
            }
        }
        newEvents.stream().map(TimelineEventAddedEvent::new).forEach(this.caseDB::fireTSKEvent);
        return newEvents;
    }

    private String getDuplicateExceptionMessage(BlackboardArtifact artifact, String error) {
        String artifactIDStr = null;
        String sourceStr = null;
        if (artifact != null) {
            artifactIDStr = Long.toString(artifact.getId());
            try {
                sourceStr = artifact.getAttributes().stream().filter(attr -> attr != null && attr.getSources() != null && !attr.getSources().isEmpty()).map(attr -> String.join((CharSequence)",", attr.getSources())).findFirst().orElse(null);
            }
            catch (TskCoreException ex) {
                logger.log(Level.WARNING, String.format("Could not fetch artifacts for artifact id: %d.", artifact.getId()), ex);
            }
        }
        artifactIDStr = artifactIDStr == null ? "<null>" : artifactIDStr;
        sourceStr = sourceStr == null ? "<null>" : sourceStr;
        return String.format("%s (artifactID=%s, Source=%s).", error, artifactIDStr, sourceStr);
    }

    private Optional<TimelineEvent> addOtherEventDesc(BlackboardArtifact artifact) throws TskCoreException, DuplicateException {
        if (artifact == null) {
            return Optional.empty();
        }
        Long timeVal = artifact.getAttributes().stream().filter(attr -> attr.getAttributeType().getValueType() == BlackboardAttribute.TSK_BLACKBOARD_ATTRIBUTE_VALUE_TYPE.DATETIME).map(attr -> attr.getValueLong()).findFirst().orElse(null);
        if (timeVal == null) {
            return Optional.empty();
        }
        String description = String.format("%s: %d", artifact.getDisplayName(), artifact.getId());
        TimelineEventDescriptionWithTime evtWDesc = new TimelineEventDescriptionWithTime(timeVal, description, description, description);
        TimelineEventType evtType = ARTIFACT_TYPE_IDS.contains(artifact.getArtifactTypeID()) ? TimelineEventType.STANDARD_ARTIFACT_CATCH_ALL : TimelineEventType.CUSTOM_ARTIFACT_CATCH_ALL;
        return this.addArtifactEvent(evtWDesc, evtType, artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Beta
    public TimelineEvent addTimelineEvent(TimelineEventType eventType, String shortDesc, String medDesc, String longDesc, long dataSourceId, long contentId, Long artifactId, long time, boolean hashHit, boolean tagged, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        this.caseDB.acquireSingleUserCaseWriteLock();
        try {
            Long descriptionID = this.addEventDescription(dataSourceId, contentId, artifactId, longDesc, medDesc, shortDesc, hashHit, tagged, trans.getConnection());
            if (descriptionID == null) {
                descriptionID = this.getEventDescription(dataSourceId, contentId, artifactId, longDesc, trans.getConnection());
            }
            if (descriptionID != null) {
                long eventID = this.addEventWithExistingDescription(time, eventType, descriptionID, trans.getConnection());
                TimelineEvent timelineEvt = new TimelineEvent(eventID, descriptionID, contentId, artifactId, time, eventType, longDesc, medDesc, shortDesc, hashHit, tagged);
                trans.registerTimelineEvent(new TimelineEventAddedEvent(timelineEvt));
                TimelineEvent timelineEvent = timelineEvt;
                return timelineEvent;
            }
            try {
                throw new TskCoreException(MessageFormat.format("Failed to get event description for [shortDesc: {0}, dataSourceId: {1}, contentId: {2}, artifactId: {3}]", shortDesc, dataSourceId, contentId, artifactId == null ? "<null>" : artifactId));
            }
            catch (DuplicateException dupEx) {
                logger.log(Level.WARNING, "Attempt to make duplicate", dupEx);
                TimelineEvent timelineEvent = null;
                return timelineEvent;
            }
        }
        finally {
            this.caseDB.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<TimelineEvent> addArtifactEvent(TimelineEventDescriptionWithTime eventPayload, TimelineEventType eventType, BlackboardArtifact artifact) throws TskCoreException, DuplicateException {
        TimelineEvent event;
        block16: {
            if (eventPayload == null || eventType.isDeprecated()) {
                return Optional.empty();
            }
            long time = eventPayload.getTime();
            if (time <= 0L || time >= MAX_TIMESTAMP_TO_ADD) {
                if (time >= MAX_TIMESTAMP_TO_ADD) {
                    logger.log(Level.WARNING, String.format("Date/Time discarded from Timeline for %s for artifact %s with id %d", artifact.getDisplayName(), eventPayload.getDescription(TimelineLevelOfDetail.HIGH), artifact.getId()));
                }
                return Optional.empty();
            }
            String fullDescription = eventPayload.getDescription(TimelineLevelOfDetail.HIGH);
            String medDescription = eventPayload.getDescription(TimelineLevelOfDetail.MEDIUM);
            String shortDescription = eventPayload.getDescription(TimelineLevelOfDetail.LOW);
            long artifactID = artifact.getArtifactID();
            long fileObjId = artifact.getObjectID();
            Long dataSourceObjectID = artifact.getDataSourceObjectID();
            if (dataSourceObjectID == null) {
                logger.log(Level.SEVERE, String.format("Failed to create timeline event for artifact (%d), artifact data source was null", new Object[0]), artifact.getId());
                return Optional.empty();
            }
            AbstractFile file = this.caseDB.getAbstractFileById(fileObjId);
            boolean hasHashHits = false;
            if (file != null) {
                hasHashHits = CollectionUtils.isNotEmpty(file.getHashSetNames());
            }
            boolean tagged = CollectionUtils.isNotEmpty(this.caseDB.getBlackboardArtifactTagsByArtifact(artifact));
            this.caseDB.acquireSingleUserCaseWriteLock();
            try (SleuthkitCase.CaseDbConnection connection = this.caseDB.getConnection();){
                Long descriptionID = this.addEventDescription(dataSourceObjectID, fileObjId, artifactID, fullDescription, medDescription, shortDescription, hasHashHits, tagged, connection);
                if (descriptionID == null) {
                    descriptionID = this.getEventDescription(dataSourceObjectID, fileObjId, artifactID, fullDescription, connection);
                }
                if (descriptionID != null) {
                    long eventID = this.addEventWithExistingDescription(time, eventType, descriptionID, connection);
                    event = new TimelineEvent(eventID, dataSourceObjectID, fileObjId, artifactID, time, eventType, fullDescription, medDescription, shortDescription, hasHashHits, tagged);
                    break block16;
                }
                throw new TskCoreException(String.format("Failed to get event description for file id = %d, artifactId %d", fileObjId, artifactID));
            }
            finally {
                this.caseDB.releaseSingleUserCaseWriteLock();
            }
        }
        return Optional.of(event);
    }

    /*
     * Loose catch block
     */
    private long addEventWithExistingDescription(Long time, TimelineEventType type, long descriptionID, SleuthkitCase.CaseDbConnection connection) throws TskCoreException, DuplicateException {
        String tableValuesClause = "tsk_events ( event_type_id, event_description_id , time) VALUES (?, ?, ?)";
        String insertEventSql = this.getSqlIgnoreConflict(tableValuesClause);
        this.caseDB.acquireSingleUserCaseWriteLock();
        try {
            block13: {
                long l;
                block14: {
                    PreparedStatement insertRowStmt = connection.getPreparedStatement(insertEventSql, 1);
                    insertRowStmt.clearParameters();
                    insertRowStmt.setLong(1, type.getTypeID());
                    insertRowStmt.setLong(2, descriptionID);
                    insertRowStmt.setLong(3, time);
                    int row = insertRowStmt.executeUpdate();
                    if (row < 1) {
                        throw new DuplicateException(String.format("An event already exists in the event table for this item [time: %s, type: %s, description: %d].", time == null ? "<null>" : Long.toString(time), type == null ? "<null>" : type.toString(), descriptionID));
                    }
                    ResultSet generatedKeys = insertRowStmt.getGeneratedKeys();
                    if (!generatedKeys.next()) break block13;
                    l = generatedKeys.getLong(1);
                    if (generatedKeys == null) break block14;
                    {
                        catch (Throwable throwable) {
                            if (generatedKeys != null) {
                                try {
                                    generatedKeys.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    generatedKeys.close();
                }
                return l;
            }
            try {
                throw new DuplicateException(String.format("An event already exists in the event table for this item [time: %s, type: %s, description: %d].", time == null ? "<null>" : Long.toString(time), type == null ? "<null>" : type.toString(), descriptionID));
            }
            catch (SQLException ex) {
                throw new TskCoreException("Failed to insert event for existing description.", ex);
            }
        }
        finally {
            this.caseDB.releaseSingleUserCaseWriteLock();
        }
    }

    private Map<Long, Long> getEventAndDescriptionIDs(SleuthkitCase.CaseDbConnection conn, long contentObjID, boolean includeArtifacts) throws TskCoreException {
        return this.getEventAndDescriptionIDsHelper(conn, contentObjID, includeArtifacts ? "" : " AND artifact_id IS NULL");
    }

    private Map<Long, Long> getEventAndDescriptionIDs(SleuthkitCase.CaseDbConnection conn, long contentObjID, Long artifactID) throws TskCoreException {
        return this.getEventAndDescriptionIDsHelper(conn, contentObjID, " AND artifact_id = " + artifactID);
    }

    private Map<Long, Long> getEventAndDescriptionIDsHelper(SleuthkitCase.CaseDbConnection con, long fileObjID, String artifactClause) throws TskCoreException {
        HashMap<Long, Long> eventIDToDescriptionIDs = new HashMap<Long, Long>();
        String sql = "SELECT event_id, tsk_events.event_description_id FROM tsk_events  LEFT JOIN tsk_event_descriptions ON ( tsk_events.event_description_id = tsk_event_descriptions.event_description_id ) WHERE content_obj_id = " + fileObjID + artifactClause;
        try (Statement selectStmt = con.createStatement();
             ResultSet executeQuery = selectStmt.executeQuery(sql);){
            while (executeQuery.next()) {
                eventIDToDescriptionIDs.put(executeQuery.getLong("event_id"), executeQuery.getLong("event_description_id"));
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error getting event description ids for object id = " + fileObjID, ex);
        }
        return eventIDToDescriptionIDs;
    }

    @Beta
    public Set<Long> updateEventsForContentTagAdded(Content content) throws TskCoreException {
        this.caseDB.acquireSingleUserCaseWriteLock();
        try {
            SleuthkitCase.CaseDbConnection conn = this.caseDB.getConnection();
            try {
                Map<Long, Long> eventIDs = this.getEventAndDescriptionIDs(conn, content.getId(), false);
                this.updateEventSourceTaggedFlag(conn, eventIDs.values(), 1);
                Set<Long> set = eventIDs.keySet();
                if (conn != null) {
                    conn.close();
                }
                return set;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.caseDB.releaseSingleUserCaseWriteLock();
        }
    }

    @Beta
    public Set<Long> updateEventsForContentTagDeleted(Content content) throws TskCoreException {
        this.caseDB.acquireSingleUserCaseWriteLock();
        try {
            SleuthkitCase.CaseDbConnection conn;
            block13: {
                conn = this.caseDB.getConnection();
                try {
                    if (!this.caseDB.getContentTagsByContent(content).isEmpty()) break block13;
                    Map<Long, Long> eventIDs = this.getEventAndDescriptionIDs(conn, content.getId(), false);
                    this.updateEventSourceTaggedFlag(conn, eventIDs.values(), 0);
                    Set<Long> set = eventIDs.keySet();
                    if (conn != null) {
                        conn.close();
                    }
                    return set;
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            Set<Long> set = Collections.emptySet();
            if (conn != null) {
                conn.close();
            }
            return set;
        }
        finally {
            this.caseDB.releaseSingleUserCaseWriteLock();
        }
    }

    public Set<Long> updateEventsForArtifactTagAdded(BlackboardArtifact artifact) throws TskCoreException {
        this.caseDB.acquireSingleUserCaseWriteLock();
        try {
            SleuthkitCase.CaseDbConnection conn = this.caseDB.getConnection();
            try {
                Map<Long, Long> eventIDs = this.getEventAndDescriptionIDs(conn, artifact.getObjectID(), artifact.getArtifactID());
                this.updateEventSourceTaggedFlag(conn, eventIDs.values(), 1);
                Set<Long> set = eventIDs.keySet();
                if (conn != null) {
                    conn.close();
                }
                return set;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.caseDB.releaseSingleUserCaseWriteLock();
        }
    }

    public Set<Long> updateEventsForArtifactTagDeleted(BlackboardArtifact artifact) throws TskCoreException {
        this.caseDB.acquireSingleUserCaseWriteLock();
        try {
            SleuthkitCase.CaseDbConnection conn;
            block13: {
                conn = this.caseDB.getConnection();
                try {
                    if (!this.caseDB.getBlackboardArtifactTagsByArtifact(artifact).isEmpty()) break block13;
                    Map<Long, Long> eventIDs = this.getEventAndDescriptionIDs(conn, artifact.getObjectID(), artifact.getArtifactID());
                    this.updateEventSourceTaggedFlag(conn, eventIDs.values(), 0);
                    Set<Long> set = eventIDs.keySet();
                    if (conn != null) {
                        conn.close();
                    }
                    return set;
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            Set<Long> set = Collections.emptySet();
            if (conn != null) {
                conn.close();
            }
            return set;
        }
        finally {
            this.caseDB.releaseSingleUserCaseWriteLock();
        }
    }

    private void updateEventSourceTaggedFlag(SleuthkitCase.CaseDbConnection conn, Collection<Long> eventDescriptionIDs, int flagValue) throws TskCoreException {
        if (eventDescriptionIDs.isEmpty()) {
            return;
        }
        String sql = "UPDATE tsk_event_descriptions SET tagged = " + flagValue + " WHERE event_description_id IN (" + CommManagerSqlStringUtils.buildCSVString(eventDescriptionIDs) + ")";
        try (Statement updateStatement = conn.createStatement();){
            updateStatement.executeUpdate(sql);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error marking content events tagged: " + sql, ex);
        }
    }

    /*
     * Exception decompiling
     */
    public Set<Long> updateEventsForHashSetHit(Content content) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK], 2[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void rollBackTransaction(SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        trans.rollback();
    }

    /*
     * Exception decompiling
     */
    public Map<TimelineEventType, Long> countEventsByType(Long startTime, Long endTime, TimelineFilter.RootFilter filter, TimelineEventType.HierarchyLevel typeHierachyLevel) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static TskCoreException newEventTypeMappingException(int eventTypeID) {
        return new TskCoreException("Error mapping event type id " + eventTypeID + " to EventType.");
    }

    private static String getAugmentedEventsTablesSQL(TimelineFilter.RootFilter filter) {
        TimelineFilter.FileTypesFilter fileTypesFitler = filter.getFileTypesFilter();
        boolean needsMimeTypes = fileTypesFitler != null && fileTypesFitler.hasSubFilters();
        return TimelineManager.getAugmentedEventsTablesSQL(needsMimeTypes);
    }

    private static String getAugmentedEventsTablesSQL(boolean needMimeTypes) {
        return "( SELECT event_id, time, tsk_event_descriptions.data_source_obj_id, content_obj_id, artifact_id,  full_description, med_description, short_description, tsk_events.event_type_id, super_type_id, hash_hit, tagged " + (needMimeTypes ? ", mime_type" : "") + " FROM tsk_events  JOIN tsk_event_descriptions ON ( tsk_event_descriptions.event_description_id = tsk_events.event_description_id) JOIN tsk_event_types ON (tsk_events.event_type_id = tsk_event_types.event_type_id )  " + (needMimeTypes ? " LEFT OUTER JOIN tsk_files \tON (tsk_event_descriptions.content_obj_id = tsk_files.obj_id)" : "") + ")  AS tsk_events";
    }

    private static int booleanToInt(boolean value) {
        return value ? 1 : 0;
    }

    private static boolean intToBoolean(int value) {
        return value != 0;
    }

    public List<TimelineEvent> getEvents(Interval timeRange, TimelineFilter.RootFilter filter) throws TskCoreException {
        Long endTime;
        ArrayList<TimelineEvent> events = new ArrayList<TimelineEvent>();
        Long startTime = timeRange.getStartMillis() / 1000L;
        if (Objects.equals(startTime, endTime = Long.valueOf(timeRange.getEndMillis() / 1000L))) {
            Long l = endTime;
            endTime = endTime + 1L;
        }
        if (filter == null) {
            return events;
        }
        if (endTime < startTime) {
            return events;
        }
        String querySql = "SELECT time, content_obj_id, data_source_obj_id, artifact_id,   event_id,  hash_hit,  tagged,  event_type_id, super_type_id,  full_description, med_description, short_description  FROM " + TimelineManager.getAugmentedEventsTablesSQL(filter) + " WHERE time >= " + startTime + " AND time < " + endTime + " AND " + this.getSQLWhere(filter) + " ORDER BY time";
        this.caseDB.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection con = this.caseDB.getConnection();
             Statement stmt = con.createStatement();
             ResultSet resultSet = stmt.executeQuery(querySql);){
            while (resultSet.next()) {
                int eventTypeID = resultSet.getInt("event_type_id");
                TimelineEventType eventType = this.getEventType(eventTypeID).orElseThrow(() -> new TskCoreException("Error mapping event type id " + eventTypeID + "to EventType."));
                TimelineEvent event = new TimelineEvent(resultSet.getLong("event_id"), resultSet.getLong("data_source_obj_id"), resultSet.getLong("content_obj_id"), resultSet.getLong("artifact_id"), resultSet.getLong("time"), eventType, resultSet.getString("full_description"), resultSet.getString("med_description"), resultSet.getString("short_description"), resultSet.getInt("hash_hit") != 0, resultSet.getInt("tagged") != 0);
                events.add(event);
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error getting events from db: " + querySql, ex);
        }
        finally {
            this.caseDB.releaseSingleUserCaseReadLock();
        }
        return events;
    }

    private static String typeColumnHelper(boolean useSubTypes) {
        return useSubTypes ? "event_type_id" : "super_type_id";
    }

    String getSQLWhere(TimelineFilter.RootFilter filter) {
        if (filter == null) {
            return this.getTrueLiteral();
        }
        String result = filter.getSQLWhere(this);
        return result;
    }

    private String getSqlIgnoreConflict(String insertTableValues) throws TskCoreException {
        switch (this.caseDB.getDatabaseType()) {
            case POSTGRESQL: {
                return "INSERT INTO " + insertTableValues + " ON CONFLICT DO NOTHING";
            }
            case SQLITE: {
                return "INSERT OR IGNORE INTO " + insertTableValues;
            }
        }
        throw new TskCoreException("Unknown DB Type: " + this.caseDB.getDatabaseType().name());
    }

    private String getTrueLiteral() {
        switch (this.caseDB.getDatabaseType()) {
            case POSTGRESQL: {
                return "TRUE";
            }
            case SQLITE: {
                return "1";
            }
        }
        throw new UnsupportedOperationException("Unsupported DB type: " + this.caseDB.getDatabaseType().name());
    }

    private static /* synthetic */ TskCoreException lambda$countEventsByType$0(int eventTypeID) {
        return TimelineManager.newEventTypeMappingException(eventTypeID);
    }

    private static enum STATEMENTS {
        GET_MAX_TIME("SELECT Max(time) AS max FROM tsk_events"),
        GET_MIN_TIME("SELECT Min(time) AS min FROM tsk_events");

        private final String sql;

        private STATEMENTS(String sql) {
            this.sql = sql;
        }

        String getSQL() {
            return this.sql;
        }
    }

    private static class DuplicateException
    extends Exception {
        private static final long serialVersionUID = 1L;

        DuplicateException(String message) {
            super(message);
        }
    }

    public static final class TimelineEventAddedEvent {
        private final TimelineEvent addedEvent;

        public TimelineEvent getAddedEvent() {
            return this.addedEvent;
        }

        TimelineEventAddedEvent(TimelineEvent event) {
            this.addedEvent = event;
        }
    }
}

