/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.BundleProvider;
import org.sleuthkit.datamodel.TimelineEventArtifactTypeImpl;
import org.sleuthkit.datamodel.TimelineEventArtifactTypeSingleDescription;
import org.sleuthkit.datamodel.TimelineEventTypeImpl;
import org.sleuthkit.datamodel.TimelineEventTypes;

@Beta
public interface TimelineEventType
extends Comparable<TimelineEventType> {
    public static final TimelineEventType ROOT_EVENT_TYPE = new TimelineEventTypeImpl(0L, BundleProvider.getBundle().getString("RootEventType.eventTypes.name"), HierarchyLevel.ROOT, null){

        public SortedSet<TimelineEventType> getChildren() {
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.orderedBy((Comparator)new Comparator<TimelineEventType>(this){

                @Override
                public int compare(TimelineEventType o1, TimelineEventType o2) {
                    return Long.valueOf(o1.getTypeID()).compareTo(o2.getTypeID());
                }
            });
            builder.add((Object[])new TimelineEventType[]{FILE_SYSTEM, WEB_ACTIVITY, MISC_TYPES});
            return builder.build();
        }
    };
    public static final TimelineEventType FILE_SYSTEM = new TimelineEventTypeImpl(1L, BundleProvider.getBundle().getString("BaseTypes.fileSystem.name"), HierarchyLevel.CATEGORY, ROOT_EVENT_TYPE){

        public SortedSet<TimelineEventType> getChildren() {
            return ImmutableSortedSet.of((Comparable)FILE_MODIFIED, (Comparable)FILE_ACCESSED, (Comparable)FILE_CREATED, (Comparable)FILE_CHANGED);
        }
    };
    public static final TimelineEventType WEB_ACTIVITY = new TimelineEventTypeImpl(2L, BundleProvider.getBundle().getString("BaseTypes.webActivity.name"), HierarchyLevel.CATEGORY, ROOT_EVENT_TYPE){

        public SortedSet<TimelineEventType> getChildren() {
            return ImmutableSortedSet.of((Comparable)WEB_DOWNLOADS, (Comparable)WEB_COOKIE, (Comparable)WEB_COOKIE_ACCESSED, (Comparable)WEB_COOKIE_END, (Comparable)WEB_BOOKMARK, (Comparable)WEB_HISTORY, (Comparable[])new TimelineEventType[]{WEB_SEARCH, WEB_FORM_AUTOFILL, WEB_FORM_ADDRESSES, WEB_FORM_ADDRESSES_MODIFIED, WEB_FORM_AUTOFILL_ACCESSED, WEB_CACHE, WEB_HISTORY_CREATED});
        }
    };
    public static final TimelineEventType MISC_TYPES = new TimelineEventTypeImpl(3L, BundleProvider.getBundle().getString("BaseTypes.miscTypes.name"), HierarchyLevel.CATEGORY, ROOT_EVENT_TYPE){

        public SortedSet<TimelineEventType> getChildren() {
            return ImmutableSortedSet.of((Comparable)CALL_LOG, (Comparable)CALL_LOG_END, (Comparable)DEVICES_ATTACHED, (Comparable)EMAIL, (Comparable)EMAIL_RCVD, (Comparable)EXIF, (Comparable[])new TimelineEventType[]{GPS_BOOKMARK, GPS_LAST_KNOWN_LOCATION, GPS_TRACKPOINT, GPS_ROUTE, GPS_SEARCH, GPS_TRACK, INSTALLED_PROGRAM, LOG_ENTRY, MESSAGE, METADATA_LAST_PRINTED, METADATA_LAST_SAVED, METADATA_CREATED, PROGRAM_EXECUTION, RECENT_DOCUMENTS, REGISTRY, BACKUP_EVENT_START, BACKUP_EVENT_END, BLUETOOTH_PAIRING, CALENDAR_ENTRY_START, CALENDAR_ENTRY_END, PROGRAM_DELETED, OS_INFO, WIFI_NETWORK, USER_DEVICE_EVENT_START, USER_DEVICE_EVENT_END, SERVICE_ACCOUNT, SCREEN_SHOT, PROGRAM_NOTIFICATION, BLUETOOTH_PAIRING_ACCESSED, BLUETOOTH_ADAPTER, CUSTOM_ARTIFACT_CATCH_ALL, STANDARD_ARTIFACT_CATCH_ALL, USER_CREATED});
        }
    };
    public static final TimelineEventType FILE_MODIFIED = new TimelineEventTypes.FilePathEventType(4L, BundleProvider.getBundle().getString("FileSystemTypes.fileModified.name"), HierarchyLevel.EVENT, FILE_SYSTEM);
    public static final TimelineEventType FILE_ACCESSED = new TimelineEventTypes.FilePathEventType(5L, BundleProvider.getBundle().getString("FileSystemTypes.fileAccessed.name"), HierarchyLevel.EVENT, FILE_SYSTEM);
    public static final TimelineEventType FILE_CREATED = new TimelineEventTypes.FilePathEventType(6L, BundleProvider.getBundle().getString("FileSystemTypes.fileCreated.name"), HierarchyLevel.EVENT, FILE_SYSTEM);
    public static final TimelineEventType FILE_CHANGED = new TimelineEventTypes.FilePathEventType(7L, BundleProvider.getBundle().getString("FileSystemTypes.fileChanged.name"), HierarchyLevel.EVENT, FILE_SYSTEM);
    public static final TimelineEventType WEB_DOWNLOADS = new TimelineEventTypes.URLArtifactEventType(8, BundleProvider.getBundle().getString("WebTypes.webDownloads.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_DOWNLOAD), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL));
    public static final TimelineEventType WEB_COOKIE = new TimelineEventTypes.URLArtifactEventType(9, BundleProvider.getBundle().getString("WebTypes.webCookies.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_COOKIE), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL));
    public static final TimelineEventType WEB_BOOKMARK = new TimelineEventTypes.URLArtifactEventType(10, BundleProvider.getBundle().getString("WebTypes.webBookmarks.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_BOOKMARK), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL));
    public static final TimelineEventType WEB_HISTORY = new TimelineEventTypes.URLArtifactEventType(11, BundleProvider.getBundle().getString("WebTypes.webHistory.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_HISTORY), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL));
    public static final TimelineEventType WEB_SEARCH = new TimelineEventTypes.URLArtifactEventType(12, BundleProvider.getBundle().getString("WebTypes.webSearch.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_SEARCH_QUERY), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DOMAIN));
    public static final TimelineEventType MESSAGE = new TimelineEventArtifactTypeImpl(13, BundleProvider.getBundle().getString("MiscTypes.message.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_MESSAGE), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_MESSAGE_TYPE)), artf -> {
        BlackboardAttribute dir = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DIRECTION));
        BlackboardAttribute readStatus = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_READ_STATUS));
        BlackboardAttribute name = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME));
        BlackboardAttribute subject = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_SUBJECT));
        BlackboardAttribute phoneNumber = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER));
        if (phoneNumber == null) {
            phoneNumber = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_TO));
        }
        if (phoneNumber == null) {
            phoneNumber = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_FROM));
        }
        List<String> asList = Arrays.asList(TimelineEventType.stringValueOf(dir), TimelineEventType.stringValueOf(readStatus), name == null && phoneNumber == null ? "" : TimelineEventType.toFrom(dir), name != null || phoneNumber != null ? TimelineEventType.stringValueOf((BlackboardAttribute)MoreObjects.firstNonNull((Object)name, (Object)phoneNumber)) : "", TimelineEventType.stringValueOf(subject));
        return String.join((CharSequence)" ", asList);
    }, new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_TEXT)));
    public static final TimelineEventType GPS_ROUTE = new TimelineEventArtifactTypeImpl(14, BundleProvider.getBundle().getString("MiscTypes.GPSRoutes.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_ROUTE), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME)), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_LOCATION)), artf -> {
        BlackboardAttribute latStart = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LATITUDE_START));
        BlackboardAttribute longStart = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LONGITUDE_START));
        BlackboardAttribute latEnd = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LATITUDE_END));
        BlackboardAttribute longEnd = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LONGITUDE_END));
        return String.format("From latitude: %1$s longitude: %2$s To latitude: %3$s longitude: %4$s", TimelineEventType.stringValueOf(latStart), TimelineEventType.stringValueOf(longStart), TimelineEventType.stringValueOf(latEnd), TimelineEventType.stringValueOf(longEnd));
    });
    public static final TimelineEventType GPS_TRACKPOINT = new TimelineEventArtifactTypeImpl(15, BundleProvider.getBundle().getString("MiscTypes.GPSTrackpoint.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_TRACKPOINT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME)), artf -> {
        BlackboardAttribute longitude = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LONGITUDE));
        BlackboardAttribute latitude = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LATITUDE));
        return "Latitude: " + TimelineEventType.stringValueOf(latitude) + " Longitude: " + TimelineEventType.stringValueOf(longitude);
    }, new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType CALL_LOG = new TimelineEventArtifactTypeImpl(16, BundleProvider.getBundle().getString("MiscTypes.Calls.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_CALLLOG), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_START), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME)), artf -> {
        BlackboardAttribute phoneNumber = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER));
        if (phoneNumber == null) {
            phoneNumber = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_TO));
        }
        if (phoneNumber == null) {
            phoneNumber = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_FROM));
        }
        return "Phone Number: " + TimelineEventType.stringValueOf(phoneNumber);
    }, new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DIRECTION)));
    public static final TimelineEventType EMAIL = new TimelineEventArtifactTypeImpl(17, BundleProvider.getBundle().getString("MiscTypes.Email.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_EMAIL_MSG), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_SENT), artf -> {
        String emailTo;
        String emailFrom = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_FROM)));
        if (emailFrom.length() > 75) {
            emailFrom = emailFrom.substring(0, 75);
        }
        if ((emailTo = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_TO)))).length() > 75) {
            emailTo = emailTo.substring(0, 75);
        }
        return "Sent from: " + emailFrom + "Sent to: " + emailTo;
    }, new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_SUBJECT)), artf -> {
        BlackboardAttribute msgAttribute = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_CONTENT_PLAIN));
        String msg = TimelineEventType.stringValueOf(msgAttribute);
        if (msg.length() > 150) {
            msg = msg.substring(0, 150);
        }
        return msg;
    });
    public static final TimelineEventType RECENT_DOCUMENTS = new TimelineEventTypes.FilePathArtifactEventType(18, BundleProvider.getBundle().getString("MiscTypes.recentDocuments.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_RECENT_OBJECT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PATH));
    public static final TimelineEventType INSTALLED_PROGRAM = new TimelineEventArtifactTypeImpl(19, BundleProvider.getBundle().getString("MiscTypes.installedPrograms.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_INSTALLED_PROG), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME)), new TimelineEventTypes.EmptyExtractor(), new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType EXIF = new TimelineEventArtifactTypeImpl(20, BundleProvider.getBundle().getString("MiscTypes.exif.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_METADATA_EXIF), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DEVICE_MAKE)), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DEVICE_MODEL)), artf -> artf.getSleuthkitCase().getAbstractFileById(artf.getObjectID()).getName());
    public static final TimelineEventType DEVICES_ATTACHED = new TimelineEventArtifactTypeImpl(21, BundleProvider.getBundle().getString("MiscTypes.devicesAttached.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_DEVICE_ATTACHED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DEVICE_MAKE)), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DEVICE_MODEL)), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DEVICE_ID)));
    public static final int DEPRECATED_OTHER_EVENT_ID = 22;
    public static final TimelineEventType STANDARD_ARTIFACT_CATCH_ALL = new TimelineEventArtifactTypeSingleDescription(23, BundleProvider.getBundle().getString("CustomTypes.other.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_TL_EVENT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DESCRIPTION));
    public static final TimelineEventType LOG_ENTRY = new TimelineEventArtifactTypeSingleDescription(24, BundleProvider.getBundle().getString("MiscTypes.LogEntry.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_TL_EVENT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DESCRIPTION));
    public static final TimelineEventType REGISTRY = new TimelineEventArtifactTypeSingleDescription(25, BundleProvider.getBundle().getString("MiscTypes.Registry.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_TL_EVENT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DESCRIPTION));
    public static final TimelineEventType CUSTOM_ARTIFACT_CATCH_ALL = new TimelineEventArtifactTypeSingleDescription(26, BundleProvider.getBundle().getString("CustomTypes.customArtifact.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_TL_EVENT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DESCRIPTION));
    public static final TimelineEventType WEB_FORM_AUTOFILL = new TimelineEventArtifactTypeImpl(27, BundleProvider.getBundle().getString("WebTypes.webFormAutoFill.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_FORM_AUTOFILL), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED), artf -> {
        BlackboardAttribute name = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME));
        BlackboardAttribute value = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_VALUE));
        BlackboardAttribute count = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_COUNT));
        return TimelineEventType.stringValueOf(name) + ":" + TimelineEventType.stringValueOf(value);
    }, new TimelineEventTypes.EmptyExtractor(), new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType WEB_FORM_ADDRESSES = new TimelineEventTypes.URLArtifactEventType(28, BundleProvider.getBundle().getString("WebTypes.webFormAddress.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_FORM_ADDRESS), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL));
    public static final TimelineEventType GPS_BOOKMARK = new TimelineEventArtifactTypeImpl(29, BundleProvider.getBundle().getString("MiscTypes.GPSBookmark.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_BOOKMARK), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME)), artf -> {
        BlackboardAttribute longitude = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LONGITUDE));
        BlackboardAttribute latitude = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LATITUDE));
        return "Latitude: " + TimelineEventType.stringValueOf(latitude) + " Longitude: " + TimelineEventType.stringValueOf(longitude);
    }, new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType GPS_LAST_KNOWN_LOCATION = new TimelineEventArtifactTypeImpl(30, BundleProvider.getBundle().getString("MiscTypes.GPSLastknown.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_LAST_KNOWN_LOCATION), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME)), artf -> {
        BlackboardAttribute longitude = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LONGITUDE));
        BlackboardAttribute latitude = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LATITUDE));
        return "Latitude: " + TimelineEventType.stringValueOf(latitude) + " Longitude: " + TimelineEventType.stringValueOf(longitude);
    }, new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType GPS_SEARCH = new TimelineEventArtifactTypeImpl(31, BundleProvider.getBundle().getString("MiscTypes.GPSearch.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_SEARCH), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME)), artf -> {
        BlackboardAttribute longitude = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LONGITUDE));
        BlackboardAttribute latitude = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_GEO_LATITUDE));
        return "Latitude: " + TimelineEventType.stringValueOf(latitude) + " Longitude: " + TimelineEventType.stringValueOf(longitude);
    }, new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType GPS_TRACK = new TimelineEventTypes.GPSTrackArtifactEventType(32, BundleProvider.getBundle().getString("MiscTypes.GPSTrack.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_GPS_TRACK), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME));
    public static final TimelineEventType METADATA_LAST_PRINTED = new TimelineEventArtifactTypeImpl(33, BundleProvider.getBundle().getString("MiscTypes.metadataLastPrinted.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_METADATA), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_LAST_PRINTED_DATETIME), artf -> BundleProvider.getBundle().getString("MiscTypes.metadataLastPrinted.name"), new TimelineEventTypes.EmptyExtractor(), new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType METADATA_LAST_SAVED = new TimelineEventArtifactTypeImpl(34, BundleProvider.getBundle().getString("MiscTypes.metadataLastSaved.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_METADATA), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_MODIFIED), artf -> BundleProvider.getBundle().getString("MiscTypes.metadataLastSaved.name"), new TimelineEventTypes.EmptyExtractor(), new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType METADATA_CREATED = new TimelineEventArtifactTypeImpl(35, BundleProvider.getBundle().getString("MiscTypes.metadataCreated.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_METADATA), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED), artf -> BundleProvider.getBundle().getString("MiscTypes.metadataCreated.name"), new TimelineEventTypes.EmptyExtractor(), new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType PROGRAM_EXECUTION = new TimelineEventArtifactTypeImpl(36, BundleProvider.getBundle().getString("MiscTypes.programexecuted.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_PROG_RUN), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME)), artf -> {
        String userName = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_USER_NAME)));
        if (userName != null) {
            return userName;
        }
        return "";
    }, new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_COMMENT)));
    public static final TimelineEventType WEB_FORM_AUTOFILL_ACCESSED = new TimelineEventArtifactTypeImpl(37, BundleProvider.getBundle().getString("WebTypes.webFormAutofillAccessed.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_FORM_AUTOFILL), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED), artf -> {
        BlackboardAttribute name = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME));
        BlackboardAttribute value = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_VALUE));
        BlackboardAttribute count = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_COUNT));
        return TimelineEventType.stringValueOf(name) + ":" + TimelineEventType.stringValueOf(value) + " Access count: " + TimelineEventType.stringValueOf(count);
    }, new TimelineEventTypes.EmptyExtractor(), new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType CALL_LOG_END = new TimelineEventArtifactTypeImpl(38, BundleProvider.getBundle().getString("MiscTypes.CallsEnd.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_CALLLOG), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_END), new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME)), artf -> {
        BlackboardAttribute phoneNumber = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER));
        if (phoneNumber == null) {
            phoneNumber = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_TO));
        }
        if (phoneNumber == null) {
            phoneNumber = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PHONE_NUMBER_FROM));
        }
        return "Phone number: " + TimelineEventType.stringValueOf(phoneNumber);
    }, new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DIRECTION)));
    public static final TimelineEventType EMAIL_RCVD = new TimelineEventArtifactTypeImpl(39, BundleProvider.getBundle().getString("MiscTypes.EmailRcvd.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_EMAIL_MSG), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_RCVD), artf -> {
        String emailTo;
        String emailFrom = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_FROM)));
        if (emailFrom.length() > 75) {
            emailFrom = emailFrom.substring(0, 75);
        }
        if ((emailTo = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_TO)))).length() > 75) {
            emailTo = emailTo.substring(0, 75);
        }
        return "Message from: " + emailFrom + " To: " + emailTo;
    }, new TimelineEventArtifactTypeImpl.AttributeExtractor(new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_SUBJECT)), artf -> {
        BlackboardAttribute msgAttribute = TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL_CONTENT_PLAIN));
        String msg = TimelineEventType.stringValueOf(msgAttribute);
        if (msg.length() > 150) {
            msg = msg.substring(0, 150);
        }
        return msg;
    });
    public static final TimelineEventType WEB_FORM_ADDRESSES_MODIFIED = new TimelineEventTypes.URLArtifactEventType(40, BundleProvider.getBundle().getString("WebTypes.webFormAddressModified.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_FORM_ADDRESS), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_MODIFIED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_EMAIL));
    public static final TimelineEventType WEB_COOKIE_ACCESSED = new TimelineEventTypes.URLArtifactEventType(41, BundleProvider.getBundle().getString("WebTypes.webCookiesAccessed.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_COOKIE), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL));
    public static final TimelineEventType WEB_COOKIE_END = new TimelineEventTypes.URLArtifactEventType(42, BundleProvider.getBundle().getString("WebTypes.webCookiesEnd.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_COOKIE), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_END), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL)){

        @Override
        public boolean isDeprecated() {
            return true;
        }
    };
    public static final TimelineEventType BACKUP_EVENT_START = new TimelineEventArtifactTypeImpl(43, BundleProvider.getBundle().getString("TimelineEventType.BackupEventStart.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_BACKUP_EVENT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_START), artf -> BundleProvider.getBundle().getString("TimelineEventType.BackupEvent.description.start"), new TimelineEventTypes.EmptyExtractor(), new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType BACKUP_EVENT_END = new TimelineEventArtifactTypeImpl(44, BundleProvider.getBundle().getString("TimelineEventType.BackupEventEnd.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_BACKUP_EVENT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_END), artf -> BundleProvider.getBundle().getString("TimelineEventType.BackupEvent.description.end"), new TimelineEventTypes.EmptyExtractor(), new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType BLUETOOTH_PAIRING = new TimelineEventArtifactTypeSingleDescription(45, BundleProvider.getBundle().getString("TimelineEventType.BluetoothPairing.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_BLUETOOTH_PAIRING), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DEVICE_NAME));
    public static final TimelineEventType CALENDAR_ENTRY_START = new TimelineEventArtifactTypeSingleDescription(46, BundleProvider.getBundle().getString("TimelineEventType.CalendarEntryStart.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_CALENDAR_ENTRY), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_START), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DESCRIPTION));
    public static final TimelineEventType CALENDAR_ENTRY_END = new TimelineEventArtifactTypeSingleDescription(47, BundleProvider.getBundle().getString("TimelineEventType.CalendarEntryEnd.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_CALENDAR_ENTRY), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_END), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DESCRIPTION));
    public static final TimelineEventType PROGRAM_DELETED = new TimelineEventArtifactTypeSingleDescription(48, BundleProvider.getBundle().getString("TimelineEventType.DeletedProgram.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_DELETED_PROG), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME));
    public static final TimelineEventType OS_INFO = new TimelineEventArtifactTypeSingleDescription(49, BundleProvider.getBundle().getString("TimelineEventType.OSInfo.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_OS_INFO), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME));
    public static final TimelineEventType PROGRAM_NOTIFICATION = new TimelineEventArtifactTypeSingleDescription(50, BundleProvider.getBundle().getString("TimelineEventType.ProgramNotification.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_PROG_NOTIFICATIONS), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME));
    public static final TimelineEventType SCREEN_SHOT = new TimelineEventArtifactTypeSingleDescription(51, BundleProvider.getBundle().getString("TimelineEventType.ScreenShot.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_SCREEN_SHOTS), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME));
    public static final TimelineEventType SERVICE_ACCOUNT = new TimelineEventArtifactTypeImpl(52, BundleProvider.getBundle().getString("TimelineEventType.ServiceAccount.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_SERVICE_ACCOUNT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED), artf -> {
        String progName = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME)));
        String userId = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_USER_ID)));
        return String.format("Program Name: %s User ID: %s", progName, userId);
    }, new TimelineEventTypes.EmptyExtractor(), new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType USER_DEVICE_EVENT_START = new TimelineEventArtifactTypeImpl(53, BundleProvider.getBundle().getString("TimelineEventType.UserDeviceEventStart.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_USER_DEVICE_EVENT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_START), artf -> {
        String progName = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME)));
        String activityType = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ACTIVITY_TYPE)));
        String connectionType = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_VALUE)));
        return String.format("Program Name: %s Activity Type: %s Connection Type: %s", progName, activityType, connectionType);
    }, new TimelineEventTypes.EmptyExtractor(), new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType USER_DEVICE_EVENT_END = new TimelineEventArtifactTypeImpl(54, BundleProvider.getBundle().getString("TimelineEventType.UserDeviceEventEnd.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_USER_DEVICE_EVENT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_END), artf -> {
        String progName = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_PROG_NAME)));
        String activityType = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_ACTIVITY_TYPE)));
        String connectionType = TimelineEventType.stringValueOf(TimelineEventArtifactTypeImpl.getAttributeSafe(artf, new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_VALUE)));
        return String.format("Program Name: %s Activity Type: %s Connection Type: %s", progName, activityType, connectionType);
    }, new TimelineEventTypes.EmptyExtractor(), new TimelineEventTypes.EmptyExtractor());
    public static final TimelineEventType WEB_CACHE = new TimelineEventTypes.URLArtifactEventType(55, BundleProvider.getBundle().getString("TimelineEventType.WebCache.text"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_CACHE), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL));
    public static final TimelineEventType WIFI_NETWORK = new TimelineEventArtifactTypeSingleDescription(56, BundleProvider.getBundle().getString("TimelineEventType.WIFINetwork.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WIFI_NETWORK), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_SSID));
    public static final TimelineEventType WEB_HISTORY_CREATED = new TimelineEventTypes.URLArtifactEventType(57, BundleProvider.getBundle().getString("WebTypes.webHistoryCreated.name"), WEB_ACTIVITY, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_WEB_HISTORY), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_CREATED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_URL));
    public static final TimelineEventType BLUETOOTH_ADAPTER = new TimelineEventArtifactTypeSingleDescription(58, BundleProvider.getBundle().getString("TimelineEventType.BluetoothAdapter.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_BLUETOOTH_ADAPTER), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_NAME));
    public static final TimelineEventType BLUETOOTH_PAIRING_ACCESSED = new TimelineEventArtifactTypeSingleDescription(59, BundleProvider.getBundle().getString("TimelineEventType.BluetoothPairingLastConnection.txt"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_BLUETOOTH_PAIRING), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME_ACCESSED), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DEVICE_NAME));
    public static final TimelineEventType USER_CREATED = new TimelineEventArtifactTypeSingleDescription(60, BundleProvider.getBundle().getString("CustomTypes.userCreated.name"), MISC_TYPES, new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_TL_EVENT), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DATETIME), new BlackboardAttribute.Type(BlackboardAttribute.ATTRIBUTE_TYPE.TSK_DESCRIPTION));

    public String getDisplayName();

    public long getTypeID();

    public HierarchyLevel getTypeHierarchyLevel();

    public SortedSet<? extends TimelineEventType> getChildren();

    public Optional<? extends TimelineEventType> getChild(String var1);

    public TimelineEventType getParent();

    default public TimelineEventType getCategory() {
        TimelineEventType parentType = this.getParent();
        return parentType.equals(ROOT_EVENT_TYPE) ? this : parentType.getCategory();
    }

    default public SortedSet<? extends TimelineEventType> getSiblings() {
        return this.equals(ROOT_EVENT_TYPE) ? ImmutableSortedSet.of((Comparable)ROOT_EVENT_TYPE) : this.getParent().getChildren();
    }

    default public boolean isDeprecated() {
        return false;
    }

    @Override
    default public int compareTo(TimelineEventType otherType) {
        return Comparator.comparing(TimelineEventType::getDisplayName).compare(this, otherType);
    }

    public static SortedSet<? extends TimelineEventType> getCategoryTypes() {
        return ROOT_EVENT_TYPE.getChildren();
    }

    public static SortedSet<? extends TimelineEventType> getFileSystemTypes() {
        return FILE_SYSTEM.getChildren();
    }

    public static SortedSet<? extends TimelineEventType> getWebActivityTypes() {
        return WEB_ACTIVITY.getChildren();
    }

    public static SortedSet<? extends TimelineEventType> getMiscTypes() {
        return MISC_TYPES.getChildren();
    }

    public static String stringValueOf(BlackboardAttribute attr) {
        return Optional.ofNullable(attr).map(BlackboardAttribute::getDisplayString).orElse("");
    }

    public static String toFrom(BlackboardAttribute dir) {
        if (dir == null) {
            return "";
        }
        switch (dir.getDisplayString()) {
            case "Incoming": {
                return "from";
            }
            case "Outgoing": {
                return "to";
            }
        }
        return " ";
    }

    public static enum HierarchyLevel {
        ROOT(BundleProvider.getBundle().getString("EventTypeHierarchyLevel.root")),
        CATEGORY(BundleProvider.getBundle().getString("EventTypeHierarchyLevel.category")),
        EVENT(BundleProvider.getBundle().getString("EventTypeHierarchyLevel.event"));

        private final String displayName;

        public String getDisplayName() {
            return this.displayName;
        }

        private HierarchyLevel(String displayName) {
            this.displayName = displayName;
        }
    }
}

