/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardArtifactTag;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentTag;
import org.sleuthkit.datamodel.Examiner;
import org.sleuthkit.datamodel.Score;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TagName;
import org.sleuthkit.datamodel.TagSet;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.TskEvent;

public class TaggingManager {
    private final SleuthkitCase skCase;

    TaggingManager(SleuthkitCase skCase) {
        this.skCase = skCase;
    }

    public List<TagSet> getTagSets() throws TskCoreException {
        ArrayList<TagSet> tagSetList = new ArrayList<TagSet>();
        this.skCase.acquireSingleUserCaseReadLock();
        String getAllTagSetsQuery = "SELECT * FROM tsk_tag_sets";
        try (SleuthkitCase.CaseDbConnection connection = this.skCase.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet resultSet = stmt.executeQuery(getAllTagSetsQuery);){
            while (resultSet.next()) {
                int setID = resultSet.getInt("tag_set_id");
                String setName = resultSet.getString("name");
                TagSet set = new TagSet(setID, setName, this.getTagNamesByTagSetID(setID));
                tagSetList.add(set);
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error occurred getting TagSet list.", ex);
        }
        finally {
            this.skCase.releaseSingleUserCaseReadLock();
        }
        return tagSetList;
    }

    public TagSet addTagSet(String name, List<TagName> tagNames) throws TskCoreException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Error adding TagSet, TagSet name must be non-empty string.");
        }
        TagSet tagSet = null;
        SleuthkitCase.CaseDbTransaction trans = this.skCase.beginTransaction();
        try (Statement stmt = trans.getConnection().createStatement();){
            String query = String.format("INSERT INTO tsk_tag_sets (name) VALUES('%s')", name);
            if (this.skCase.getDatabaseType() == TskData.DbType.POSTGRESQL) {
                stmt.execute(query, 1);
            } else {
                stmt.execute(query);
            }
            try (ResultSet resultSet = stmt.getGeneratedKeys();){
                resultSet.next();
                int setID = resultSet.getInt(1);
                ArrayList<TagName> updatedTags = new ArrayList<TagName>();
                if (tagNames != null) {
                    for (int index = 0; index < tagNames.size(); ++index) {
                        TagName tagName = tagNames.get(index);
                        stmt.executeUpdate(String.format("UPDATE tag_names SET tag_set_id = %d, rank = %d WHERE tag_name_id = %d", setID, index, tagName.getId()));
                        updatedTags.add(new TagName(tagName.getId(), tagName.getDisplayName(), tagName.getDescription(), tagName.getColor(), tagName.getTagType(), setID, index));
                    }
                }
                tagSet = new TagSet(setID, name, updatedTags);
                this.skCase.fireTSKEvent(new TskEvent.TagSetsAddedTskEvent(Collections.singletonList(tagSet)));
                this.skCase.fireTSKEvent(new TskEvent.TagNamesUpdatedTskEvent((List<TagName>)updatedTags));
            }
            trans.commit();
        }
        catch (SQLException ex) {
            trans.rollback();
            throw new TskCoreException(String.format("Error adding tag set %s", name), ex);
        }
        return tagSet;
    }

    public void deleteTagSet(TagSet tagSet) throws TskCoreException {
        if (tagSet == null) {
            throw new IllegalArgumentException("Error adding deleting TagSet, TagSet object was null");
        }
        if (this.isTagSetInUse(tagSet)) {
            throw new TskCoreException("Unable to delete TagSet (%d). TagSet TagName list contains TagNames that are currently in use.");
        }
        SleuthkitCase.CaseDbTransaction trans = this.skCase.beginTransaction();
        try (Statement stmt = trans.getConnection().createStatement();){
            String queryTemplate = "DELETE FROM tag_names WHERE tag_name_id IN (SELECT tag_name_id FROM tag_names WHERE tag_set_id = %d)";
            stmt.execute(String.format(queryTemplate, tagSet.getId()));
            queryTemplate = "DELETE FROM tsk_tag_sets WHERE tag_set_id = '%d'";
            stmt.execute(String.format(queryTemplate, tagSet.getId()));
            trans.commit();
            ArrayList<Long> tagNameIds = new ArrayList<Long>();
            for (TagName tagName : tagSet.getTagNames()) {
                tagNameIds.add(tagName.getId());
            }
            this.skCase.fireTSKEvent(new TskEvent.TagSetsDeletedTskEvent(Collections.singletonList(tagSet.getId())));
            this.skCase.fireTSKEvent(new TskEvent.TagNamesDeletedTskEvent((List<Long>)tagNameIds));
        }
        catch (SQLException ex) {
            trans.rollback();
            throw new TskCoreException(String.format("Error deleting tag set where id = %d.", tagSet.getId()), ex);
        }
    }

    /*
     * Exception decompiling
     */
    public TagSet getTagSet(TagName tagName) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TagSet getTagSet(long id) throws TskCoreException {
        TagSet tagSet = null;
        String preparedQuery = "Select * FROM tsk_tag_sets WHERE tag_set_id = ?";
        this.skCase.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection connection = this.skCase.getConnection();
             PreparedStatement statement = connection.getPreparedStatement(preparedQuery, 2);){
            statement.setLong(1, id);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    int setID = resultSet.getInt("tag_set_id");
                    String setName = resultSet.getString("name");
                    tagSet = new TagSet(setID, setName, this.getTagNamesByTagSetID(setID));
                }
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error occurred getting TagSet (ID=%d)", id), ex);
        }
        finally {
            this.skCase.releaseSingleUserCaseReadLock();
        }
        return tagSet;
    }

    public BlackboardArtifactTagChange addArtifactTag(BlackboardArtifact artifact, TagName tagName, String comment) throws TskCoreException {
        if (artifact == null || tagName == null) {
            throw new IllegalArgumentException("NULL argument passed to addArtifactTag");
        }
        ArrayList<BlackboardArtifactTag> removedTags = new ArrayList<BlackboardArtifactTag>();
        ArrayList<String> removedTagIds = new ArrayList<String>();
        SleuthkitCase.CaseDbTransaction trans = null;
        try {
            BlackboardArtifactTag artifactTag;
            Statement stmt;
            long tagSetId = tagName.getTagSetId();
            if (tagSetId > 0L) {
                String selectQuery = String.format("SELECT * from blackboard_artifact_tags JOIN tag_names ON tag_names.tag_name_id = blackboard_artifact_tags.tag_name_id JOIN tsk_examiners on tsk_examiners.examiner_id = blackboard_artifact_tags.examiner_id WHERE artifact_id = %d AND tag_names.tag_set_id = %d", artifact.getArtifactID(), tagSetId);
                try (Statement stmt2 = this.skCase.getConnection().createStatement();
                     ResultSet resultSet = stmt2.executeQuery(selectQuery);){
                    while (resultSet.next()) {
                        TagName removedTag = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), tagSetId, resultSet.getInt("rank"));
                        BlackboardArtifactTag bat = new BlackboardArtifactTag(resultSet.getLong("tag_id"), artifact, this.skCase.getContentById(artifact.getObjectID()), removedTag, resultSet.getString("comment"), resultSet.getString("login_name"));
                        removedTags.add(bat);
                        removedTagIds.add(Long.toString(bat.getId()));
                    }
                }
            }
            Content content = this.skCase.getContentById(artifact.getObjectID());
            Examiner currentExaminer = this.skCase.getCurrentExaminer();
            trans = this.skCase.beginTransaction();
            SleuthkitCase.CaseDbConnection connection = trans.getConnection();
            if (!removedTags.isEmpty()) {
                String removeQuery = String.format("DELETE FROM blackboard_artifact_tags WHERE tag_id IN (%s)", String.join((CharSequence)",", removedTagIds));
                stmt = connection.createStatement();
                try {
                    stmt.executeUpdate(removeQuery);
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            stmt = connection.createStatement();
            try {
                String query = String.format("INSERT INTO blackboard_artifact_tags (artifact_id, tag_name_id, comment, examiner_id) VALUES (%d, %d, '%s', %d)", artifact.getArtifactID(), tagName.getId(), comment, currentExaminer.getId());
                if (this.skCase.getDatabaseType() == TskData.DbType.POSTGRESQL) {
                    stmt.execute(query, 1);
                } else {
                    stmt.execute(query);
                }
                try (ResultSet resultSet = stmt.getGeneratedKeys();){
                    resultSet.next();
                    artifactTag = new BlackboardArtifactTag(resultSet.getLong(1), artifact, content, tagName, comment, currentExaminer.getLoginName());
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            this.skCase.getScoringManager().updateAggregateScoreAfterAddition(artifact.getId(), artifact.getDataSourceObjectID(), TaggingManager.getTagScore(tagName.getTagType()), trans);
            trans.commit();
            return new BlackboardArtifactTagChange(artifactTag, removedTags);
        }
        catch (SQLException ex) {
            if (trans != null) {
                trans.rollback();
            }
            throw new TskCoreException("Error adding row to blackboard_artifact_tags table (obj_id = " + artifact.getArtifactID() + ", tag_name_id = " + tagName.getId() + ")", ex);
        }
    }

    static Score getTagScore(TskData.TagType tagType) {
        switch (tagType) {
            case BAD: {
                return Score.SCORE_NOTABLE;
            }
            case SUSPICIOUS: {
                return Score.SCORE_LIKELY_NOTABLE;
            }
        }
        return Score.SCORE_UNKNOWN;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    Optional<TskData.TagType> getMaxTagType(long objectId, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        String queryString = "SELECT tag_names.knownStatus AS knownStatus\n\tFROM (\n\t\tSELECT ctags.tag_name_id AS tag_name_id FROM content_tags ctags WHERE ctags.obj_id = " + objectId + "\n\t    UNION\n\t    SELECT btags.tag_name_id AS tag_name_id FROM blackboard_artifact_tags btags \n\t    INNER JOIN blackboard_artifacts ba ON btags.artifact_id = ba.artifact_id\n\t    WHERE ba.artifact_obj_id = " + objectId + "\n\t) tag_name_ids\n\tINNER JOIN tag_names ON tag_name_ids.tag_name_id = tag_names.tag_name_id\n\tORDER BY tag_names.knownStatus DESC\n\tLIMIT 1";
        try (Statement statement = transaction.getConnection().createStatement();){
            Optional<TskData.TagType> optional;
            block18: {
                ResultSet resultSet;
                block16: {
                    Optional<TskData.TagType> optional2;
                    block17: {
                        resultSet = transaction.getConnection().executeQuery(statement, queryString);
                        try {
                            if (!resultSet.next()) break block16;
                            optional2 = Optional.ofNullable(TskData.TagType.valueOf(resultSet.getByte("knownStatus")));
                            if (resultSet == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (resultSet != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (resultSet == null) break block18;
                resultSet.close();
            }
            return optional;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error getting content tag TagType for content with id: " + objectId);
        }
    }

    public ContentTagChange addContentTag(Content content, TagName tagName, String comment, long beginByteOffset, long endByteOffset) throws TskCoreException {
        ArrayList<ContentTag> removedTags = new ArrayList<ContentTag>();
        ArrayList<String> removedTagIds = new ArrayList<String>();
        Examiner currentExaminer = this.skCase.getCurrentExaminer();
        SleuthkitCase.CaseDbTransaction trans = this.skCase.beginTransaction();
        SleuthkitCase.CaseDbConnection connection = trans.getConnection();
        try {
            Statement stmt;
            long tagSetId = tagName.getTagSetId();
            if (tagSetId > 0L) {
                String selectQuery = String.format("SELECT * from content_tags JOIN tag_names ON tag_names.tag_name_id = content_tags.tag_name_id JOIN tsk_examiners on tsk_examiners.examiner_id = content_tags.examiner_id WHERE obj_id = %d AND tag_names.tag_set_id = %d", content.getId(), tagSetId);
                try (Statement stmt2 = connection.createStatement();
                     ResultSet resultSet = stmt2.executeQuery(selectQuery);){
                    while (resultSet.next()) {
                        TagName removedTag = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), tagSetId, resultSet.getInt("rank"));
                        ContentTag bat = new ContentTag(resultSet.getLong("tag_id"), content, removedTag, resultSet.getString("comment"), resultSet.getLong("begin_byte_offset"), resultSet.getLong("end_byte_offset"), resultSet.getString("login_name"));
                        removedTagIds.add(Long.toString(bat.getId()));
                        removedTags.add(bat);
                    }
                }
                if (!removedTags.isEmpty()) {
                    String removeQuery = String.format("DELETE FROM content_tags WHERE tag_id IN (%s)", String.join((CharSequence)",", removedTagIds));
                    stmt = connection.createStatement();
                    try {
                        stmt.executeUpdate(removeQuery);
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
            }
            String queryTemplate = "INSERT INTO content_tags (obj_id, tag_name_id, comment, begin_byte_offset, end_byte_offset, examiner_id) VALUES (%d, %d, '%s', %d, %d, %d)";
            ContentTag contentTag = null;
            stmt = connection.createStatement();
            try {
                String query = String.format(queryTemplate, content.getId(), tagName.getId(), comment, beginByteOffset, endByteOffset, currentExaminer.getId());
                if (this.skCase.getDatabaseType() == TskData.DbType.POSTGRESQL) {
                    stmt.executeUpdate(query, 1);
                } else {
                    stmt.executeUpdate(query);
                }
                try (ResultSet resultSet = stmt.getGeneratedKeys();){
                    resultSet.next();
                    contentTag = new ContentTag(resultSet.getLong(1), content, tagName, comment, beginByteOffset, endByteOffset, currentExaminer.getLoginName());
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
            Long dataSourceId = content.getDataSource() != null ? Long.valueOf(content.getDataSource().getId()) : null;
            this.skCase.getScoringManager().updateAggregateScoreAfterAddition(content.getId(), dataSourceId, TaggingManager.getTagScore(tagName.getTagType()), trans);
            trans.commit();
            return new ContentTagChange(contentTag, removedTags);
        }
        catch (SQLException ex) {
            trans.rollback();
            throw new TskCoreException("Error adding row to content_tags table (obj_id = " + content.getId() + ", tag_name_id = " + tagName.getId() + ")", ex);
        }
    }

    @Deprecated
    public TagName addOrUpdateTagName(String displayName, String description, TagName.HTML_COLOR color, TskData.FileKnown knownStatus) throws TskCoreException {
        return this.addOrUpdateTagName(displayName, description, color, TskData.TagType.convertFileKnownToTagType(knownStatus));
    }

    /*
     * Exception decompiling
     */
    public TagName addOrUpdateTagName(String displayName, String description, TagName.HTML_COLOR color, TskData.TagType tagType) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TagName getTagName(long id) throws TskCoreException {
        String preparedQuery = "SELECT * FROM tag_names where tag_name_id = ?";
        this.skCase.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection connection = this.skCase.getConnection();
             PreparedStatement statement = connection.getPreparedStatement(preparedQuery, 2);){
            statement.clearParameters();
            statement.setLong(1, id);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    TagName tagName = new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), resultSet.getLong("tag_set_id"), resultSet.getInt("rank"));
                    return tagName;
                }
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException("", ex);
        }
        finally {
            this.skCase.releaseSingleUserCaseReadLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTagSetInUse(TagSet tagSet) throws TskCoreException {
        this.skCase.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection connection = this.skCase.getConnection();){
            ResultSet resultSet;
            Statement stmt;
            List<TagName> tagNameList = tagSet.getTagNames();
            if (tagNameList == null) return false;
            if (tagNameList.isEmpty()) return false;
            String statement = String.format("SELECT tag_id FROM content_tags WHERE tag_name_id IN (SELECT tag_name_id FROM tag_names WHERE tag_set_id = %d)", tagSet.getId());
            try {
                block40: {
                    boolean bl;
                    block41: {
                        stmt = connection.createStatement();
                        resultSet = stmt.executeQuery(statement);
                        try {
                            if (!resultSet.next()) break block40;
                            bl = true;
                            if (resultSet == null) break block41;
                        }
                        catch (Throwable throwable) {
                            if (resultSet == null) throw throwable;
                            try {
                                resultSet.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (stmt == null) return bl;
                    stmt.close();
                    return bl;
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException ex) {
                throw new TskCoreException(String.format("Failed to determine if TagSet is in use (%s)", tagSet.getId()), ex);
            }
            statement = String.format("SELECT tag_id FROM blackboard_artifact_tags WHERE tag_name_id IN (SELECT tag_name_id FROM tag_names WHERE tag_set_id = %d)", tagSet.getId());
            try {
                block43: {
                    boolean bl;
                    block44: {
                        stmt = connection.createStatement();
                        resultSet = stmt.executeQuery(statement);
                        try {
                            if (!resultSet.next()) break block43;
                            bl = true;
                            if (resultSet == null) break block44;
                        }
                        catch (Throwable throwable) {
                            if (resultSet == null) throw throwable;
                            try {
                                resultSet.close();
                                throw throwable;
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (stmt == null) return bl;
                    stmt.close();
                    return bl;
                }
                if (resultSet == null) return false;
                resultSet.close();
                return false;
            }
            catch (SQLException ex) {
                throw new TskCoreException(String.format("Failed to determine if TagSet is in use (%s)", tagSet.getId()), ex);
            }
        }
        finally {
            this.skCase.releaseSingleUserCaseReadLock();
        }
    }

    private List<TagName> getTagNamesByTagSetID(int tagSetId) throws TskCoreException {
        if (tagSetId <= 0) {
            throw new IllegalArgumentException("Invalid tagSetID passed to getTagNameByTagSetID");
        }
        ArrayList<TagName> tagNameList = new ArrayList<TagName>();
        this.skCase.acquireSingleUserCaseReadLock();
        String query = String.format("SELECT * FROM tag_names WHERE tag_set_id = %d", tagSetId);
        try (SleuthkitCase.CaseDbConnection connection = this.skCase.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet resultSet = stmt.executeQuery(query);){
            while (resultSet.next()) {
                tagNameList.add(new TagName(resultSet.getLong("tag_name_id"), resultSet.getString("display_name"), resultSet.getString("description"), TagName.HTML_COLOR.getColorByName(resultSet.getString("color")), TskData.TagType.valueOf(resultSet.getByte("knownStatus")), tagSetId, resultSet.getInt("rank")));
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error getting tag names for tag set (%d)", tagSetId), ex);
        }
        finally {
            this.skCase.releaseSingleUserCaseReadLock();
        }
        return tagNameList;
    }

    public static class BlackboardArtifactTagChange {
        private final BlackboardArtifactTag addedTag;
        private final List<BlackboardArtifactTag> removedTagList;

        BlackboardArtifactTagChange(BlackboardArtifactTag added, List<BlackboardArtifactTag> removed) {
            this.addedTag = added;
            this.removedTagList = removed;
        }

        public BlackboardArtifactTag getAddedTag() {
            return this.addedTag;
        }

        public List<BlackboardArtifactTag> getRemovedTags() {
            return Collections.unmodifiableList(this.removedTagList);
        }
    }

    public static class ContentTagChange {
        private final ContentTag addedTag;
        private final List<ContentTag> removedTagList;

        ContentTagChange(ContentTag added, List<ContentTag> removed) {
            this.addedTag = added;
            this.removedTagList = removed;
        }

        public ContentTag getAddedTag() {
            return this.addedTag;
        }

        public List<ContentTag> getRemovedTags() {
            return Collections.unmodifiableList(this.removedTagList);
        }
    }
}

