/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;
import org.sleuthkit.datamodel.TskData;

public class TagName
implements Comparable<TagName>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long id;
    private final String displayName;
    private final String description;
    private final HTML_COLOR color;
    private final TskData.TagType tagType;
    private final long tagSetId;
    private final int rank;

    TagName(long id, String displayName, String description, HTML_COLOR color, TskData.TagType tagType, long tagSetId, int rank) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.color = color;
        this.tagType = tagType;
        this.tagSetId = tagSetId;
        this.rank = rank;
    }

    public long getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public HTML_COLOR getColor() {
        return this.color;
    }

    public TskData.TagType getTagType() {
        return this.tagType;
    }

    @Deprecated
    public TskData.FileKnown getKnownStatus() {
        return TskData.TagType.convertTagTypeToFileKnown(this.tagType);
    }

    long getTagSetId() {
        return this.tagSetId;
    }

    public int getRank() {
        return this.rank;
    }

    @Override
    public int compareTo(TagName other) {
        return this.getDisplayName().compareTo(other.getDisplayName());
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (int)(this.id ^ this.id >>> 32);
        hash = 89 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
        hash = 89 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 89 * hash + (this.color != null ? this.color.hashCode() : 0);
        hash = 89 * hash + (this.tagType != null ? this.tagType.hashCode() : 0);
        hash = 89 * hash + (int)(this.id ^ this.tagSetId >>> 32);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TagName other = (TagName)obj;
        return this.id == other.getId() && Objects.equals(this.displayName, other.getDisplayName()) && Objects.equals(this.description, other.getDescription()) && Objects.equals((Object)this.color, (Object)other.getColor()) && Objects.equals((Object)this.tagType, (Object)other.getTagType()) && this.tagSetId == other.getTagSetId();
    }

    public static enum HTML_COLOR {
        NONE("None", ""),
        WHITE("White", "#FFFFFF"),
        SILVER("Silver", "#C0C0C0"),
        GRAY("Gray", "#808080"),
        BLACK("Black", "#000000"),
        RED("Red", "#FF0000"),
        MAROON("Maron", "#800000"),
        YELLOW("Yellow", "#FFFF00"),
        OLIVE("Olive", "#808000"),
        LIME("Lime", "#00FF00"),
        GREEN("Green", "#008000"),
        AQUA("Aqua", "#00FFFF"),
        TEAL("Teal", "#008080"),
        BLUE("Blue", "#0000FF"),
        NAVY("Navy", "#000080"),
        FUCHSIA("Fuchsia", "#FF00FF"),
        PURPLE("Purple", "#800080");

        private static final HashMap<String, HTML_COLOR> colorMap;
        private final String name;
        private final String hexString;

        private HTML_COLOR(String name, String hexString) {
            this.hexString = hexString;
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        public String getRgbValue() {
            return this.hexString;
        }

        public static HTML_COLOR getColorByName(String colorName) {
            if (colorMap.containsKey(colorName)) {
                return colorMap.get(colorName);
            }
            return NONE;
        }

        static {
            colorMap = new HashMap();
            for (HTML_COLOR color : HTML_COLOR.values()) {
                colorMap.put(color.getName(), color);
            }
        }
    }
}

