/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.sleuthkit.datamodel.AnalysisResult;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.Score;
import org.sleuthkit.datamodel.ScoreChange;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TaggingManager;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;

public class ScoringManager {
    private static final Logger LOGGER = Logger.getLogger(ScoringManager.class.getName());
    private final SleuthkitCase db;

    ScoringManager(SleuthkitCase skCase) {
        this.db = skCase;
    }

    public Score getAggregateScore(long objId) throws TskCoreException {
        this.db.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
            try {
                Score score = this.getAggregateScore(objId, false, connection).orElse(Score.SCORE_UNKNOWN);
                if (connection != null) {
                    connection.close();
                }
                return score;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Score> getAggregateScores(List<Long> objIds) throws TskCoreException {
        if (objIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<Long> set = new HashSet<Long>(objIds);
        String queryString = "SELECT obj_id, significance, priority FROM tsk_aggregate_score WHERE obj_id in " + set.stream().map(l -> l.toString()).collect(Collectors.joining(",", "(", ")"));
        Map<Long, Score> results = set.stream().collect(Collectors.toMap(key -> key, key -> Score.SCORE_UNKNOWN));
        this.db.acquireSingleUserCaseReadLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            try (Statement s = connection.createStatement();
                 ResultSet rs = connection.executeQuery(s, queryString);){
                while (rs.next()) {
                    Long objId = rs.getLong("obj_id");
                    Score score = new Score(Score.Significance.fromID(rs.getInt("significance")), Score.Priority.fromID(rs.getInt("priority")));
                    results.put(objId, score);
                }
            }
            catch (SQLException ex) {
                throw new TskCoreException("SQLException thrown while running query: " + queryString, ex);
            }
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
        return results;
    }

    private Optional<Score> getAggregateScore(long objId, boolean forUpdate, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        return this.getAggregateScore(objId, forUpdate, connection);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<Score> getAggregateScore(long objId, boolean forUpdate, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String queryString = "SELECT significance, priority FROM tsk_aggregate_score WHERE obj_id = " + objId + (forUpdate ? " FOR UPDATE " : "");
        try (Statement s = connection.createStatement();){
            Optional<Score> optional;
            block18: {
                ResultSet rs;
                block16: {
                    Optional<Score> optional2;
                    block17: {
                        rs = connection.executeQuery(s, queryString);
                        try {
                            if (!rs.next()) break block16;
                            optional2 = Optional.of(new Score(Score.Significance.fromID(rs.getInt("significance")), Score.Priority.fromID(rs.getInt("priority"))));
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (rs == null) break block18;
                rs.close();
            }
            return optional;
        }
        catch (SQLException ex) {
            throw new TskCoreException("SQLException thrown while running query: " + queryString, ex);
        }
    }

    private void setAggregateScore(long objId, Long dataSourceObjectId, Score score, boolean updateOnly, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        if (updateOnly) {
            String updateSQLString = " UPDATE tsk_aggregate_score SET significance = ?, priority = ? where obj_id = ?";
            SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
            try {
                PreparedStatement preparedStatement = connection.getPreparedStatement(updateSQLString, 2);
                preparedStatement.clearParameters();
                preparedStatement.setInt(1, score.getSignificance().getId());
                preparedStatement.setInt(2, score.getPriority().getId());
                preparedStatement.setLong(3, objId);
                connection.executeUpdate(preparedStatement);
            }
            catch (SQLException ex) {
                throw new TskCoreException(String.format("Error updating aggregate score, query: %s for objId = %d", updateSQLString, objId), ex);
            }
        }
        String insertSQLString = "INSERT INTO tsk_aggregate_score (obj_id, data_source_obj_id, significance , priority) VALUES (?, ?, ?, ?) ON CONFLICT (obj_id) DO UPDATE SET significance = ?, priority = ?";
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        try {
            PreparedStatement preparedStatement = connection.getPreparedStatement(insertSQLString, 2);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, objId);
            if (dataSourceObjectId != null) {
                preparedStatement.setLong(2, dataSourceObjectId);
            } else {
                preparedStatement.setNull(2, 0);
            }
            preparedStatement.setInt(3, score.getSignificance().getId());
            preparedStatement.setInt(4, score.getPriority().getId());
            preparedStatement.setInt(5, score.getSignificance().getId());
            preparedStatement.setInt(6, score.getPriority().getId());
            connection.executeUpdate(preparedStatement);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating aggregate score, query: %s for objId = %d", insertSQLString, objId), ex);
        }
    }

    Score updateAggregateScoreAfterAddition(long objId, Long dataSourceObjectId, Score newResultScore, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        Optional<Score> oCurrentAggregateScore = this.getAggregateScore(objId, this.db.getDatabaseType().equals((Object)TskData.DbType.POSTGRESQL), transaction);
        Score currentAggregateScore = oCurrentAggregateScore.orElse(Score.SCORE_UNKNOWN);
        if (currentAggregateScore.compareTo(Score.SCORE_UNKNOWN) == 0 && newResultScore.compareTo(Score.SCORE_UNKNOWN) != 0 || Score.getScoreComparator().compare(newResultScore, currentAggregateScore) > 0) {
            this.setAggregateScore(objId, dataSourceObjectId, newResultScore, oCurrentAggregateScore.isPresent(), transaction);
            transaction.registerScoreChange(new ScoreChange(objId, dataSourceObjectId, currentAggregateScore, newResultScore));
            return newResultScore;
        }
        return currentAggregateScore;
    }

    Score updateAggregateScoreAfterDeletion(long objId, Long dataSourceObjectId, SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        Optional<Score> oCurrentAggregateScore = this.getAggregateScore(objId, this.db.getDatabaseType().equals((Object)TskData.DbType.POSTGRESQL), transaction);
        Score currentScore = oCurrentAggregateScore.orElse(Score.SCORE_UNKNOWN);
        List<AnalysisResult> analysisResults = this.db.getBlackboard().getAnalysisResults(objId, connection);
        Score newScore = Score.SCORE_UNKNOWN;
        for (AnalysisResult iter : analysisResults) {
            if (iter.ignoreResult()) continue;
            Score iterScore = iter.getScore();
            if (Score.getScoreComparator().compare(iterScore, newScore) <= 0) continue;
            newScore = iterScore;
        }
        Optional<Score> tagScore = this.db.getTaggingManager().getMaxTagType(objId, transaction).map(knownStatus -> TaggingManager.getTagScore(knownStatus));
        if (tagScore.isPresent() && Score.getScoreComparator().compare(tagScore.get(), newScore) > 0) {
            newScore = tagScore.get();
        }
        if (newScore.compareTo(currentScore) != 0) {
            this.setAggregateScore(objId, dataSourceObjectId, newScore, oCurrentAggregateScore.isPresent(), transaction);
            transaction.registerScoreChange(new ScoreChange(objId, dataSourceObjectId, currentScore, newScore));
        }
        return newScore;
    }

    public long getContentCount(long dataSourceObjectId, Score.Significance significance) throws TskCoreException {
        this.db.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
            try {
                long l = this.getContentCount(dataSourceObjectId, significance, connection);
                if (connection != null) {
                    connection.close();
                }
                return l;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private long getContentCount(long dataSourceObjectId, Score.Significance significance, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String queryString = "SELECT COUNT(obj_id) AS count FROM tsk_aggregate_score WHERE data_source_obj_id = " + dataSourceObjectId + " AND significance = " + significance.getId();
        try (Statement statement = connection.createStatement();){
            long l;
            block15: {
                ResultSet resultSet = connection.executeQuery(statement, queryString);
                try {
                    long count = 0L;
                    if (resultSet.next()) {
                        count = resultSet.getLong("count");
                    }
                    l = count;
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return l;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error getting count of items with significance = " + significance.toString(), ex);
        }
    }

    public List<Content> getContent(long dataSourceObjectId, Score.Significance significance) throws TskCoreException {
        this.db.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
            try {
                List<Content> list = this.getContent(dataSourceObjectId, significance, connection);
                if (connection != null) {
                    connection.close();
                }
                return list;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Content> getContent(long dataSourceObjectId, Score.Significance significance, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String queryString = "SELECT obj_id FROM tsk_aggregate_score WHERE data_source_obj_id = " + dataSourceObjectId + " AND significance = " + significance.getId();
        try (Statement statement = connection.createStatement();){
            ArrayList<Content> arrayList;
            block15: {
                ResultSet resultSet = connection.executeQuery(statement, queryString);
                try {
                    ArrayList<Content> items = new ArrayList<Content>();
                    while (resultSet.next()) {
                        long objId = resultSet.getLong("obj_id");
                        items.add(this.db.getContentById(objId));
                    }
                    arrayList = items;
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return arrayList;
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error getting list of items with significance = " + significance.toString(), ex);
        }
    }
}

