/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

interface SQLHelper {
    public String getPrimaryKey();

    public String getBigIntType();

    public String getBlobType();

    public String getVSDescColName();

    public static class SQLiteHelper
    implements SQLHelper {
        @Override
        public String getPrimaryKey() {
            return "INTEGER";
        }

        @Override
        public String getBigIntType() {
            return "INTEGER";
        }

        @Override
        public String getBlobType() {
            return "BLOB";
        }

        @Override
        public String getVSDescColName() {
            return "desc";
        }
    }

    public static class PostgreSQLHelper
    implements SQLHelper {
        @Override
        public String getPrimaryKey() {
            return "BIGSERIAL";
        }

        @Override
        public String getBigIntType() {
            return "BIGINT";
        }

        @Override
        public String getBlobType() {
            return "BYTEA";
        }

        @Override
        public String getVSDescColName() {
            return "descr";
        }
    }
}

