/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.AnalysisResult;
import org.sleuthkit.datamodel.AnalysisResultAdded;
import org.sleuthkit.datamodel.Blackboard;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.DataArtifact;
import org.sleuthkit.datamodel.Score;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.TskCoreException;

public class Report
implements Content {
    private static final BlackboardArtifact.Type KEYWORD_HIT_TYPE = new BlackboardArtifact.Type(BlackboardArtifact.ARTIFACT_TYPE.TSK_KEYWORD_HIT);
    static long ID_NOT_SET = -1L;
    private long objectId = ID_NOT_SET;
    private final String pathAsString;
    private final Path pathAsPath;
    private final long createdTime;
    private final String sourceModuleName;
    private final String reportName;
    private Content parent;
    private final SleuthkitCase db;
    private FileChannel fileChannel = null;
    private static final Logger LOGGER = Logger.getLogger(Report.class.getName());

    Report(SleuthkitCase db, long id, String path, long createdTime, String sourceModuleName, String reportName, Content parent) {
        this.db = db;
        this.objectId = id;
        this.pathAsString = path;
        this.pathAsPath = path.startsWith("http") ? null : Paths.get(path, new String[0]);
        this.createdTime = createdTime;
        this.sourceModuleName = sourceModuleName;
        this.reportName = reportName;
        this.parent = parent;
    }

    @Override
    public long getId() {
        return this.objectId;
    }

    public String getPath() {
        return this.pathAsPath != null ? this.pathAsPath.toString() : this.pathAsString;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public String getSourceModuleName() {
        return this.sourceModuleName;
    }

    public String getReportName() {
        return this.reportName;
    }

    @Override
    public int read(byte[] buf, long offset, long len) throws TskCoreException {
        if (this.pathAsPath == null || Files.isDirectory(this.pathAsPath, new LinkOption[0])) {
            return 0;
        }
        int totalBytesRead = 0;
        ByteBuffer data = ByteBuffer.wrap(buf);
        try {
            if (this.fileChannel == null) {
                this.fileChannel = FileChannel.open(this.pathAsPath, StandardOpenOption.READ);
            }
            this.fileChannel.position(offset);
            int bytesRead = 0;
            do {
                if ((bytesRead = this.fileChannel.read(data)) == -1) continue;
                totalBytesRead += bytesRead;
            } while (bytesRead != -1 && data.hasRemaining());
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to read report file.", ex);
        }
        return totalBytesRead;
    }

    @Override
    public void close() {
        try {
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Failed to close report file.", ex);
        }
    }

    @Override
    public long getSize() {
        try {
            return this.pathAsPath != null ? Files.size(this.pathAsPath) : 0L;
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Failed to get size of report.", ex);
            return 0L;
        }
    }

    @Override
    public <T> T accept(ContentVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public String getName() {
        return this.reportName;
    }

    @Override
    public String getUniquePath() throws TskCoreException {
        return this.getPath();
    }

    @Override
    public Content getDataSource() throws TskCoreException {
        if (null == this.parent) {
            return null;
        }
        return this.parent.getDataSource();
    }

    @Override
    public List<Content> getChildren() throws TskCoreException {
        return Collections.emptyList();
    }

    @Override
    public boolean hasChildren() throws TskCoreException {
        return false;
    }

    @Override
    public int getChildrenCount() throws TskCoreException {
        return 0;
    }

    @Override
    public Content getParent() throws TskCoreException {
        if (this.parent == null) {
            SleuthkitCase.ObjectInfo parentInfo = this.db.getParentInfo(this);
            this.parent = parentInfo == null ? null : this.db.getContentById(parentInfo.getId());
        }
        return this.parent;
    }

    @Override
    public List<Long> getChildrenIds() throws TskCoreException {
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public BlackboardArtifact newArtifact(int artifactTypeID) throws TskCoreException {
        if (artifactTypeID != BlackboardArtifact.ARTIFACT_TYPE.TSK_KEYWORD_HIT.getTypeID()) {
            throw new TskCoreException("Reports can only have keyword hit artifacts.");
        }
        long fileObjId = this.getId();
        long dsObjId = this.getDataSource() == null ? null : Long.valueOf(this.getDataSource().getId());
        try {
            return this.db.getBlackboard().newAnalysisResult(KEYWORD_HIT_TYPE, fileObjId, dsObjId, Score.SCORE_UNKNOWN, null, null, null, Collections.emptyList()).getAnalysisResult();
        }
        catch (Blackboard.BlackboardException ex) {
            throw new TskCoreException("Unable to get analysis result for keword hit.", ex);
        }
    }

    @Override
    public AnalysisResultAdded newAnalysisResult(BlackboardArtifact.Type artifactType, Score score, String conclusion, String configuration, String justification, Collection<BlackboardAttribute> attributesList) throws TskCoreException {
        long dataSourceObjId = this.getDataSource().getId();
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            AnalysisResultAdded resultAdded = this.db.getBlackboard().newAnalysisResult(artifactType, this.objectId, dataSourceObjId, score, conclusion, configuration, justification, attributesList, trans);
            trans.commit();
            return resultAdded;
        }
        catch (Blackboard.BlackboardException ex) {
            trans.rollback();
            throw new TskCoreException("Error adding analysis result.", ex);
        }
    }

    @Override
    public AnalysisResultAdded newAnalysisResult(BlackboardArtifact.Type artifactType, Score score, String conclusion, String configuration, String justification, Collection<BlackboardAttribute> attributesList, long dataSourceId) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            AnalysisResultAdded resultAdded = this.db.getBlackboard().newAnalysisResult(artifactType, this.objectId, dataSourceId, score, conclusion, configuration, justification, attributesList, trans);
            trans.commit();
            return resultAdded;
        }
        catch (Blackboard.BlackboardException ex) {
            trans.rollback();
            throw new TskCoreException("Error adding analysis result.", ex);
        }
    }

    @Override
    public DataArtifact newDataArtifact(BlackboardArtifact.Type artifactType, Collection<BlackboardAttribute> attributesList, Long osAccountId) throws TskCoreException {
        if (artifactType.getTypeID() != BlackboardArtifact.ARTIFACT_TYPE.TSK_KEYWORD_HIT.getTypeID() && artifactType.getTypeID() != BlackboardArtifact.ARTIFACT_TYPE.TSK_ACCOUNT.getTypeID()) {
            throw new TskCoreException("Reports can only have keyword hit artifacts.");
        }
        return this.db.getBlackboard().newDataArtifact(artifactType, this.objectId, this.getDataSource().getId(), attributesList, osAccountId);
    }

    @Override
    public DataArtifact newDataArtifact(BlackboardArtifact.Type artifactType, Collection<BlackboardAttribute> attributesList, Long osAccountId, long dataSourceId) throws TskCoreException {
        if (artifactType.getTypeID() != BlackboardArtifact.ARTIFACT_TYPE.TSK_KEYWORD_HIT.getTypeID() && artifactType.getTypeID() != BlackboardArtifact.ARTIFACT_TYPE.TSK_ACCOUNT.getTypeID()) {
            throw new TskCoreException("Reports can only have keyword hit artifacts.");
        }
        return this.db.getBlackboard().newDataArtifact(artifactType, this.objectId, dataSourceId, attributesList, osAccountId);
    }

    @Override
    public DataArtifact newDataArtifact(BlackboardArtifact.Type artifactType, Collection<BlackboardAttribute> attributesList) throws TskCoreException {
        return this.newDataArtifact(artifactType, attributesList, null);
    }

    @Override
    @Deprecated
    public BlackboardArtifact newArtifact(BlackboardArtifact.ARTIFACT_TYPE type) throws TskCoreException {
        return this.newArtifact(type.getTypeID());
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(String artifactTypeName) throws TskCoreException {
        return this.getArtifacts(this.db.getBlackboard().getArtifactType(artifactTypeName).getTypeID());
    }

    @Override
    public BlackboardArtifact getGenInfoArtifact() throws TskCoreException {
        return null;
    }

    @Override
    public BlackboardArtifact getGenInfoArtifact(boolean create) throws TskCoreException {
        return null;
    }

    @Override
    public ArrayList<BlackboardAttribute> getGenInfoAttributes(BlackboardAttribute.ATTRIBUTE_TYPE attr_type) throws TskCoreException {
        return null;
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(int artifactTypeID) throws TskCoreException {
        if (artifactTypeID != BlackboardArtifact.ARTIFACT_TYPE.TSK_KEYWORD_HIT.getTypeID()) {
            throw new TskCoreException("Reports can only have keyword hit artifacts.");
        }
        return this.db.getBlackboardArtifacts(artifactTypeID, this.objectId);
    }

    @Override
    public ArrayList<BlackboardArtifact> getArtifacts(BlackboardArtifact.ARTIFACT_TYPE type) throws TskCoreException {
        return this.getArtifacts(type.getTypeID());
    }

    @Override
    public ArrayList<BlackboardArtifact> getAllArtifacts() throws TskCoreException {
        return this.db.getMatchingArtifacts("WHERE obj_id = " + this.objectId);
    }

    @Override
    public List<AnalysisResult> getAllAnalysisResults() throws TskCoreException {
        return this.db.getBlackboard().getAnalysisResults(this.objectId);
    }

    @Override
    public List<DataArtifact> getAllDataArtifacts() throws TskCoreException {
        return this.db.getBlackboard().getDataArtifactsBySource(this.objectId);
    }

    @Override
    public List<AnalysisResult> getAnalysisResults(BlackboardArtifact.Type artifactType) throws TskCoreException {
        return this.db.getBlackboard().getAnalysisResults(this.objectId, artifactType.getTypeID());
    }

    @Override
    public Score getAggregateScore() throws TskCoreException {
        return this.db.getScoringManager().getAggregateScore(this.objectId);
    }

    @Override
    public Set<String> getHashSetNames() throws TskCoreException {
        return Collections.emptySet();
    }

    @Override
    public long getArtifactsCount(String artifactTypeName) throws TskCoreException {
        return this.getArtifactsCount(this.db.getBlackboard().getArtifactType(artifactTypeName).getTypeID());
    }

    @Override
    public long getArtifactsCount(int artifactTypeID) throws TskCoreException {
        if (artifactTypeID != BlackboardArtifact.ARTIFACT_TYPE.TSK_KEYWORD_HIT.getTypeID()) {
            throw new TskCoreException("Reports can only have keyword hit artifacts.");
        }
        return this.db.getBlackboardArtifactsCount(artifactTypeID, this.objectId);
    }

    @Override
    public long getArtifactsCount(BlackboardArtifact.ARTIFACT_TYPE type) throws TskCoreException {
        return this.getArtifactsCount(type.getTypeID());
    }

    @Override
    public long getAllArtifactsCount() throws TskCoreException {
        return this.db.getBlackboardArtifactsCount(this.objectId);
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> v) {
        return v.visit(this);
    }
}

