/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.base.Strings;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sleuthkit.datamodel.Host;
import org.sleuthkit.datamodel.Person;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskEvent;

public final class PersonManager {
    private final SleuthkitCase db;

    PersonManager(SleuthkitCase skCase) {
        this.db = skCase;
    }

    /*
     * Exception decompiling
     */
    public List<Person> getPersons() throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Person updatePerson(Person person) throws TskCoreException {
        if (Strings.isNullOrEmpty((String)person.getName())) {
            throw new TskCoreException("Illegal argument passed to updatePerson: Name field for person with ID " + person.getPersonId() + " is null/empty. Will not update database.");
        }
        String queryString = "UPDATE tsk_persons SET name = ? WHERE id = " + person.getPersonId();
        this.db.acquireSingleUserCaseWriteLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            PreparedStatement s = connection.getPreparedStatement(queryString, 2);
            s.clearParameters();
            s.setString(1, person.getName());
            s.executeUpdate();
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating person with id = %d", person.getPersonId()), ex);
        }
        finally {
            this.db.releaseSingleUserCaseWriteLock();
        }
        this.db.fireTSKEvent(new TskEvent.PersonsUpdatedTskEvent(Collections.singletonList(person)));
        return person;
    }

    public void deletePerson(String name) throws TskCoreException {
        String queryString = "DELETE FROM tsk_persons WHERE LOWER(name) = LOWER(?)";
        Person deletedPerson = null;
        this.db.acquireSingleUserCaseWriteLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            PreparedStatement s = connection.getPreparedStatement(queryString, 1);
            s.clearParameters();
            s.setString(1, name);
            s.executeUpdate();
            try (ResultSet resultSet = s.getGeneratedKeys();){
                if (resultSet.next()) {
                    deletedPerson = new Person(resultSet.getLong(1), name);
                }
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error deleting person with name %s", name), ex);
        }
        finally {
            this.db.releaseSingleUserCaseWriteLock();
        }
        if (deletedPerson != null) {
            this.db.fireTSKEvent(new TskEvent.PersonsDeletedTskEvent(Collections.singletonList(deletedPerson.getPersonId())));
        }
    }

    public Optional<Person> getPerson(String name) throws TskCoreException {
        this.db.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
            try {
                Optional<Person> optional = this.getPerson(name, connection);
                if (connection != null) {
                    connection.close();
                }
                return optional;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
    }

    /*
     * Exception decompiling
     */
    public Optional<Person> getPerson(long id) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Person newPerson(String name) throws TskCoreException {
        Person toReturn;
        block18: {
            if (Strings.isNullOrEmpty((String)name)) {
                throw new TskCoreException("Illegal argument passed to createPerson: Non-empty name is required.");
            }
            toReturn = null;
            SleuthkitCase.CaseDbConnection connection = null;
            this.db.acquireSingleUserCaseWriteLock();
            try {
                connection = this.db.getConnection();
                Optional<Person> person = this.getPerson(name, connection);
                if (person.isPresent()) {
                    Person person2 = person.get();
                    return person2;
                }
                String personInsertSQL = "INSERT INTO tsk_persons(name) VALUES (?)";
                PreparedStatement preparedStatement = connection.getPreparedStatement(personInsertSQL, 1);
                preparedStatement.clearParameters();
                preparedStatement.setString(1, name);
                connection.executeUpdate(preparedStatement);
                try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                    if (resultSet.next()) {
                        toReturn = new Person(resultSet.getLong(1), name);
                        break block18;
                    }
                    throw new SQLException("Error executing SQL: " + personInsertSQL);
                }
            }
            catch (SQLException ex) {
                Optional<Person> person;
                if (connection != null && (person = this.getPerson(name, connection)).isPresent()) {
                    Person person3 = person.get();
                    return person3;
                }
                throw new TskCoreException(String.format("Error adding person with name = %s", name), ex);
            }
            finally {
                this.db.releaseSingleUserCaseWriteLock();
            }
        }
        if (toReturn != null) {
            this.db.fireTSKEvent(new TskEvent.PersonsAddedTskEvent(Collections.singletonList(toReturn)));
        }
        return toReturn;
    }

    public List<Host> getHostsForPerson(Person person) throws TskCoreException {
        return this.executeHostsQuery("SELECT * FROM tsk_hosts WHERE person_id = " + person.getPersonId());
    }

    public List<Host> getHostsWithoutPersons() throws TskCoreException {
        return this.executeHostsQuery("SELECT * FROM tsk_hosts WHERE person_id IS NULL");
    }

    /*
     * Exception decompiling
     */
    private List<Host> executeHostsQuery(String hostsQuery) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Person> getPerson(String name, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String queryString = "SELECT * FROM tsk_persons WHERE LOWER(name) = LOWER(?)";
        try {
            PreparedStatement s = connection.getPreparedStatement(queryString, 1);
            s.clearParameters();
            s.setString(1, name);
            try (ResultSet rs = s.executeQuery();){
                if (!rs.next()) {
                    Optional<Person> optional2 = Optional.empty();
                    return optional2;
                }
                Optional<Person> optional = Optional.of(new Person(rs.getLong("id"), rs.getString("name")));
                return optional;
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error getting person with name = %s", name), ex);
        }
    }

    /*
     * Exception decompiling
     */
    public Optional<Person> getPerson(Host host) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addHostsToPerson(Person person, List<Host> hosts) throws TskCoreException {
        if (person == null) {
            throw new TskCoreException("Illegal argument: person must be non-null");
        }
        if (hosts == null || hosts.isEmpty()) {
            throw new TskCoreException("Illegal argument: hosts must be non-null and non-empty");
        }
        this.executeHostsUpdate(person, this.getHostIds(hosts), new TskEvent.HostsAddedToPersonTskEvent(person, hosts));
    }

    public void removeHostsFromPerson(Person person, List<Host> hosts) throws TskCoreException {
        if (person == null) {
            throw new TskCoreException("Illegal argument: person must be non-null");
        }
        if (hosts == null || hosts.isEmpty()) {
            throw new TskCoreException("Illegal argument: hosts must be non-null and non-empty");
        }
        List<Long> hostIds = this.getHostIds(hosts);
        this.executeHostsUpdate(null, hostIds, new TskEvent.HostsRemovedFromPersonTskEvent(person, hostIds));
    }

    private void executeHostsUpdate(Person person, List<Long> hostIds, TskEvent event) throws TskCoreException {
        Object updateSql = null;
        this.db.acquireSingleUserCaseWriteLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
             Statement statement = connection.createStatement();){
            updateSql = person == null ? String.format("UPDATE tsk_hosts SET person_id = NULL", new Object[0]) : String.format("UPDATE tsk_hosts SET person_id = %d", person.getPersonId());
            String hostIdsCsvList = hostIds.stream().map(hostId -> hostId.toString()).collect(Collectors.joining(","));
            updateSql = (String)updateSql + " WHERE id IN (" + hostIdsCsvList + ")";
            statement.executeUpdate((String)updateSql);
            this.db.fireTSKEvent(event);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format((String)(updateSql == null ? "Error connecting to case database" : "Error executing '" + updateSql + "'"), new Object[0]), ex);
        }
        finally {
            this.db.releaseSingleUserCaseWriteLock();
        }
    }

    private List<Long> getHostIds(List<Host> hosts) {
        ArrayList<Long> hostIds = new ArrayList<Long>();
        hostIds.addAll(hosts.stream().map(host -> host.getHostId()).collect(Collectors.toList()));
        return hostIds;
    }
}

