/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import org.sleuthkit.datamodel.AbstractAttribute;
import org.sleuthkit.datamodel.AbstractContent;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.Host;
import org.sleuthkit.datamodel.OsAccountInstance;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.TskCoreException;

public final class OsAccount
extends AbstractContent {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    static final Long NO_ACCOUNT = null;
    static final String NO_OWNER_ID = null;
    private final SleuthkitCase sleuthkitCase;
    private final long osAccountObjId;
    private final long realmId;
    private final String loginName;
    private final String addr;
    private final String signature;
    private final String fullName;
    private final OsAccountType osAccountType;
    private final OsAccountStatus osAccountStatus;
    private final OsAccountDbStatus osAccountDbStatus;
    private final Long creationTime;
    private List<OsAccountAttribute> osAccountAttributes = null;

    OsAccount(SleuthkitCase sleuthkitCase, long osAccountobjId, long realmId, String loginName, String uniqueId, String signature, String fullName, Long creationTime, OsAccountType accountType, OsAccountStatus accountStatus, OsAccountDbStatus accountDbStatus) {
        super(sleuthkitCase, osAccountobjId, signature);
        this.sleuthkitCase = sleuthkitCase;
        this.osAccountObjId = osAccountobjId;
        this.realmId = realmId;
        this.loginName = loginName;
        this.addr = uniqueId;
        this.signature = signature;
        this.fullName = fullName;
        this.creationTime = creationTime;
        this.osAccountType = accountType;
        this.osAccountStatus = accountStatus;
        this.osAccountDbStatus = accountDbStatus;
    }

    synchronized void setAttributesInternal(List<OsAccountAttribute> osAccountAttributes) {
        this.osAccountAttributes = osAccountAttributes;
    }

    @Override
    public long getId() {
        return this.osAccountObjId;
    }

    public Optional<String> getAddr() {
        return Optional.ofNullable(this.addr);
    }

    public long getRealmId() {
        return this.realmId;
    }

    public Optional<String> getLoginName() {
        return Optional.ofNullable(this.loginName);
    }

    String getSignature() {
        return this.signature;
    }

    public Optional<String> getFullName() {
        return Optional.ofNullable(this.fullName);
    }

    public Optional<Long> getCreationTime() {
        return Optional.ofNullable(this.creationTime);
    }

    public Optional<OsAccountType> getOsAccountType() {
        return Optional.ofNullable(this.osAccountType);
    }

    public Optional<OsAccountStatus> getOsAccountStatus() {
        return Optional.ofNullable(this.osAccountStatus);
    }

    public OsAccountDbStatus getOsAccountDbStatus() {
        return this.osAccountDbStatus;
    }

    public synchronized List<OsAccountAttribute> getExtendedOsAccountAttributes() throws TskCoreException {
        if (this.osAccountAttributes == null) {
            this.osAccountAttributes = this.sleuthkitCase.getOsAccountManager().getOsAccountAttributes(this);
        }
        return Collections.unmodifiableList(this.osAccountAttributes);
    }

    public synchronized List<OsAccountInstance> getOsAccountInstances() throws TskCoreException {
        return this.sleuthkitCase.getOsAccountManager().getOsAccountInstances(this);
    }

    @Override
    public SleuthkitCase getSleuthkitCase() {
        return this.sleuthkitCase;
    }

    @Override
    public int read(byte[] buf, long offset, long len) throws TskCoreException {
        return 0;
    }

    @Override
    public void close() {
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public <T> T accept(ContentVisitor<T> v) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> v) {
        return v.visit(this);
    }

    public static enum OsAccountType {
        UNKNOWN(0, bundle.getString("OsAccountType.Unknown.text")),
        SERVICE(1, bundle.getString("OsAccountType.Service.text")),
        INTERACTIVE(2, bundle.getString("OsAccountType.Interactive.text"));

        private final int id;
        private final String name;

        private OsAccountType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static OsAccountType fromID(int typeId) {
            for (OsAccountType accountType : OsAccountType.values()) {
                if (accountType.ordinal() != typeId) continue;
                return accountType;
            }
            return null;
        }
    }

    public static enum OsAccountStatus {
        UNKNOWN(0, bundle.getString("OsAccountStatus.Unknown.text")),
        ACTIVE(1, bundle.getString("OsAccountStatus.Active.text")),
        DISABLED(2, bundle.getString("OsAccountStatus.Disabled.text")),
        DELETED(3, bundle.getString("OsAccountStatus.Deleted.text")),
        NON_EXISTENT(4, bundle.getString("OsAccountStatus.NonExistent.text"));

        private final int id;
        private final String name;

        private OsAccountStatus(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public static OsAccountStatus fromID(int statusId) {
            for (OsAccountStatus statusType : OsAccountStatus.values()) {
                if (statusType.ordinal() != statusId) continue;
                return statusType;
            }
            return null;
        }
    }

    static enum OsAccountDbStatus {
        ACTIVE(0, "Active"),
        MERGED(1, "Merged"),
        DELETED(2, "Deleted");

        private final int id;
        private final String name;

        private OsAccountDbStatus(int id, String name) {
            this.id = id;
            this.name = name;
        }

        int getId() {
            return this.id;
        }

        String getName() {
            return this.name;
        }

        static OsAccountDbStatus fromID(int typeId) {
            for (OsAccountDbStatus type : OsAccountDbStatus.values()) {
                if (type.ordinal() != typeId) continue;
                return type;
            }
            return null;
        }
    }

    public final class OsAccountAttribute
    extends AbstractAttribute {
        private final long osAccountObjId;
        private final Long hostId;
        private final Long sourceObjId;

        public OsAccountAttribute(OsAccount this$0, BlackboardAttribute.Type attributeType, int valueInt, OsAccount osAccount, Host host, Content sourceObj) {
            super(attributeType, valueInt);
            this.osAccountObjId = osAccount.getId();
            this.hostId = host != null ? Long.valueOf(host.getHostId()) : null;
            this.sourceObjId = sourceObj != null ? Long.valueOf(sourceObj.getId()) : null;
        }

        public OsAccountAttribute(OsAccount this$0, BlackboardAttribute.Type attributeType, long valueLong, OsAccount osAccount, Host host, Content sourceObj) {
            super(attributeType, valueLong);
            this.osAccountObjId = osAccount.getId();
            this.hostId = host != null ? Long.valueOf(host.getHostId()) : null;
            this.sourceObjId = sourceObj != null ? Long.valueOf(sourceObj.getId()) : null;
        }

        public OsAccountAttribute(OsAccount this$0, BlackboardAttribute.Type attributeType, double valueDouble, OsAccount osAccount, Host host, Content sourceObj) {
            super(attributeType, valueDouble);
            this.osAccountObjId = osAccount.getId();
            this.hostId = host != null ? Long.valueOf(host.getHostId()) : null;
            this.sourceObjId = sourceObj != null ? Long.valueOf(sourceObj.getId()) : null;
        }

        public OsAccountAttribute(OsAccount this$0, BlackboardAttribute.Type attributeType, String valueString, OsAccount osAccount, Host host, Content sourceObj) {
            super(attributeType, valueString);
            this.osAccountObjId = osAccount.getId();
            this.hostId = host != null ? Long.valueOf(host.getHostId()) : null;
            this.sourceObjId = sourceObj != null ? Long.valueOf(sourceObj.getId()) : null;
        }

        public OsAccountAttribute(OsAccount this$0, BlackboardAttribute.Type attributeType, byte[] valueBytes, OsAccount osAccount, Host host, Content sourceObj) {
            super(attributeType, valueBytes);
            this.osAccountObjId = osAccount.getId();
            this.hostId = host != null ? Long.valueOf(host.getHostId()) : null;
            this.sourceObjId = sourceObj != null ? Long.valueOf(sourceObj.getId()) : null;
        }

        OsAccountAttribute(OsAccount this$0, BlackboardAttribute.Type attributeType, int valueInt, long valueLong, double valueDouble, String valueString, byte[] valueBytes, SleuthkitCase sleuthkitCase, OsAccount osAccount, Host host, Content sourceObj) {
            super(attributeType, valueInt, valueLong, valueDouble, valueString, valueBytes, sleuthkitCase);
            this.osAccountObjId = osAccount.getId();
            this.hostId = host != null ? Long.valueOf(host.getHostId()) : null;
            this.sourceObjId = sourceObj != null ? Long.valueOf(sourceObj.getId()) : null;
        }

        public Optional<Long> getHostId() {
            return Optional.ofNullable(this.hostId);
        }

        public long getOsAccountObjectId() {
            return this.osAccountObjId;
        }

        public Optional<Long> getSourceObjectId() {
            return Optional.ofNullable(this.sourceObjId);
        }
    }
}

