/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.sleuthkit.datamodel.ConcurrentDbAccessException;

class LockResources
implements AutoCloseable {
    private static final String LOCK_FILE_PREFIX = ".lock_";
    private File lockFile = null;
    private RandomAccessFile lockFileRaf = null;
    private FileChannel lockFileChannel = null;
    private FileLock lockFileLock = null;

    LockResources(File lockFile, RandomAccessFile lockFileRaf, FileChannel lockFileChannel, FileLock lockFileLock) {
        this.lockFile = lockFile;
        this.lockFileRaf = lockFileRaf;
        this.lockFileChannel = lockFileChannel;
        this.lockFileLock = lockFileLock;
    }

    static LockResources tryAcquireFileLock(String caseDir, String dbName, String applicationName) throws ConcurrentDbAccessException, IOException, OverlappingFileLockException {
        FileLock lockFileLock;
        String lockFileName = LOCK_FILE_PREFIX + (dbName == null ? "tskdb" : dbName);
        File lockFile = new File(caseDir, lockFileName);
        lockFile.getParentFile().mkdirs();
        if (lockFile.isFile() && !lockFile.canWrite()) {
            RandomAccessFile lockFileRaf = new RandomAccessFile(lockFile, "r");
            throw ConcurrentDbAccessException.createForFile(lockFile.getAbsolutePath(), lockFileRaf);
        }
        RandomAccessFile lockFileRaf = new RandomAccessFile(lockFile, "rw");
        FileChannel lockFileChannel = lockFileRaf.getChannel();
        FileLock fileLock = lockFileLock = lockFileChannel == null ? null : lockFileChannel.tryLock(1024L, 1L, false);
        if (lockFileLock != null) {
            lockFileRaf.setLength(0L);
            String limitedAppName = applicationName.length() > 500 ? applicationName.substring(0, 500) : applicationName;
            lockFileRaf.writeChars(limitedAppName);
            return new LockResources(lockFile, lockFileRaf, lockFileChannel, lockFileLock);
        }
        throw ConcurrentDbAccessException.createForFile(lockFile.getAbsolutePath(), lockFileRaf);
    }

    @Override
    public void close() throws Exception {
        if (this.lockFileLock != null) {
            this.lockFileLock.close();
            this.lockFileLock = null;
        }
        if (this.lockFileChannel != null) {
            this.lockFileChannel.close();
            this.lockFileChannel = null;
        }
        if (this.lockFileRaf != null) {
            this.lockFileRaf.close();
            this.lockFileRaf = null;
        }
        if (this.lockFile != null) {
            this.lockFile.delete();
            this.lockFile = null;
        }
    }
}

