/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.DataSource;
import org.sleuthkit.datamodel.Host;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.VirtualDirectory;

public class LocalFilesDataSource
extends VirtualDirectory
implements DataSource {
    private final long objectId;
    private final String deviceId;
    private final String timezone;
    private volatile Host host;
    private static final Logger LOGGER = Logger.getLogger(LocalFilesDataSource.class.getName());

    public LocalFilesDataSource(SleuthkitCase db, long objId, long dataSourceObjectId, String deviceId, String name, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, String timezone, String md5Hash, String sha256Hash, String sha1Hash, TskData.FileKnown knownState, String parentPath) {
        super(db, objId, dataSourceObjectId, null, name, dirType, metaType, dirFlag, metaFlags, md5Hash, sha256Hash, sha1Hash, knownState, parentPath);
        this.objectId = objId;
        this.deviceId = deviceId;
        this.timezone = timezone;
    }

    @Deprecated
    public VirtualDirectory getRootDirectory() {
        return this;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getTimeZone() {
        return this.timezone;
    }

    @Override
    public void setDisplayName(String newName) throws TskCoreException {
        this.getSleuthkitCase().setFileName(newName, this.objectId);
    }

    @Override
    public long getContentSize(SleuthkitCase sleuthkitCase) throws TskCoreException {
        return LocalFilesDataSource.getContentSize(sleuthkitCase, this.objectId);
    }

    static long getContentSize(SleuthkitCase sleuthkitCase, long dataSourceObjId) throws TskCoreException {
        Statement statement = null;
        ResultSet resultSet = null;
        long contentSize = 0L;
        SleuthkitCase.CaseDbConnection connection = sleuthkitCase.getConnection();
        try {
            statement = connection.createStatement();
            resultSet = connection.executeQuery(statement, "SELECT SUM (size) FROM tsk_files WHERE tsk_files.data_source_obj_id = " + dataSourceObjId);
            if (resultSet.next()) {
                contentSize = resultSet.getLong("sum");
            }
        }
        catch (SQLException ex) {
            try {
                throw new TskCoreException(String.format("There was a problem while querying the database for size data for object ID %d.", dataSourceObjId), ex);
            }
            catch (Throwable throwable) {
                LocalFilesDataSource.closeResultSet(resultSet);
                LocalFilesDataSource.closeStatement(statement);
                connection.close();
                throw throwable;
            }
        }
        LocalFilesDataSource.closeResultSet(resultSet);
        LocalFilesDataSource.closeStatement(statement);
        connection.close();
        return contentSize;
    }

    @Override
    public String getUniquePath() throws TskCoreException {
        return "/" + this.getName();
    }

    @Override
    public void setAcquisitionDetails(String details) throws TskCoreException {
        this.getSleuthkitCase().setAcquisitionDetails(this, details);
    }

    @Override
    public void setAcquisitionToolDetails(String name, String version, String settings) throws TskCoreException {
        this.getSleuthkitCase().setAcquisitionToolDetails(this, name, version, settings);
    }

    @Override
    public String getAcquisitionDetails() throws TskCoreException {
        return this.getSleuthkitCase().getAcquisitionDetails(this);
    }

    @Override
    public String getAcquisitionToolSettings() throws TskCoreException {
        return this.getSleuthkitCase().getDataSourceInfoString(this, "acquisition_tool_settings");
    }

    @Override
    public String getAcquisitionToolName() throws TskCoreException {
        return this.getSleuthkitCase().getDataSourceInfoString(this, "acquisition_tool_name");
    }

    @Override
    public String getAcquisitionToolVersion() throws TskCoreException {
        return this.getSleuthkitCase().getDataSourceInfoString(this, "acquisition_tool_version");
    }

    @Override
    public Host getHost() throws TskCoreException {
        if (this.host == null) {
            this.host = this.getSleuthkitCase().getHostManager().getHostByDataSource(this);
        }
        return this.host;
    }

    @Override
    public Long getDateAdded() throws TskCoreException {
        return this.getSleuthkitCase().getDataSourceInfoLong(this, "added_date_time");
    }

    private static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                LOGGER.log(Level.SEVERE, "Error closing ResultSet", ex);
            }
        }
    }

    private static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                LOGGER.log(Level.SEVERE, "Error closing Statement", ex);
            }
        }
    }

    @Override
    public <T> T accept(ContentVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Deprecated
    public LocalFilesDataSource(SleuthkitCase db, long objId, long dataSourceObjectId, String deviceId, String name, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, String timezone, String md5Hash, TskData.FileKnown knownState, String parentPath) {
        this(db, objId, dataSourceObjectId, deviceId, name, dirType, metaType, dirFlag, metaFlags, timezone, md5Hash, null, null, knownState, parentPath);
    }
}

