/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.base.Strings;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.sleuthkit.datamodel.DataSource;
import org.sleuthkit.datamodel.Host;
import org.sleuthkit.datamodel.OsAccountRealm;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskEvent;

public final class HostManager {
    private final SleuthkitCase db;

    HostManager(SleuthkitCase skCase) {
        this.db = skCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host newHost(String name) throws TskCoreException {
        SleuthkitCase.CaseDbTransaction transaction = this.db.beginTransaction();
        try {
            Host host = this.newHost(name, transaction);
            transaction.commit();
            transaction = null;
            Host host2 = host;
            return host2;
        }
        finally {
            if (transaction != null) {
                transaction.rollback();
            }
        }
    }

    Host newHost(String name, SleuthkitCase.CaseDbTransaction trans) throws TskCoreException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new TskCoreException("Illegal argument passed to createHost: Host name is required.");
        }
        SleuthkitCase.CaseDbConnection connection = trans.getConnection();
        Savepoint savepoint = null;
        try {
            Host host;
            block15: {
                savepoint = connection.getConnection().setSavepoint();
                String hostInsertSQL = "INSERT INTO tsk_hosts(name) VALUES (?)";
                PreparedStatement preparedStatement = connection.getPreparedStatement(hostInsertSQL, 1);
                preparedStatement.clearParameters();
                preparedStatement.setString(1, name);
                connection.executeUpdate(preparedStatement);
                host = null;
                try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                    if (resultSet.next()) {
                        host = new Host(resultSet.getLong(1), name);
                        break block15;
                    }
                    throw new SQLException("Error executing  " + hostInsertSQL);
                }
            }
            if (host != null) {
                trans.registerAddedHost(host);
            }
            return host;
        }
        catch (SQLException ex) {
            Optional<Host> optHost;
            if (savepoint != null) {
                try {
                    connection.getConnection().rollback(savepoint);
                }
                catch (SQLException ex2) {
                    throw new TskCoreException(String.format("Error adding host with name = %s and unable to rollback", name), ex);
                }
            }
            if ((optHost = this.getHostByName(name, connection)).isPresent()) {
                return optHost.get();
            }
            throw new TskCoreException(String.format("Error adding host with name = %s", name), ex);
        }
    }

    public Host updateHostName(Host host, String newName) throws TskCoreException {
        if (host == null) {
            throw new TskCoreException("Illegal argument passed to updateHost: No host argument provided.");
        }
        if (newName == null) {
            throw new TskCoreException(String.format("Illegal argument passed to updateHost: Host with id %d has no name", host.getHostId()));
        }
        long hostId = host.getHostId();
        Host updatedHost = null;
        this.db.acquireSingleUserCaseWriteLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            String hostInsertSQL = "UPDATE tsk_hosts SET name =    CASE WHEN db_status = " + Host.HostDbStatus.ACTIVE.getId() + " THEN ? ELSE name END WHERE id = ?";
            PreparedStatement preparedStatement = connection.getPreparedStatement(hostInsertSQL, 1);
            preparedStatement.clearParameters();
            preparedStatement.setString(1, newName);
            preparedStatement.setLong(2, hostId);
            connection.executeUpdate(preparedStatement);
            updatedHost = this.getHostById(hostId, connection).orElseThrow(() -> new TskCoreException(String.format("Error while fetching newly updated host with id: %d, ", new Object[0])));
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating host with name = %s", newName), ex);
        }
        finally {
            this.db.releaseSingleUserCaseWriteLock();
        }
        if (updatedHost != null) {
            this.fireChangeEvent(updatedHost);
        }
        return updatedHost;
    }

    public Long deleteHost(String name) throws TskCoreException {
        if (name == null) {
            throw new TskCoreException("Illegal argument passed to deleteHost: Name provided must be non-null");
        }
        String queryString = "SELECT COUNT(*) AS count FROM\n(SELECT obj_id AS id, host_id FROM data_source_info\nUNION\nSELECT id, scope_host_id AS host_id FROM tsk_os_account_realms\nUNION\nSELECT id, host_id FROM tsk_os_account_attributes\nUNION\nSELECT id, host_id FROM tsk_host_address_map) children\nINNER JOIN tsk_hosts h ON children.host_id = h.id WHERE LOWER(h.name)=LOWER(?)";
        String deleteString = "DELETE FROM tsk_hosts WHERE LOWER(name) = LOWER(?)";
        SleuthkitCase.CaseDbTransaction trans = this.db.beginTransaction();
        try {
            PreparedStatement query = trans.getConnection().getPreparedStatement(queryString, 2);
            query.clearParameters();
            query.setString(1, name);
            try (ResultSet queryResults = query.executeQuery();){
                if (queryResults.next() && queryResults.getLong("count") > 0L) {
                    throw new TskCoreException(String.format("Host with name '%s' has child data and cannot be deleted.", name));
                }
            }
            PreparedStatement update = trans.getConnection().getPreparedStatement(deleteString, 1);
            update.clearParameters();
            update.setString(1, name);
            int numUpdated = update.executeUpdate();
            Long hostId = null;
            if (numUpdated > 0) {
                try (ResultSet updateResult = update.getGeneratedKeys();){
                    if (updateResult.next()) {
                        hostId = updateResult.getLong(1);
                    }
                }
            }
            trans.commit();
            trans = null;
            this.fireDeletedEvent(new Host(hostId, name));
            Long l = hostId;
            return l;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error deleting host with name %s", name), ex);
        }
        finally {
            if (trans != null) {
                trans.rollback();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public List<DataSource> getDataSourcesForHost(Host host) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Optional<Host> getHostByName(String name) throws TskCoreException {
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            Optional<Host> optional = this.getHostByName(name, connection);
            return optional;
        }
    }

    private Optional<Host> getHostByName(String name, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String queryString = "SELECT * FROM tsk_hosts WHERE LOWER(name) = LOWER(?) AND db_status = " + Host.HostDbStatus.ACTIVE.getId();
        this.db.acquireSingleUserCaseReadLock();
        try {
            Optional<Host> optional;
            block15: {
                ResultSet rs;
                block13: {
                    Optional<Host> optional2;
                    block14: {
                        PreparedStatement s = connection.getPreparedStatement(queryString, 1);
                        s.clearParameters();
                        s.setString(1, name);
                        rs = s.executeQuery();
                        try {
                            if (rs.next()) break block13;
                            optional2 = Optional.empty();
                            if (rs == null) break block14;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SQLException ex) {
                                throw new TskCoreException(String.format("Error getting host with name = %s", name), ex);
                            }
                        }
                        rs.close();
                    }
                    return optional2;
                }
                optional = Optional.of(new Host(rs.getLong("id"), rs.getString("name"), Host.HostDbStatus.fromID(rs.getInt("db_status"))));
                if (rs == null) break block15;
                rs.close();
            }
            return optional;
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
    }

    public Optional<Host> getHostById(long id) throws TskCoreException {
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            Optional<Host> optional = this.getHostById(id, connection);
            return optional;
        }
    }

    /*
     * Exception decompiling
     */
    private Optional<Host> getHostById(long id, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Host> getAllHosts() throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Host getHostByDataSource(DataSource dataSource) throws TskCoreException {
        return this.getHostByDataSource(dataSource.getId());
    }

    /*
     * Exception decompiling
     */
    Host getHostByDataSource(long dataSourceId) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void mergeHosts(Host sourceHost, Host destHost) throws TskCoreException {
        Object query = "";
        SleuthkitCase.CaseDbTransaction trans = null;
        try {
            trans = this.db.beginTransaction();
            List<OsAccountRealm> realms = this.db.getOsAccountRealmManager().getRealmsByHost(sourceHost, trans.getConnection());
            for (OsAccountRealm realm : realms) {
                this.db.getOsAccountRealmManager().moveOrMergeRealm(realm, destHost, trans);
            }
            try (Statement s = trans.getConnection().createStatement();){
                query = "DELETE FROM tsk_host_address_map WHERE id IN ( SELECT   sourceMapRow.id FROM   tsk_host_address_map destMapRow INNER JOIN tsk_host_address_map sourceMapRow ON destMapRow.addr_obj_id = sourceMapRow.addr_obj_id AND destMapRow.time = sourceMapRow.time WHERE destMapRow.host_id = " + destHost.getHostId() + " AND sourceMapRow.host_id = " + sourceHost.getHostId() + " )";
                s.executeUpdate((String)query);
                query = this.makeOsAccountUpdateQuery("tsk_host_address_map", "host_id", sourceHost, destHost);
                s.executeUpdate((String)query);
                query = this.makeOsAccountUpdateQuery("tsk_os_account_attributes", "host_id", sourceHost, destHost);
                s.executeUpdate((String)query);
                query = this.makeOsAccountUpdateQuery("data_source_info", "host_id", sourceHost, destHost);
                s.executeUpdate((String)query);
                String mergedName = this.makeMergedHostName();
                query = "UPDATE tsk_hosts SET merged_into = " + destHost.getHostId() + ", db_status = " + Host.HostDbStatus.MERGED.getId() + ", name = '" + mergedName + "'  WHERE id = " + sourceHost.getHostId();
                s.executeUpdate((String)query);
            }
            trans.commit();
            trans = null;
            this.fireChangeEvent(sourceHost);
            this.fireDeletedEvent(destHost);
        }
        catch (SQLException ex) {
            throw new TskCoreException("Error executing query: " + (String)query, ex);
        }
        finally {
            if (trans != null) {
                trans.rollback();
            }
        }
    }

    private String makeOsAccountUpdateQuery(String tableName, String columnName, Host sourceHost, Host destHost) {
        return "UPDATE " + tableName + " SET " + columnName + " = " + destHost.getHostId() + " WHERE " + columnName + " = " + sourceHost.getHostId();
    }

    private String makeMergedHostName() {
        return "MERGED " + UUID.randomUUID().toString();
    }

    private void fireChangeEvent(Host newValue) {
        this.db.fireTSKEvent(new TskEvent.HostsUpdatedTskEvent(Collections.singletonList(newValue)));
    }

    private void fireDeletedEvent(Host deleted) {
        this.db.fireTSKEvent(new TskEvent.HostsDeletedTskEvent(Collections.singletonList(deleted.getHostId())));
    }
}

