/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.Host;
import org.sleuthkit.datamodel.HostAddress;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;

public class HostAddressManager {
    private static final Logger LOGGER = Logger.getLogger(HostAddressManager.class.getName());
    private final SleuthkitCase db;
    private static final byte DEFAULT_MAPPING_CACHE_VALUE = 1;
    private final Cache<Long, Byte> recentHostNameAndIpMappingCache = CacheBuilder.newBuilder().maximumSize(200000L).build();
    private final Cache<String, HostAddress> recentHostAddressCache = CacheBuilder.newBuilder().maximumSize(200000L).build();
    private final Cache<String, Boolean> hostAddressUsageCache = CacheBuilder.newBuilder().maximumSize(200000L).build();
    private final String ADDRESS_USAGE_QUERY = "SELECT addresses.id as id, addresses.address_type as address_type, addresses.address as address  FROM tsk_host_address_usage as usage  JOIN tsk_host_addresses as addresses  ON usage.addr_obj_id = addresses.id ";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.(?!$)|$)){4}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}(%.+)?$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)(%.+)?$");

    HostAddressManager(SleuthkitCase skCase) {
        this.db = skCase;
    }

    public Optional<HostAddress> getHostAddress(HostAddress.HostAddressType type, String address) throws TskCoreException {
        this.db.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
            try {
                Optional<HostAddress> optional = this.getHostAddress(type, address, connection);
                if (connection != null) {
                    connection.close();
                }
                return optional;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<HostAddress> getHostAddress(HostAddress.HostAddressType type, String address, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        HostAddress hostAddress = (HostAddress)this.recentHostAddressCache.getIfPresent((Object)this.createRecentHostAddressKey(type, address));
        if (Objects.nonNull(hostAddress)) {
            return Optional.of(hostAddress);
        }
        HostAddress.HostAddressType addressType = type;
        if (type.equals((Object)HostAddress.HostAddressType.DNS_AUTO)) {
            addressType = this.getDNSType(address);
        }
        String normalizedAddress = HostAddressManager.getNormalizedAddress(address);
        String queryString = "SELECT * FROM tsk_host_addresses WHERE address = ?  AND address_type = ?";
        try {
            PreparedStatement query = connection.getPreparedStatement(queryString, 2);
            query.clearParameters();
            query.setString(1, normalizedAddress.toLowerCase());
            query.setInt(2, addressType.getId());
            try (ResultSet rs = query.executeQuery();){
                if (!rs.next()) {
                    Optional<HostAddress> optional2 = Optional.empty();
                    return optional2;
                }
                HostAddress newHostAddress = new HostAddress(this.db, rs.getLong("id"), HostAddress.HostAddressType.fromID(rs.getInt("address_type")), rs.getString("address"));
                this.recentHostAddressCache.put((Object)this.createRecentHostAddressKey(newHostAddress.getAddressType(), normalizedAddress), (Object)newHostAddress);
                Optional<HostAddress> optional = Optional.of(newHostAddress);
                return optional;
            }
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error getting host address with type = %s and address = %s", type.getName(), address), ex);
        }
    }

    private String createRecentHostAddressKey(HostAddress.HostAddressType type, String address) {
        return this.createRecentHostAddressKey(type.getId(), address);
    }

    private String createRecentHostAddressKey(int typeId, String address) {
        return typeId + "#" + address.toLowerCase();
    }

    public HostAddress newHostAddress(HostAddress.HostAddressType type, String address) throws TskCoreException {
        this.db.acquireSingleUserCaseWriteLock();
        SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
        try {
            HostAddress hostAddress = this.newHostAddress(type, address, connection);
            return hostAddress;
        }
        catch (TskCoreException ex) {
            Optional<HostAddress> hostAddress = this.getHostAddress(type, address, connection);
            if (hostAddress.isPresent()) {
                HostAddress hostAddress2 = hostAddress.get();
                return hostAddress2;
            }
            throw ex;
        }
        finally {
            connection.close();
            this.db.releaseSingleUserCaseWriteLock();
        }
    }

    private HostAddress newHostAddress(HostAddress.HostAddressType type, String address, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        HostAddress.HostAddressType addressType = type;
        if (type.equals((Object)HostAddress.HostAddressType.DNS_AUTO)) {
            addressType = this.getDNSType(address);
        }
        String normalizedAddress = HostAddressManager.getNormalizedAddress(address);
        try {
            long parentObjId = 0L;
            short objTypeId = TskData.ObjectType.HOST_ADDRESS.getObjectType();
            long objId = this.db.addObject(parentObjId, objTypeId, connection);
            String hostAddressInsertSQL = "INSERT INTO tsk_host_addresses(id, address_type, address) VALUES (?, ?, ?)";
            PreparedStatement preparedStatement = connection.getPreparedStatement(hostAddressInsertSQL, 1);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, objId);
            preparedStatement.setInt(2, addressType.getId());
            preparedStatement.setString(3, normalizedAddress.toLowerCase());
            connection.executeUpdate(preparedStatement);
            HostAddress hostAddress = new HostAddress(this.db, objId, addressType, normalizedAddress);
            this.recentHostAddressCache.put((Object)this.createRecentHostAddressKey(addressType, normalizedAddress), (Object)hostAddress);
            return hostAddress;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error adding host address of type = %s, with address = %s", type.getName(), address), ex);
        }
    }

    public void assignHostToAddress(Host host, HostAddress hostAddress, Long time, Content source) throws TskCoreException {
        String insertSQL = this.db.getInsertOrIgnoreSQL(" INTO tsk_host_address_map(host_id, addr_obj_id, source_obj_id, time)  VALUES(?, ?, ?, ?) ");
        this.db.acquireSingleUserCaseWriteLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            PreparedStatement preparedStatement = connection.getPreparedStatement(insertSQL, 2);
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, host.getHostId());
            preparedStatement.setLong(2, hostAddress.getId());
            preparedStatement.setLong(3, source.getId());
            if (time != null) {
                preparedStatement.setLong(4, time);
            } else {
                preparedStatement.setNull(4, -5);
            }
            connection.executeUpdate(preparedStatement);
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            throw new TskCoreException(String.format("Error adding host address mapping for host name = %s,  with address = %s", host.getName(), hostAddress.getAddress()), ex);
        }
        finally {
            this.db.releaseSingleUserCaseWriteLock();
        }
    }

    /*
     * Exception decompiling
     */
    public List<HostAddress> getHostAddressesAssignedTo(Host host) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public HostAddress getHostAddress(long id) throws TskCoreException {
        this.db.acquireSingleUserCaseReadLock();
        try {
            SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
            try {
                HostAddress hostAddress = this.getHostAddress(id, connection);
                if (connection != null) {
                    connection.close();
                }
                return hostAddress;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.db.releaseSingleUserCaseReadLock();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private HostAddress getHostAddress(long id, SleuthkitCase.CaseDbConnection connection) throws TskCoreException {
        String queryString = "SELECT * FROM tsk_host_addresses WHERE id = " + id;
        try (Statement s = connection.createStatement();){
            HostAddress hostAddress;
            block15: {
                ResultSet rs = connection.executeQuery(s, queryString);
                try {
                    if (!rs.next()) {
                        throw new TskCoreException(String.format("No address found with id = %d", id));
                    }
                    long objId = rs.getLong("id");
                    int type = rs.getInt("address_type");
                    String address = rs.getString("address");
                    HostAddress hostAddress2 = new HostAddress(this.db, objId, HostAddress.HostAddressType.fromID(type), address);
                    this.recentHostAddressCache.put((Object)this.createRecentHostAddressKey(type, address), (Object)hostAddress2);
                    hostAddress = hostAddress2;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hostAddress;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error getting host address with id = %d", id), ex);
        }
    }

    public void addHostNameAndIpMapping(HostAddress dnsNameAddress, HostAddress ipAddress, Long time, Content source) throws TskCoreException {
        this.db.acquireSingleUserCaseWriteLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();){
            this.addHostNameAndIpMapping(dnsNameAddress, ipAddress, time, source, connection);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error adding host DNS address mapping for DNS name = %s, and IP address = %s", dnsNameAddress.getAddress(), ipAddress.getAddress()), ex);
        }
        finally {
            this.db.releaseSingleUserCaseWriteLock();
        }
    }

    public void addHostNameAndIpMapping(HostAddress dnsNameAddress, HostAddress ipAddress, Long time, Content source, SleuthkitCase.CaseDbTransaction caseDbTransaction) throws TskCoreException {
        if (Objects.isNull(caseDbTransaction)) {
            throw new TskCoreException(String.format("Error adding host DNS address mapping for DNS name = %s, and IP address = %s, null caseDbTransaction passed to addHostNameAndIpMapping", dnsNameAddress.getAddress(), ipAddress.getAddress()));
        }
        try {
            this.addHostNameAndIpMapping(dnsNameAddress, ipAddress, time, source, caseDbTransaction.getConnection());
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error adding host DNS address mapping for DNS name = %s, and IP address = %s", dnsNameAddress.getAddress(), ipAddress.getAddress()), ex);
        }
    }

    private void addHostNameAndIpMapping(HostAddress dnsNameAddress, HostAddress ipAddress, Long time, Content source, SleuthkitCase.CaseDbConnection connection) throws SQLException, TskCoreException {
        if (dnsNameAddress.getAddressType() != HostAddress.HostAddressType.HOSTNAME) {
            throw new TskCoreException("IllegalArguments passed to addHostNameAndIpMapping: A host name address is expected.");
        }
        if (ipAddress.getAddressType() != HostAddress.HostAddressType.IPV4 && ipAddress.getAddressType() != HostAddress.HostAddressType.IPV6) {
            throw new TskCoreException("IllegalArguments passed to addHostNameAndIpMapping:An IPv4/IPv6 address is expected.");
        }
        if (Objects.isNull(connection)) {
            throw new TskCoreException("IllegalArguments passed to addHostNameAndIpMapping: null connection passed to addHostNameAndIpMapping");
        }
        String insertSQL = this.db.getInsertOrIgnoreSQL(" INTO tsk_host_address_dns_ip_map(dns_address_id, ip_address_id, source_obj_id, time)  VALUES(?, ?, ?, ?) ");
        PreparedStatement preparedStatement = connection.getPreparedStatement(insertSQL, 2);
        preparedStatement.clearParameters();
        preparedStatement.setLong(1, dnsNameAddress.getId());
        preparedStatement.setLong(2, ipAddress.getId());
        preparedStatement.setLong(3, source.getId());
        if (time != null) {
            preparedStatement.setLong(4, time);
        } else {
            preparedStatement.setNull(4, -5);
        }
        connection.executeUpdate(preparedStatement);
        this.recentHostNameAndIpMappingCache.put((Object)ipAddress.getId(), (Object)1);
        this.recentHostNameAndIpMappingCache.put((Object)dnsNameAddress.getId(), (Object)1);
    }

    /*
     * Exception decompiling
     */
    public boolean hostNameAndIpMappingExists(long addressObjectId) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Optional<Long> hostAddressExists(HostAddress.HostAddressType type, String address) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<HostAddress> getIpAddress(String hostname) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    List<HostAddress> getHostNameByIp(String ipAddress) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addUsage(Content content, HostAddress hostAddress) throws TskCoreException {
        String key = content.getDataSource().getId() + "#" + hostAddress.getId() + "#" + content.getId();
        Boolean cachedValue = (Boolean)this.hostAddressUsageCache.getIfPresent((Object)key);
        if (null != cachedValue) {
            return;
        }
        String insertSQL = this.db.getInsertOrIgnoreSQL(" INTO tsk_host_address_usage(addr_obj_id, obj_id, data_source_obj_id)  VALUES(" + hostAddress.getId() + ", " + content.getId() + ", " + content.getDataSource().getId() + ") ");
        this.db.acquireSingleUserCaseWriteLock();
        try (SleuthkitCase.CaseDbConnection connection = this.db.getConnection();
             Statement s = connection.createStatement();){
            connection.executeUpdate(s, insertSQL);
            this.hostAddressUsageCache.put((Object)key, (Object)true);
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error associating host address %s with artifact with id %d", hostAddress.getAddress(), content.getId()), ex);
        }
        finally {
            this.db.releaseSingleUserCaseWriteLock();
        }
    }

    public List<HostAddress> getHostAddressesUsedByContent(Content content) throws TskCoreException {
        String queryString = "SELECT addresses.id as id, addresses.address_type as address_type, addresses.address as address  FROM tsk_host_address_usage as usage  JOIN tsk_host_addresses as addresses  ON usage.addr_obj_id = addresses.id  WHERE usage.obj_id = " + content.getId();
        return this.getHostAddressesUsed(queryString);
    }

    public List<HostAddress> getHostAddressesUsedOnDataSource(Content dataSource) throws TskCoreException {
        String queryString = "SELECT addresses.id as id, addresses.address_type as address_type, addresses.address as address  FROM tsk_host_address_usage as usage  JOIN tsk_host_addresses as addresses  ON usage.addr_obj_id = addresses.id  WHERE usage.data_source_obj_id = " + dataSource.getId();
        return this.getHostAddressesUsed(queryString);
    }

    /*
     * Exception decompiling
     */
    private List<HostAddress> getHostAddressesUsed(String addressesUsedSQL) throws TskCoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HostAddress.HostAddressType getDNSType(String address) {
        if (HostAddressManager.isIPv4(address)) {
            return HostAddress.HostAddressType.IPV4;
        }
        if (HostAddressManager.isIPv6(address)) {
            return HostAddress.HostAddressType.IPV6;
        }
        return HostAddress.HostAddressType.HOSTNAME;
    }

    private static boolean isIPv4(String ipAddress) {
        if (ipAddress != null) {
            return IPV4_PATTERN.matcher(ipAddress).matches();
        }
        return false;
    }

    private static boolean isIPv6StdAddress(String input) {
        return IPV6_STD_PATTERN.matcher(input).matches();
    }

    private static boolean isIPv6HexCompressedAddress(String input) {
        return IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
    }

    private static boolean isIPv6(String ipAddress) {
        if (ipAddress != null) {
            return HostAddressManager.isIPv6StdAddress(ipAddress) || HostAddressManager.isIPv6HexCompressedAddress(ipAddress);
        }
        return false;
    }

    private static String getNormalizedAddress(String address) {
        String normalizedAddress = address;
        if (HostAddressManager.isIPv6(address)) {
            normalizedAddress = HostAddressManager.getNormalizedIPV6Address(address);
        }
        return normalizedAddress;
    }

    private static String getNormalizedIPV6Address(String address) {
        String normalizedAddress = address;
        if (normalizedAddress.contains("%")) {
            normalizedAddress = normalizedAddress.substring(0, normalizedAddress.indexOf("%"));
        }
        return normalizedAddress;
    }
}

