/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.sleuthkit.datamodel.TskCoreException;

public class ConcurrentDbAccessException
extends TskCoreException {
    private final String conflictingApplicationName;

    static ConcurrentDbAccessException createForFile(String lockFilePath, RandomAccessFile lockFileRaf) throws IOException {
        StringBuffer buffer = new StringBuffer();
        while (lockFileRaf.getFilePointer() < lockFileRaf.length()) {
            buffer.append(lockFileRaf.readLine() + System.lineSeparator());
        }
        String conflictingApplication = buffer.toString().trim();
        String message = "Unable to acquire lock on " + lockFilePath + "." + (String)(conflictingApplication != null && conflictingApplication.trim().length() > 0 ? "  Database is already open in " + conflictingApplication + "." : "");
        return new ConcurrentDbAccessException(message, conflictingApplication);
    }

    ConcurrentDbAccessException(String message, String conflictingApplicationName) {
        super(message);
        this.conflictingApplicationName = conflictingApplicationName;
    }

    public String getConflictingApplicationName() {
        return this.conflictingApplicationName;
    }
}

