/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import org.sleuthkit.datamodel.TskData;

public class CaseDbConnectionInfo {
    private String hostNameOrIP;
    private String portNumber;
    private String userName;
    private String password;
    private TskData.DbType dbType;
    private boolean sslEnabled = false;
    private boolean sslVerify = false;
    private String customSslValidationClassName;

    public CaseDbConnectionInfo(String hostNameOrIP, String portNumber, String userName, String password, TskData.DbType dbType) {
        this.hostNameOrIP = hostNameOrIP;
        this.portNumber = portNumber;
        this.userName = userName;
        this.password = password;
        this.sslEnabled = false;
        this.sslVerify = false;
        if (dbType == TskData.DbType.SQLITE) {
            throw new IllegalArgumentException("SQLite database type invalid for CaseDbConnectionInfo. CaseDbConnectionInfo should be used only for remote database types.");
        }
        this.dbType = dbType;
        this.customSslValidationClassName = "";
    }

    public CaseDbConnectionInfo(String hostNameOrIP, String portNumber, String userName, String password, TskData.DbType dbType, boolean sslEnabled, boolean sslVerify, String customSslValidationClassName) {
        this.hostNameOrIP = hostNameOrIP;
        this.portNumber = portNumber;
        this.userName = userName;
        this.password = password;
        this.sslEnabled = sslEnabled;
        this.sslVerify = sslVerify;
        if (dbType == TskData.DbType.SQLITE) {
            throw new IllegalArgumentException("SQLite database type invalid for CaseDbConnectionInfo. CaseDbConnectionInfo should be used only for remote database types.");
        }
        this.dbType = dbType;
        this.customSslValidationClassName = customSslValidationClassName;
    }

    public TskData.DbType getDbType() {
        return this.dbType;
    }

    public String getHost() {
        return this.hostNameOrIP;
    }

    public String getPort() {
        return this.portNumber;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setDbType(TskData.DbType db) {
        this.dbType = db;
    }

    public void setHost(String host) {
        this.hostNameOrIP = host;
    }

    public void setPort(String port) {
        this.portNumber = port;
    }

    public void setUserName(String user) {
        this.userName = user;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public boolean isSslVerify() {
        return this.sslVerify;
    }

    public void setSslVerify(boolean sslVerify) {
        this.sslVerify = sslVerify;
    }

    public String getCustomSslValidationClassName() {
        return this.customSslValidationClassName;
    }

    public void setCustomSslValidationClassName(String customSslValidationClassName) {
        this.customSslValidationClassName = customSslValidationClassName;
    }
}

