/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Collection;
import org.sleuthkit.datamodel.Account;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.TskCoreException;

public final class AccountFileInstance {
    private final BlackboardArtifact artifact;
    private final Account account;

    AccountFileInstance(BlackboardArtifact artifact, Account account) throws TskCoreException {
        this.artifact = artifact;
        this.account = account;
    }

    public BlackboardAttribute getAttribute(BlackboardAttribute.ATTRIBUTE_TYPE attrType) throws TskCoreException {
        return this.artifact.getAttribute(new BlackboardAttribute.Type(attrType));
    }

    public void addAttribute(BlackboardAttribute bbatr) throws TskCoreException {
        this.artifact.addAttribute(bbatr);
    }

    public void addAttributes(Collection<BlackboardAttribute> bbatrs) throws TskCoreException {
        this.artifact.addAttributes(bbatrs);
    }

    public Account getAccount() throws TskCoreException {
        return this.account;
    }

    public Content getFile() throws TskCoreException {
        return this.artifact.getSleuthkitCase().getContentById(this.artifact.getObjectID());
    }

    Long getDataSourceObjectID() {
        return this.artifact.getDataSourceObjectID();
    }
}

