/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import com.google.common.annotations.Beta;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sleuthkit.datamodel.AbstractContent;
import org.sleuthkit.datamodel.Attribute;
import org.sleuthkit.datamodel.BlackboardArtifact;
import org.sleuthkit.datamodel.BlackboardAttribute;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentProviderStream;
import org.sleuthkit.datamodel.ContentStreamProvider;
import org.sleuthkit.datamodel.DataArtifact;
import org.sleuthkit.datamodel.DerivedFile;
import org.sleuthkit.datamodel.EncodedFileUtil;
import org.sleuthkit.datamodel.FileSystem;
import org.sleuthkit.datamodel.LayoutFile;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TimeUtilities;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;
import org.sleuthkit.datamodel.TskFileRange;

public abstract class AbstractFile
extends AbstractContent {
    protected final TskData.TSK_DB_FILES_TYPE_ENUM fileType;
    protected final TskData.TSK_FS_NAME_TYPE_ENUM dirType;
    protected final TskData.TSK_FS_META_TYPE_ENUM metaType;
    protected TskData.TSK_FS_NAME_FLAG_ENUM dirFlag;
    protected Set<TskData.TSK_FS_META_FLAG_ENUM> metaFlags;
    protected final Long fileSystemObjectId;
    protected long size;
    protected final long metaAddr;
    protected final long ctime;
    protected final long crtime;
    protected final long atime;
    protected final long mtime;
    protected final int metaSeq;
    protected final int uid;
    protected final int gid;
    protected final int attrId;
    protected final TskData.TSK_FS_ATTR_TYPE_ENUM attrType;
    protected final Set<TskData.TSK_FS_META_MODE_ENUM> modes;
    private boolean localPathSet = false;
    private String localPath;
    private String localAbsPath;
    private volatile RandomAccessFile localFileHandle;
    private volatile File localFile;
    private TskData.EncodingType encodingType;
    private List<TskFileRange> ranges;
    protected final String parentPath;
    protected TskData.FileKnown knownState;
    private boolean knownStateDirty = false;
    protected String md5Hash;
    private boolean md5HashDirty = false;
    protected String sha256Hash;
    private boolean sha256HashDirty = false;
    protected String sha1Hash;
    private boolean sha1HashDirty = false;
    private TskData.CollectedStatus collected;
    private boolean collectedDirty = false;
    private String mimeType;
    private boolean mimeTypeDirty = false;
    private static final Logger LOGGER = Logger.getLogger(AbstractFile.class.getName());
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private long dataSourceObjectId;
    private final String extension;
    private final List<Attribute> fileAttributesCache = new ArrayList<Attribute>();
    private boolean loadedAttributesCacheFromDb = false;
    private final String ownerUid;
    private final Long osAccountObjId;
    private volatile String uniquePath;
    private volatile FileSystem parentFileSystem;
    private final boolean tryContentProviderStream;
    private Object contentProviderStreamLock = new Object();
    private SoftReference<ContentProviderStream> contentProviderStreamRef = null;

    AbstractFile(SleuthkitCase db, long objId, long dataSourceObjectId, Long fileSystemObjectId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId, String name, TskData.TSK_DB_FILES_TYPE_ENUM fileType, long metaAddr, int metaSeq, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, short modes, int uid, int gid, String md5Hash, String sha256Hash, String sha1Hash, TskData.FileKnown knownState, String parentPath, String mimeType, String extension, String ownerUid, Long osAccountObjectId, TskData.CollectedStatus collected, List<Attribute> fileAttributes) {
        super(db, objId, name);
        this.dataSourceObjectId = dataSourceObjectId;
        this.fileSystemObjectId = fileSystemObjectId != null ? (fileSystemObjectId > 0L ? fileSystemObjectId : null) : null;
        this.attrType = attrType;
        this.attrId = attrId;
        this.fileType = fileType;
        this.metaAddr = metaAddr;
        this.metaSeq = metaSeq;
        this.dirType = dirType;
        this.metaType = metaType;
        this.dirFlag = dirFlag;
        this.metaFlags = TskData.TSK_FS_META_FLAG_ENUM.valuesOf(metaFlags);
        this.size = size;
        this.ctime = ctime;
        this.crtime = crtime;
        this.atime = atime;
        this.mtime = mtime;
        this.uid = uid;
        this.gid = gid;
        this.modes = TskData.TSK_FS_META_MODE_ENUM.valuesOf(modes);
        this.md5Hash = md5Hash;
        this.sha256Hash = sha256Hash;
        this.sha1Hash = sha1Hash;
        this.knownState = knownState == null ? TskData.FileKnown.UNKNOWN : knownState;
        this.parentPath = parentPath;
        this.mimeType = mimeType;
        this.extension = extension == null ? "" : extension;
        this.encodingType = TskData.EncodingType.NONE;
        this.ownerUid = ownerUid;
        this.osAccountObjId = osAccountObjectId;
        this.collected = collected;
        boolean bl = this.tryContentProviderStream = collected == TskData.CollectedStatus.YES_REPO && db.getContentProvider() != null;
        if (Objects.nonNull(fileAttributes) && !fileAttributes.isEmpty()) {
            this.fileAttributesCache.addAll(fileAttributes);
            this.loadedAttributesCacheFromDb = true;
        }
    }

    public TskData.TSK_DB_FILES_TYPE_ENUM getType() {
        return this.fileType;
    }

    public TskData.TSK_FS_ATTR_TYPE_ENUM getAttrType() {
        return this.attrType;
    }

    public int getAttributeId() {
        return this.attrId;
    }

    public long getCtime() {
        return this.ctime;
    }

    public String getCtimeAsDate() {
        return AbstractFile.epochToTime(this.ctime);
    }

    public long getCrtime() {
        return this.crtime;
    }

    public String getCrtimeAsDate() {
        return AbstractFile.epochToTime(this.crtime);
    }

    public long getAtime() {
        return this.atime;
    }

    public String getAtimeAsDate() {
        return AbstractFile.epochToTime(this.atime);
    }

    public long getMtime() {
        return this.mtime;
    }

    public String getMtimeAsDate() {
        return AbstractFile.epochToTime(this.mtime);
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }

    public long getMetaAddr() {
        return this.metaAddr;
    }

    public long getMetaSeq() {
        return this.metaSeq;
    }

    public String getModesAsString() {
        short mode = TskData.TSK_FS_META_MODE_ENUM.toInt(this.modes);
        Object result = "";
        short isuid = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_ISUID.getMode();
        short isgid = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_ISGID.getMode();
        short isvtx = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_ISVTX.getMode();
        short irusr = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IRUSR.getMode();
        short iwusr = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IWUSR.getMode();
        short ixusr = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IXUSR.getMode();
        short irgrp = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IRGRP.getMode();
        short iwgrp = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IWGRP.getMode();
        short ixgrp = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IXGRP.getMode();
        short iroth = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IROTH.getMode();
        short iwoth = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IWOTH.getMode();
        short ixoth = TskData.TSK_FS_META_MODE_ENUM.TSK_FS_META_MODE_IXOTH.getMode();
        result = (String)result + this.metaType.toString();
        result = (mode & irusr) == irusr ? (String)result + "r" : (String)result + "-";
        result = (mode & iwusr) == iwusr ? (String)result + "w" : (String)result + "-";
        result = (mode & isuid) == isuid ? ((mode & ixusr) == ixusr ? (String)result + "s" : (String)result + "S") : ((mode & ixusr) == ixusr ? (String)result + "x" : (String)result + "-");
        result = (mode & irgrp) == irgrp ? (String)result + "r" : (String)result + "-";
        result = (mode & iwgrp) == iwgrp ? (String)result + "w" : (String)result + "-";
        result = (mode & isgid) == isgid ? ((mode & ixgrp) == ixgrp ? (String)result + "s" : (String)result + "S") : ((mode & ixgrp) == ixgrp ? (String)result + "x" : (String)result + "-");
        result = (mode & iroth) == iroth ? (String)result + "r" : (String)result + "-";
        result = (mode & iwoth) == iwoth ? (String)result + "w" : (String)result + "-";
        result = (mode & isvtx) == isvtx ? ((mode & ixoth) == ixoth ? (String)result + "t" : (String)result + "T") : ((mode & ixoth) == ixoth ? (String)result + "x" : (String)result + "-");
        if (((String)result).length() != 10) {
            result = "ERROR";
        }
        return result;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public void setMIMEType(String mimeType) {
        this.mimeType = mimeType;
        this.mimeTypeDirty = true;
    }

    public boolean isModeSet(TskData.TSK_FS_META_MODE_ENUM mode) {
        return this.modes.contains((Object)mode);
    }

    public void setMd5Hash(String md5Hash) {
        this.md5Hash = md5Hash;
        this.md5HashDirty = true;
    }

    public String getMd5Hash() {
        return this.md5Hash;
    }

    public void setSha256Hash(String sha256Hash) {
        this.sha256Hash = sha256Hash;
        this.sha256HashDirty = true;
    }

    public String getSha256Hash() {
        return this.sha256Hash;
    }

    public void setSha1Hash(String sha1Hash) {
        this.sha1Hash = sha1Hash;
        this.sha1HashDirty = true;
    }

    public String getSha1Hash() {
        return this.sha1Hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Attribute> getAttributes() throws TskCoreException {
        AbstractFile abstractFile = this;
        synchronized (abstractFile) {
            if (!this.loadedAttributesCacheFromDb) {
                ArrayList<Attribute> attributes = this.getSleuthkitCase().getBlackboard().getFileAttributes(this);
                this.fileAttributesCache.clear();
                this.fileAttributesCache.addAll(attributes);
                this.loadedAttributesCacheFromDb = true;
            }
            return Collections.unmodifiableList(this.fileAttributesCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(Collection<Attribute> attributes, SleuthkitCase.CaseDbTransaction caseDbTransaction) throws TskCoreException {
        if (Objects.isNull(attributes) || attributes.isEmpty()) {
            throw new TskCoreException("Illegal Argument passed to addAttributes: null or empty attributes passed to addAttributes");
        }
        boolean isLocalTransaction = Objects.isNull(caseDbTransaction);
        SleuthkitCase.CaseDbTransaction localTransaction = isLocalTransaction ? this.getSleuthkitCase().beginTransaction() : null;
        SleuthkitCase.CaseDbConnection connection = isLocalTransaction ? localTransaction.getConnection() : caseDbTransaction.getConnection();
        try {
            for (Attribute attribute : attributes) {
                attribute.setAttributeParentId(this.getId());
                attribute.setCaseDatabase(this.getSleuthkitCase());
                this.getSleuthkitCase().addFileAttribute(attribute, connection);
            }
            if (isLocalTransaction) {
                localTransaction.commit();
                localTransaction = null;
            }
            AbstractFile abstractFile = this;
            synchronized (abstractFile) {
                if (this.loadedAttributesCacheFromDb) {
                    this.fileAttributesCache.addAll(attributes);
                }
            }
        }
        catch (SQLException ex) {
            if (isLocalTransaction && null != localTransaction) {
                try {
                    localTransaction.rollback();
                }
                catch (TskCoreException ex2) {
                    LOGGER.log(Level.SEVERE, "Failed to rollback transaction after exception", ex2);
                }
            }
            throw new TskCoreException("Error adding file attributes", ex);
        }
    }

    public void setKnown(TskData.FileKnown knownState) {
        if (this.knownState.compareTo(knownState) > 0) {
            return;
        }
        this.knownState = knownState;
        this.knownStateDirty = true;
    }

    public TskData.FileKnown getKnown() {
        return this.knownState;
    }

    public String getNameExtension() {
        return this.extension;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    @Override
    public Content getDataSource() throws TskCoreException {
        return this.getSleuthkitCase().getContentById(this.dataSourceObjectId);
    }

    public long getDataSourceObjectId() {
        return this.dataSourceObjectId;
    }

    public TskData.CollectedStatus getCollected() {
        return this.collected;
    }

    public void setCollected(TskData.CollectedStatus collected) {
        this.collected = collected;
        this.collectedDirty = true;
    }

    public List<TskFileRange> getRanges() throws TskCoreException {
        if (this.ranges == null) {
            this.ranges = this.getSleuthkitCase().getFileRanges(this.getId());
        }
        return this.ranges;
    }

    public long convertToImgOffset(long fileOffset) throws TskCoreException {
        long imgOffset = -1L;
        for (TskFileRange byteRange : this.getRanges()) {
            long rangeLength = byteRange.getByteLen();
            if (fileOffset < rangeLength) {
                imgOffset = byteRange.getByteStart() + fileOffset;
                break;
            }
            fileOffset -= rangeLength;
        }
        return imgOffset;
    }

    public List<TskFileRange> convertToImgRanges(long fileOffset, long length) throws TskCoreException {
        if (fileOffset < 0L || length < 0L) {
            throw new TskCoreException("fileOffset and length must be non-negative");
        }
        List<TskFileRange> thisRanges = this.getRanges();
        ArrayList<TskFileRange> toRet = new ArrayList<TskFileRange>();
        long requestedEnd = fileOffset + length;
        long bytesCounted = 0L;
        for (int curRangeIdx = 0; curRangeIdx < thisRanges.size() && bytesCounted < requestedEnd; ++curRangeIdx) {
            TskFileRange curRange = thisRanges.get(curRangeIdx);
            long curRangeLen = curRange.getByteLen();
            long curRangeEnd = bytesCounted + curRangeLen;
            if (fileOffset < curRangeEnd) {
                long rangeOffset = Math.max(0L, fileOffset - bytesCounted);
                long newRangeStart = curRange.getByteStart() + rangeOffset;
                long rangeOvershoot = Math.max(0L, curRangeEnd - requestedEnd);
                long newRangeLen = curRangeLen - rangeOffset - rangeOvershoot;
                toRet.add(new TskFileRange(newRangeStart, newRangeLen, toRet.size()));
            }
            bytesCounted = curRangeEnd;
        }
        return toRet;
    }

    public boolean isVirtual() {
        return this.fileType.equals((Object)TskData.TSK_DB_FILES_TYPE_ENUM.VIRTUAL_DIR) || this.dirType.equals((Object)TskData.TSK_FS_NAME_TYPE_ENUM.VIRT) || this.metaType.equals((Object)TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT);
    }

    public boolean isFile() {
        return this.metaType.equals((Object)TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_REG) || this.metaType.equals((Object)TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_UNDEF) && this.dirType.equals((Object)TskData.TSK_FS_NAME_TYPE_ENUM.REG);
    }

    public boolean isDir() {
        return this.metaType.equals((Object)TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_DIR) || this.metaType.equals((Object)TskData.TSK_FS_META_TYPE_ENUM.TSK_FS_META_TYPE_VIRT_DIR);
    }

    @Beta
    public int countChildrenOfType(List<TskData.TSK_FS_NAME_TYPE_ENUM> types) throws TskCoreException {
        return this.getSleuthkitCase().getAbstractFileChildrenCountByType(this, types);
    }

    public abstract boolean isRoot();

    public static String createNonUniquePath(String uniquePath) {
        String[] pathSegments = uniquePath.split("/");
        int index = 0;
        if (pathSegments[0].startsWith("img_")) {
            ++index;
        }
        if (pathSegments[1].startsWith("vol_")) {
            ++index;
        }
        StringBuilder strbuf = new StringBuilder();
        while (index < pathSegments.length) {
            if (!pathSegments[index].isEmpty()) {
                strbuf.append("/").append(pathSegments[index]);
            }
            ++index;
        }
        return strbuf.toString();
    }

    public List<AbstractFile> listFiles() throws TskCoreException {
        List<Content> children = this.getChildren();
        ArrayList<AbstractFile> files = new ArrayList<AbstractFile>();
        for (Content child : children) {
            if (!(child instanceof AbstractFile)) continue;
            AbstractFile afChild = (AbstractFile)child;
            files.add(afChild);
        }
        return files;
    }

    public TskData.TSK_FS_META_TYPE_ENUM getMetaType() {
        return this.metaType;
    }

    public String getMetaTypeAsString() {
        return this.metaType.toString();
    }

    public TskData.TSK_FS_NAME_TYPE_ENUM getDirType() {
        return this.dirType;
    }

    public String getDirTypeAsString() {
        return this.dirType.toString();
    }

    public boolean isDirNameFlagSet(TskData.TSK_FS_NAME_FLAG_ENUM flag) {
        return this.dirFlag == flag;
    }

    public String getDirFlagAsString() {
        return this.dirFlag.toString();
    }

    void setDirFlag(TskData.TSK_FS_NAME_FLAG_ENUM flag) {
        this.dirFlag = flag;
    }

    public String getMetaFlagsAsString() {
        String str = "";
        if (this.metaFlags.contains((Object)TskData.TSK_FS_META_FLAG_ENUM.ALLOC)) {
            str = TskData.TSK_FS_META_FLAG_ENUM.ALLOC.toString();
        } else if (this.metaFlags.contains((Object)TskData.TSK_FS_META_FLAG_ENUM.UNALLOC)) {
            str = TskData.TSK_FS_META_FLAG_ENUM.UNALLOC.toString();
        }
        return str;
    }

    public boolean isMetaFlagSet(TskData.TSK_FS_META_FLAG_ENUM metaFlag) {
        return this.metaFlags.contains((Object)metaFlag);
    }

    void setMetaFlag(TskData.TSK_FS_META_FLAG_ENUM metaFlag) {
        this.metaFlags.add(metaFlag);
    }

    void removeMetaFlag(TskData.TSK_FS_META_FLAG_ENUM metaFlag) {
        this.metaFlags.remove((Object)metaFlag);
    }

    short getMetaFlagsAsInt() {
        return TskData.TSK_FS_META_FLAG_ENUM.toInt(this.metaFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentProviderStream getContentProviderStream() throws TskCoreException {
        Object object = this.contentProviderStreamLock;
        synchronized (object) {
            ContentProviderStream contentProviderStream;
            ContentProviderStream contentProviderStream2 = contentProviderStream = this.contentProviderStreamRef == null ? null : this.contentProviderStreamRef.get();
            if (contentProviderStream == null) {
                ContentStreamProvider provider = this.getSleuthkitCase().getContentProvider();
                ContentProviderStream contentProviderStream3 = contentProviderStream = provider == null ? null : (ContentProviderStream)provider.getContentStream(this).orElse(null);
                if (contentProviderStream == null) {
                    throw new TskCoreException(MessageFormat.format("Could not get content provider string for file with obj id: {0}, path: {1}", this.getId(), this.getUniquePath()));
                }
                this.contentProviderStreamRef = new SoftReference<ContentProviderStream>(contentProviderStream);
            }
            return contentProviderStream;
        }
    }

    @Override
    public final int read(byte[] buf, long offset, long len) throws TskCoreException {
        if (this.tryContentProviderStream) {
            ContentProviderStream contentProviderStream = this.getContentProviderStream();
            return contentProviderStream.read(buf, offset, len);
        }
        if (this.localPathSet) {
            return this.readLocal(buf, offset, len);
        }
        return this.readInt(buf, offset, len);
    }

    protected int readInt(byte[] buf, long offset, long len) throws TskCoreException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int readLocal(byte[] buf, long offset, long len) throws TskCoreException {
        if (!this.localPathSet) {
            throw new TskCoreException(BUNDLE.getString("AbstractFile.readLocal.exception.msg1.text"));
        }
        if (this.isDir()) {
            return 0;
        }
        if (this.getSize() == 0L) {
            return 0;
        }
        this.loadLocalFile();
        int bytesRead = 0;
        if (this.localFileHandle == null) {
            AbstractFile abstractFile = this;
            synchronized (abstractFile) {
                if (this.localFileHandle == null) {
                    try {
                        this.localFileHandle = new RandomAccessFile(this.localFile, "r");
                    }
                    catch (FileNotFoundException ex) {
                        String msg = MessageFormat.format(BUNDLE.getString("AbstractFile.readLocal.exception.msg4.text"), this.localAbsPath);
                        LOGGER.log(Level.SEVERE, msg, ex);
                        throw new TskCoreException(msg, ex);
                    }
                }
            }
        }
        try {
            if (!this.encodingType.equals((Object)TskData.EncodingType.NONE)) {
                long encodedOffset = offset + (long)EncodedFileUtil.getHeaderLength();
                long curOffset = this.localFileHandle.getFilePointer();
                if (curOffset != encodedOffset) {
                    this.localFileHandle.seek(encodedOffset);
                }
                bytesRead = this.localFileHandle.read(buf, 0, (int)len);
                for (int i = 0; i < bytesRead; ++i) {
                    buf[i] = EncodedFileUtil.decodeByte(buf[i], this.encodingType);
                }
                return bytesRead;
            }
            long curOffset = this.localFileHandle.getFilePointer();
            if (curOffset != offset) {
                this.localFileHandle.seek(offset);
            }
            return this.localFileHandle.read(buf, 0, (int)len);
        }
        catch (IOException ex) {
            String msg = MessageFormat.format(BUNDLE.getString("AbstractFile.readLocal.exception.msg5.text"), this.localAbsPath);
            LOGGER.log(Level.SEVERE, msg, ex);
            throw new TskCoreException(msg, ex);
        }
    }

    void setLocalFilePath(String localPath) {
        if (localPath == null || localPath.equals("")) {
            this.localPath = "";
            this.localAbsPath = null;
            this.localPathSet = false;
        } else {
            this.localPath = localPath;
            this.localAbsPath = this instanceof DerivedFile ? this.getSleuthkitCase().getDbDirPath() + File.separator + localPath : (localPath.startsWith("/") || localPath.startsWith("\\") || localPath.matches("[A-Za-z]:[/\\\\].*") ? localPath : this.getSleuthkitCase().getDbDirPath() + File.separator + localPath);
            this.localPathSet = true;
        }
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public String getLocalAbsPath() {
        return this.localAbsPath;
    }

    final void setEncodingType(TskData.EncodingType encodingType) {
        this.encodingType = encodingType;
    }

    public boolean exists() {
        if (this.tryContentProviderStream || !this.localPathSet) {
            return true;
        }
        try {
            this.loadLocalFile();
            return this.localFile.exists();
        }
        catch (TskCoreException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage());
            return false;
        }
    }

    public boolean canRead() {
        if (this.tryContentProviderStream || !this.localPathSet) {
            return true;
        }
        try {
            this.loadLocalFile();
            return this.localFile.canRead();
        }
        catch (TskCoreException ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLocalFile() throws TskCoreException {
        if (!this.localPathSet) {
            throw new TskCoreException(BUNDLE.getString("AbstractFile.readLocal.exception.msg1.text"));
        }
        if (this.localFile != null) {
            return;
        }
        AbstractFile abstractFile = this;
        synchronized (abstractFile) {
            if (this.localFile == null) {
                this.localFile = new File(this.localAbsPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.localFileHandle != null) {
            AbstractFile abstractFile = this;
            synchronized (abstractFile) {
                if (this.localFileHandle != null) {
                    try {
                        this.localFileHandle.close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.SEVERE, "Could not close file handle for file: " + this.getParentPath() + this.getName(), ex);
                    }
                    this.localFileHandle = null;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String toString(boolean preserveState) {
        return super.toString(preserveState) + "AbstractFile [\t\tfileType " + String.valueOf((Object)this.fileType) + "\tctime " + this.ctime + "\tcrtime " + this.crtime + "\tmtime " + this.mtime + "\tatime " + this.atime + "\tattrId " + this.attrId + "\tattrType " + String.valueOf((Object)this.attrType) + "\tdirFlag " + String.valueOf((Object)this.dirFlag) + "\tdirType " + String.valueOf((Object)this.dirType) + "\tuid " + this.uid + "\tgid " + this.gid + "\tmetaAddr " + this.metaAddr + "\tmetaSeq " + this.metaSeq + "\tmetaFlags " + String.valueOf(this.metaFlags) + "\tmetaType " + String.valueOf((Object)this.metaType) + "\tmodes " + String.valueOf(this.modes) + "\tparentPath " + this.parentPath + "\tsize " + this.size + "\tknownState " + String.valueOf((Object)this.knownState) + "\tmd5Hash " + this.md5Hash + "\tsha256Hash " + this.sha256Hash + "\tsha1Hash " + this.sha1Hash + "\tlocalPathSet " + this.localPathSet + "\tlocalPath " + this.localPath + "\tlocalAbsPath " + this.localAbsPath + "\tlocalFile " + String.valueOf(this.localFile) + "]\t";
    }

    public MimeMatchEnum isMimeType(SortedSet<String> mimeTypes) {
        if (this.mimeType == null) {
            return MimeMatchEnum.UNDEFINED;
        }
        if (mimeTypes.contains(this.mimeType)) {
            return MimeMatchEnum.TRUE;
        }
        return MimeMatchEnum.FALSE;
    }

    public void save() throws TskCoreException {
        SleuthkitCase.CaseDbTransaction transaction = null;
        try {
            transaction = this.getSleuthkitCase().beginTransaction();
            this.save(transaction);
            transaction.commit();
        }
        catch (TskCoreException ex) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw ex;
        }
    }

    public void save(SleuthkitCase.CaseDbTransaction transaction) throws TskCoreException {
        if (!(this.md5HashDirty || this.sha256HashDirty || this.sha1HashDirty || this.mimeTypeDirty || this.knownStateDirty || this.collectedDirty)) {
            return;
        }
        Object updateSql = "";
        if (this.mimeTypeDirty) {
            updateSql = "mime_type = '" + this.getMIMEType() + "'";
        }
        if (this.md5HashDirty) {
            if (!((String)updateSql).isEmpty()) {
                updateSql = (String)updateSql + ", ";
            }
            updateSql = (String)updateSql + "md5 = '" + this.getMd5Hash() + "'";
        }
        if (this.sha256HashDirty) {
            if (!((String)updateSql).isEmpty()) {
                updateSql = (String)updateSql + ", ";
            }
            updateSql = (String)updateSql + "sha256 = '" + this.getSha256Hash() + "'";
        }
        if (this.sha1HashDirty) {
            if (!((String)updateSql).isEmpty()) {
                updateSql = (String)updateSql + ", ";
            }
            updateSql = (String)updateSql + "sha1 = '" + this.getSha1Hash() + "'";
        }
        if (this.knownStateDirty) {
            if (!((String)updateSql).isEmpty()) {
                updateSql = (String)updateSql + ", ";
            }
            updateSql = (String)updateSql + "known = '" + this.getKnown().getFileKnownValue() + "'";
        }
        if (this.collectedDirty) {
            if (!((String)updateSql).isEmpty()) {
                updateSql = (String)updateSql + ", ";
            }
            updateSql = (String)updateSql + "collected = '" + this.getCollected().getType() + "'";
        }
        updateSql = "UPDATE tsk_files SET " + (String)updateSql + " WHERE obj_id = " + this.getId();
        SleuthkitCase.CaseDbConnection connection = transaction.getConnection();
        try (Statement statement = connection.createStatement();){
            connection.executeUpdate(statement, (String)updateSql);
            this.md5HashDirty = false;
            this.sha256HashDirty = false;
            this.sha1HashDirty = false;
            this.mimeTypeDirty = false;
            this.knownStateDirty = false;
            this.collectedDirty = false;
        }
        catch (SQLException ex) {
            throw new TskCoreException(String.format("Error updating properties of file %s (obj_id = %s)", this.getName(), this.getId()), ex);
        }
    }

    public Optional<String> getOwnerUid() {
        return Optional.ofNullable(this.ownerUid);
    }

    public Optional<Long> getOsAccountObjectId() {
        return Optional.ofNullable(this.osAccountObjId);
    }

    void setFileSystem(FileSystem parent) {
        this.parentFileSystem = parent;
    }

    public Optional<Long> getFileSystemObjectId() {
        return Optional.ofNullable(this.fileSystemObjectId);
    }

    public boolean hasFileSystem() {
        return this.fileSystemObjectId != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileSystem getFileSystem() throws TskCoreException {
        if (this.fileSystemObjectId == null) {
            throw new TskCoreException("File with ID: " + this.getId() + " does not belong to a file system");
        }
        if (this.parentFileSystem == null) {
            AbstractFile abstractFile = this;
            synchronized (abstractFile) {
                if (this.parentFileSystem == null) {
                    this.parentFileSystem = this.getSleuthkitCase().getFileSystemById((long)this.fileSystemObjectId, -1L);
                }
            }
        }
        return this.parentFileSystem;
    }

    @Override
    public String getUniquePath() throws TskCoreException {
        if (this.uniquePath == null) {
            if (this.getFileSystemObjectId().isPresent()) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getFileSystem().getUniquePath());
                if (!this.parentPath.isEmpty()) {
                    sb.append(this.parentPath);
                } else {
                    sb.append("/");
                }
                sb.append(this.getName());
                this.uniquePath = sb.toString();
            } else if (this instanceof LayoutFile && this.parentPath.equals("/")) {
                this.uniquePath = super.getUniquePath();
            } else if (this.getName().equals("$CarvedFiles") || this.getName().equals("$Unalloc") || this.parentPath.startsWith("/$CarvedFiles") || this.parentPath.startsWith("/$Unalloc")) {
                this.uniquePath = super.getUniquePath();
            } else {
                String dataSourceName = "";
                Content dataSource = this.getDataSource();
                if (dataSource != null) {
                    dataSourceName = dataSource.getUniquePath();
                }
                this.uniquePath = !this.parentPath.isEmpty() ? dataSourceName + this.parentPath + this.getName() : dataSourceName + "/" + this.getName();
            }
        }
        return this.uniquePath;
    }

    @Override
    @Deprecated
    public BlackboardArtifact newArtifact(int artifactTypeID) throws TskCoreException {
        return super.newArtifact(artifactTypeID);
    }

    @Override
    public DataArtifact newDataArtifact(BlackboardArtifact.Type artifactType, Collection<BlackboardAttribute> attributesList) throws TskCoreException {
        return super.newDataArtifact(artifactType, attributesList, this.getOsAccountObjectId().orElse(null));
    }

    @Deprecated
    public short getAttrId() {
        return (short)this.attrId;
    }

    @Deprecated
    protected void setLocalPath(String localPath, boolean isAbsolute) {
        this.setLocalFilePath(localPath);
    }

    @Deprecated
    public static String epochToTime(long epoch) {
        return TimeUtilities.epochToTime(epoch);
    }

    @Deprecated
    public static String epochToTime(long epoch, TimeZone tzone) {
        return TimeUtilities.epochToTime(epoch, tzone);
    }

    @Deprecated
    public static long timeToEpoch(String time) {
        return TimeUtilities.timeToEpoch(time);
    }

    @Deprecated
    AbstractFile(SleuthkitCase db, long objId, long dataSourceObjectId, Long fileSystemObjectId, TskData.TSK_FS_ATTR_TYPE_ENUM attrType, int attrId, String name, TskData.TSK_DB_FILES_TYPE_ENUM fileType, long metaAddr, int metaSeq, TskData.TSK_FS_NAME_TYPE_ENUM dirType, TskData.TSK_FS_META_TYPE_ENUM metaType, TskData.TSK_FS_NAME_FLAG_ENUM dirFlag, short metaFlags, long size, long ctime, long crtime, long atime, long mtime, short modes, int uid, int gid, String md5Hash, String sha256Hash, String sha1Hash, TskData.FileKnown knownState, String parentPath, String mimeType, String extension, String ownerUid, Long osAccountObjectId, List<Attribute> fileAttributes) {
        this(db, objId, dataSourceObjectId, fileSystemObjectId, attrType, attrId, name, fileType, metaAddr, metaSeq, dirType, metaType, dirFlag, metaFlags, size, ctime, crtime, atime, mtime, modes, uid, gid, md5Hash, sha256Hash, sha1Hash, knownState, parentPath, mimeType, extension, ownerUid, osAccountObjectId, TskData.CollectedStatus.UNKNOWN, fileAttributes);
    }

    public static enum MimeMatchEnum {
        UNDEFINED,
        TRUE,
        FALSE;

    }
}

