/*
 * Decompiled with CFR 0.152.
 */
package org.cf.util;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.cf.smalivm.context.HeapItem;
import org.cf.util.ClassNameUtils;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.MethodLocation;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;

public class Utils {
    private static final Pattern PARAMETER_INDIVIDUATOR = Pattern.compile("(\\[*(?:[BCDFIJSZ]|L[^;]+;))");
    private static final Pattern PARAMETER_ISOLATOR = Pattern.compile("\\([^\\)]+\\)");
    private static final PathMatcher SMALI_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.smali");

    public static Object buildArray(String internalName, int length) throws ClassNotFoundException {
        return Utils.buildArray(internalName, length, Utils.class.getClassLoader());
    }

    public static Object buildArray(String internalName, int length, ClassLoader classLoader) throws ClassNotFoundException {
        String baseClassName = ClassNameUtils.getComponentBase(internalName);
        String binaryName = ClassNameUtils.internalToBinary(baseClassName);
        int dimensionCount = ClassNameUtils.getDimensionCount(internalName) - 1;
        String classNameWithDimensions = ClassNameUtils.addDimensionsToBinaryClassName(binaryName, dimensionCount);
        Class<?> klazz = ClassUtils.getClass(classLoader, classNameWithDimensions);
        Object array = Array.newInstance(klazz, length);
        return array;
    }

    public static List<String> builderTypeListToTypeNames(BuilderTypeList typeList) {
        return typeList.stream().map(BuilderTypeReference::getType).collect(Collectors.toCollection(LinkedList::new));
    }

    public static String buildFieldDescriptor(Field field) {
        String className = ClassNameUtils.toInternal(field.getDeclaringClass());
        String typeName = ClassNameUtils.toInternal(field.getType());
        return className + "->" + field.getName() + ':' + typeName;
    }

    public static Object castToPrimitive(Object value, String targetType) {
        if (value instanceof Number) {
            Number castValue = (Number)value;
            if ("B".equals(targetType) || "Ljava/lang/Byte;".equals(targetType)) {
                return castValue.byteValue();
            }
            if ("D".equals(targetType) || "Ljava/lang/Double;".equals(targetType)) {
                return castValue.doubleValue();
            }
            if ("F".equals(targetType) || "Ljava/lang/Float;".equals(targetType)) {
                return Float.valueOf(castValue.floatValue());
            }
            if ("I".equals(targetType) || "Ljava/lang/Integer;".equals(targetType)) {
                return castValue.intValue();
            }
            if ("L".equals(targetType) || "Ljava/lang/Long;".equals(targetType)) {
                return castValue.longValue();
            }
            if ("S".equals(targetType) || "Ljava/lang/Short;".equals(targetType)) {
                return castValue.shortValue();
            }
            if ("C".equals(targetType) || "Ljava/lang/Character;".equals(targetType)) {
                return Character.valueOf((char)castValue.intValue());
            }
            if ("Z".equals(targetType) || "Ljava/lang/Boolean;".equals(targetType)) {
                return castValue.intValue() != 0;
            }
        } else if (value instanceof Boolean) {
            Boolean castValue = (Boolean)value;
            if ("Z".equals(targetType) || "Ljava/lang/Boolean;".equals(targetType)) {
                return castValue;
            }
            if ("B".equals(targetType) || "Ljava/lang/Byte;".equals(targetType)) {
                return (byte)(castValue != false ? 1 : 0);
            }
            if ("I".equals(targetType) || "Ljava/lang/Integer;".equals(targetType)) {
                return castValue != false ? 1 : 0;
            }
            if ("S".equals(targetType) || "Ljava/lang/Short;".equals(targetType)) {
                return (short)(castValue != false ? 1 : 0);
            }
        } else if (value instanceof Character) {
            Character castValue = (Character)value;
            Integer intValue = castValue.charValue();
            if ("Z".equals(targetType) || "Ljava/lang/Boolean;".equals(targetType)) {
                return castValue.charValue() != '\u0000';
            }
            if ("B".equals(targetType) || "Ljava/lang/Byte;".equals(targetType)) {
                return intValue.byteValue();
            }
            if ("I".equals(targetType) || "Ljava/lang/Integer;".equals(targetType)) {
                return intValue;
            }
            if ("S".equals(targetType) || "Ljava/lang/Short;".equals(targetType)) {
                return intValue.shortValue();
            }
        }
        return value;
    }

    public static String getArrayDimensionString(Object array) {
        if (!array.getClass().isArray()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Object current = array;
        int len = Array.getLength(current);
        sb.append('[').append(len).append(']');
        while (len > 0 && (current = Array.get(current, 0)) != null && current.getClass().isArray()) {
            len = Array.getLength(current);
            sb.append('[').append(len).append(']');
        }
        return sb.toString();
    }

    public static Double getDoubleValue(Object obj) {
        Double doubleValue = (Double)Utils.castToPrimitive(obj, "Ljava/lang/Double;");
        return doubleValue;
    }

    public static List<File> getFilesWithSmaliExtension(File file) {
        LinkedList<File> files = new LinkedList<File>();
        if (file.isDirectory()) {
            try {
                Files.walk(file.toPath(), new FileVisitOption[0]).forEach(filePath -> {
                    if (Files.isRegularFile(filePath, new LinkOption[0]) && SMALI_MATCHER.matches((Path)filePath)) {
                        files.add(filePath.toFile());
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (file.getAbsolutePath().toLowerCase().endsWith(".local")) {
            files.add(file);
        }
        return files;
    }

    public static Float getFloatValue(Object obj) {
        return (Float)Utils.castToPrimitive(obj, "Ljava/lang/Float;");
    }

    public static Integer getIntegerValue(Object obj) {
        return (Integer)Utils.castToPrimitive(obj, "Ljava/lang/Integer;");
    }

    public static MethodLocation[] getLocations(BuilderInstruction ... instructions) {
        MethodLocation[] locations = new MethodLocation[instructions.length];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = instructions[i].getLocation();
        }
        return locations;
    }

    public static Long getLongValue(Object obj) {
        return (Long)Utils.castToPrimitive(obj, "Ljava/lang/Long;");
    }

    public static MethodLocation getNextLocation(MethodLocation location, TIntObjectMap<MethodLocation> addressToLocation) {
        int address = location.getCodeAddress();
        int nextAddress = address + location.getInstruction().getCodeUnits();
        return addressToLocation.get(nextAddress);
    }

    public static List<String> getParameterTypes(String methodDescriptor) {
        Matcher m3 = PARAMETER_ISOLATOR.matcher(methodDescriptor);
        ArrayList<String> result = new ArrayList<String>();
        if (m3.find()) {
            String params = m3.group();
            m3 = PARAMETER_INDIVIDUATOR.matcher(params);
            while (m3.find()) {
                result.add(m3.group());
            }
        }
        return result;
    }

    public static int getRegisterSize(BuilderTypeList typeList) {
        return Utils.getRegisterSize(Utils.builderTypeListToTypeNames(typeList));
    }

    public static int getRegisterSize(Class<?>[] parameterTypes) {
        return Utils.getRegisterSize(ClassNameUtils.toInternal(parameterTypes));
    }

    public static int getRegisterSize(List<String> typeNames) {
        int size = 0;
        for (String typeName : typeNames) {
            size += Utils.getRegisterSize(typeName);
        }
        return size;
    }

    public static int getRegisterSize(String typeName) {
        return "J".equals(typeName) || "D".equals(typeName) ? 2 : 1;
    }

    public static Set<String> getDeclaredAndValueTypeNames(HeapItem item) {
        HashSet<String> types = new HashSet<String>(3);
        types.add(item.getType());
        Object value = item.getValue();
        if (!item.isUnknown() && value != null) {
            types.add(ClassNameUtils.toInternal(value.getClass()));
        }
        return types;
    }

    public static <T> void shiftIntegerMapKeys(int startKey, int shift, TIntObjectMap<T> intToObject) {
        if (shift == 0) {
            return;
        }
        TIntArrayList keysToShift = new TIntArrayList(intToObject.keys());
        for (int currentKey : keysToShift.toArray()) {
            if (currentKey > startKey) continue;
            keysToShift.remove(currentKey);
        }
        keysToShift.sort();
        if (shift > 0) {
            keysToShift.reverse();
        }
        for (int currentKey : keysToShift.toArray()) {
            T obj = intToObject.get(currentKey);
            intToObject.remove(currentKey);
            intToObject.put(currentKey + shift, obj);
        }
    }
}

