/*
 * Decompiled with CFR 0.152.
 */
package org.cf.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassNameUtils {
    private static final Map<String, Class<?>> binaryNameToType;
    private static final BiMap<String, String> internalPrimitiveToBinaryName;
    private static final BiMap<String, String> internalPrimitiveToWrapper;
    private static final Map<String, Class<?>> internalPrimitiveToClass;

    public static String binaryToInternal(String binaryName) {
        String baseName = ClassNameUtils.getComponentBase(binaryName);
        StringBuilder sb = new StringBuilder();
        int dimensionCount = ClassNameUtils.getDimensionCount(binaryName);
        for (int i = 0; i < dimensionCount; ++i) {
            sb.append('[');
        }
        String internalPrimitive = (String)internalPrimitiveToBinaryName.inverse().get(baseName);
        if (internalPrimitive != null) {
            return sb.append(internalPrimitive).toString();
        }
        if (dimensionCount > 0 && internalPrimitiveToBinaryName.containsKey(baseName)) {
            return sb.append(baseName).toString();
        }
        if (baseName.endsWith(";")) {
            sb.append(baseName.replace('.', '/'));
        } else {
            sb.append('L').append(baseName.replace('.', '/')).append(';');
        }
        return sb.toString();
    }

    public static String getComponentBase(String className) {
        return className.replace("[", "").replace("]", "");
    }

    public static String getComponentType(String className) {
        return className.replaceFirst("\\[\\]?", "");
    }

    public static int getDimensionCount(String className) {
        String baseClassName = className.replace("[", "");
        return className.length() - baseClassName.length();
    }

    public static String getPackageName(String className) {
        String sourceName = ClassNameUtils.toFormat(className, TypeFormat.SOURCE);
        int lastIndex = sourceName.lastIndexOf(46);
        if (lastIndex < 0) {
            return "";
        }
        return sourceName.substring(0, lastIndex);
    }

    @Nullable
    public static String getPrimitive(String className) {
        String internalName = ClassNameUtils.toFormat(className, TypeFormat.SOURCE);
        String primitiveName = (String)internalPrimitiveToWrapper.inverse().get(ClassNameUtils.getComponentBase(internalName));
        if (null == primitiveName) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int dimensionCount = ClassNameUtils.getDimensionCount(internalName);
        if (dimensionCount > 0) {
            for (int i = 0; i < dimensionCount; ++i) {
                sb.append('[');
            }
            sb.append(primitiveName);
            return sb.toString();
        }
        return primitiveName;
    }

    public static Class<?> getPrimitiveClass(String className) {
        return internalPrimitiveToClass.get(className);
    }

    @Nullable
    public static String getWrapper(String className) {
        String internalName = ClassNameUtils.toFormat(className, TypeFormat.INTERNAL);
        String wrapperName = (String)internalPrimitiveToWrapper.get(ClassNameUtils.getComponentBase(internalName));
        if (null == wrapperName) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int dimensionCount = ClassNameUtils.getDimensionCount(internalName);
        if (dimensionCount > 0) {
            for (int i = 0; i < dimensionCount; ++i) {
                sb.append('[');
            }
            sb.append('L').append(wrapperName).append(';');
            return sb.toString();
        }
        return wrapperName;
    }

    public static String internalToBinary(String internalName) {
        String internalPrimitive = (String)internalPrimitiveToBinaryName.get(internalName);
        if (internalPrimitive != null) {
            return internalPrimitive;
        }
        if (internalName.startsWith("[")) {
            return internalName.replace("/", ".");
        }
        return internalName.substring(1, internalName.length() - 1).replace("/", ".");
    }

    public static String internalToSource(String internalName) {
        StringBuilder sourceName = new StringBuilder();
        String baseClass = ClassNameUtils.getComponentBase(internalName);
        String binaryPrimitive = (String)internalPrimitiveToBinaryName.get(baseClass);
        if (binaryPrimitive != null) {
            sourceName.append(binaryPrimitive);
        } else {
            sourceName.append(baseClass.substring(1, baseClass.length() - 1).replace('/', '.'));
        }
        int dimensions = ClassNameUtils.getDimensionCount(internalName);
        for (int i = 0; i < dimensions; ++i) {
            sourceName.append("[]");
        }
        return sourceName.toString();
    }

    public static boolean isObject(String type) {
        char c = type.charAt(0);
        return c == 'L' || c == '[';
    }

    public static boolean isPrimitive(String className) {
        String internalName = ClassNameUtils.toFormat(className, TypeFormat.INTERNAL);
        return internalPrimitiveToBinaryName.containsKey(internalName);
    }

    public static boolean isPrimitiveOrWrapper(String className) {
        return ClassNameUtils.isPrimitive(className) || ClassNameUtils.isWrapper(className);
    }

    public static boolean isWrapper(String className) {
        return ClassNameUtils.getWrapper(className) != null;
    }

    public static String sourceToBinary(String sourceName) {
        String sourceBaseName = sourceName.replace("[]", "");
        StringBuilder sb = new StringBuilder();
        int dimensionCount = (sourceName.length() - sourceBaseName.length()) / 2;
        for (int i = 0; i < dimensionCount; ++i) {
            sb.append('[');
        }
        String internalPrimitive = (String)internalPrimitiveToBinaryName.inverse().get(sourceBaseName);
        if (internalPrimitive != null) {
            if (dimensionCount > 0) {
                sb.append(internalPrimitive);
            } else {
                sb.append((String)internalPrimitiveToBinaryName.get(internalPrimitive));
            }
        } else if (dimensionCount > 0) {
            sb.append('L').append(sourceBaseName).append(';');
        } else {
            sb.append(sourceBaseName);
        }
        return sb.toString();
    }

    public static String sourceToInternal(String sourceName) {
        String sourceBaseName = sourceName.replace("[]", "");
        StringBuilder sb = new StringBuilder();
        int dimensionCount = (sourceName.length() - sourceBaseName.length()) / 2;
        for (int i = 0; i < dimensionCount; ++i) {
            sb.append('[');
        }
        String internalPrimitive = (String)internalPrimitiveToBinaryName.inverse().get(sourceBaseName);
        if (internalPrimitive != null) {
            sb.append(internalPrimitive);
        } else {
            sb.append('L').append(sourceBaseName.replace('.', '/')).append(';');
        }
        return sb.toString();
    }

    public static String toFormat(String className, TypeFormat format) {
        String baseName = ClassNameUtils.getComponentBase(className);
        if (baseName.contains("/") || internalPrimitiveToBinaryName.containsKey(baseName)) {
            switch (format) {
                case INTERNAL: {
                    return className;
                }
                case BINARY: {
                    return ClassNameUtils.internalToBinary(className);
                }
                case SOURCE: {
                    return ClassNameUtils.internalToSource(className);
                }
            }
        } else if (className.endsWith(";")) {
            switch (format) {
                case INTERNAL: {
                    return ClassNameUtils.binaryToInternal(className);
                }
                case BINARY: {
                    return className;
                }
                case SOURCE: {
                    return ClassNameUtils.internalToSource(ClassNameUtils.binaryToInternal(className));
                }
            }
        } else {
            switch (format) {
                case INTERNAL: {
                    return ClassNameUtils.sourceToInternal(className);
                }
                case BINARY: {
                    return ClassNameUtils.sourceToBinary(className);
                }
                case SOURCE: {
                    return className;
                }
            }
        }
        return className;
    }

    public static String toInternal(Class<?> klazz) {
        return ClassNameUtils.binaryToInternal(klazz.getName());
    }

    public static List<String> toInternal(Class<?> ... classes) {
        LinkedList<String> names = new LinkedList<String>();
        for (Class<?> klazz : classes) {
            names.add(ClassNameUtils.toInternal(klazz));
        }
        return names;
    }

    public static ReferenceType guessReferenceType(@Nonnull String s2) {
        if (s2.startsWith("[")) {
            s2 = ClassNameUtils.getComponentBase(s2);
        }
        if (s2.startsWith("L")) {
            if (s2.contains(";->")) {
                if (s2.contains("(") && s2.contains(")")) {
                    return ReferenceType.INTERNAL_METHOD_SIGNATURE;
                }
                if (s2.contains(":")) {
                    return ReferenceType.INTERNAL_FIELD_DESCRIPTOR;
                }
            } else if (s2.endsWith(";")) {
                return ReferenceType.INTERNAL_CLASS_DESCRIPTOR;
            }
        } else if (s2.contains("(") && s2.contains(")")) {
            return ReferenceType.INTERNAL_METHOD_DESCRIPTOR;
        }
        return ReferenceType.UNKNOWN;
    }

    static String addDimensionsToBinaryClassName(String className, int dimensionCount) {
        StringBuilder sb = new StringBuilder(className);
        for (int i = 0; i < dimensionCount; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    static String addDimensionsToInternalClassName(String className, int dimensionCount) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dimensionCount; ++i) {
            sb.append('[');
        }
        sb.append(className);
        return sb.toString();
    }

    static {
        internalPrimitiveToWrapper = HashBiMap.create();
        internalPrimitiveToWrapper.put("I", Integer.class.getName());
        internalPrimitiveToWrapper.put("S", Short.class.getName());
        internalPrimitiveToWrapper.put("J", Long.class.getName());
        internalPrimitiveToWrapper.put("B", Byte.class.getName());
        internalPrimitiveToWrapper.put("D", Double.class.getName());
        internalPrimitiveToWrapper.put("F", Float.class.getName());
        internalPrimitiveToWrapper.put("Z", Boolean.class.getName());
        internalPrimitiveToWrapper.put("C", Character.class.getName());
        internalPrimitiveToWrapper.put("V", Void.class.getName());
        internalPrimitiveToClass = new HashMap(8);
        internalPrimitiveToClass.put("I", Integer.TYPE);
        internalPrimitiveToClass.put("S", Short.TYPE);
        internalPrimitiveToClass.put("J", Long.TYPE);
        internalPrimitiveToClass.put("B", Byte.TYPE);
        internalPrimitiveToClass.put("D", Double.TYPE);
        internalPrimitiveToClass.put("F", Float.TYPE);
        internalPrimitiveToClass.put("Z", Boolean.TYPE);
        internalPrimitiveToClass.put("C", Character.TYPE);
        internalPrimitiveToBinaryName = HashBiMap.create();
        internalPrimitiveToBinaryName.put("I", Integer.TYPE.getName());
        internalPrimitiveToBinaryName.put("S", Short.TYPE.getName());
        internalPrimitiveToBinaryName.put("J", Long.TYPE.getName());
        internalPrimitiveToBinaryName.put("B", Byte.TYPE.getName());
        internalPrimitiveToBinaryName.put("D", Double.TYPE.getName());
        internalPrimitiveToBinaryName.put("F", Float.TYPE.getName());
        internalPrimitiveToBinaryName.put("Z", Boolean.TYPE.getName());
        internalPrimitiveToBinaryName.put("C", Character.TYPE.getName());
        internalPrimitiveToBinaryName.put("V", Void.TYPE.getName());
        binaryNameToType = new HashMap(9);
        binaryNameToType.put("int", Integer.TYPE);
        binaryNameToType.put("short", Short.TYPE);
        binaryNameToType.put("long", Long.TYPE);
        binaryNameToType.put("byte", Byte.TYPE);
        binaryNameToType.put("float", Float.TYPE);
        binaryNameToType.put("double", Double.TYPE);
        binaryNameToType.put("boolean", Boolean.TYPE);
        binaryNameToType.put("char", Character.TYPE);
        binaryNameToType.put("void", Void.TYPE);
    }

    public static enum ReferenceType {
        INTERNAL_CLASS_DESCRIPTOR,
        INTERNAL_METHOD_DESCRIPTOR,
        INTERNAL_METHOD_SIGNATURE,
        INTERNAL_FIELD_DESCRIPTOR,
        UNKNOWN;

    }

    public static enum TypeFormat {
        BINARY,
        INTERNAL,
        SOURCE;

    }
}

