/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.type;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.cf.smalivm.type.ClassManager;
import org.cf.smalivm.type.VirtualField;
import org.cf.smalivm.type.VirtualMethod;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VirtualType {
    private static final Logger log = LoggerFactory.getLogger(VirtualType.class.getSimpleName());
    protected static ClassManager classManager;
    private final TypeReference typeReference;
    private final String internalName;
    private final String binaryName;
    private final String sourceName;

    VirtualType(TypeReference typeReference, String internalName, String binaryName, String sourceName) {
        this.typeReference = typeReference;
        this.internalName = internalName;
        this.binaryName = binaryName;
        this.sourceName = sourceName;
    }

    static ClassManager getClassManager() {
        return classManager;
    }

    static void setClassManager(ClassManager classManager) {
        VirtualType.classManager = classManager;
    }

    public abstract Set<? extends VirtualType> getImmediateAncestors();

    public abstract Set<? extends VirtualType> getAncestors();

    public boolean isAncestorOf(VirtualType other) {
        return other.getAncestors().contains(this);
    }

    public boolean isChildOf(VirtualType other) {
        return this.getAncestors().contains(other);
    }

    public String getPackage() {
        return null;
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    @Nullable
    public VirtualField getField(String fieldName) {
        return null;
    }

    public abstract Collection<VirtualField> getFields();

    @Nullable
    public VirtualMethod getMethod(String methodDescriptor) {
        return null;
    }

    public abstract Collection<VirtualMethod> getMethods();

    public String getName() {
        return this.internalName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public final TypeReference getTypeReference() {
        return this.typeReference;
    }

    public BuilderClassDef getClassDef() {
        return null;
    }

    public boolean isInnerClassOf(VirtualType other) {
        return false;
    }

    public boolean isSamePackageOf(VirtualType other) {
        return false;
    }

    public final int hashCode() {
        return new HashCodeBuilder(423, 15).append(this.getName()).hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        VirtualType rhs = (VirtualType)obj;
        return new EqualsBuilder().append(this.getName(), rhs.getName()).isEquals();
    }

    public final String toString() {
        return this.getName();
    }

    public abstract boolean instanceOf(VirtualType var1);

    public abstract boolean isArray();

    public abstract boolean isPrimitive();
}

