/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.type;

import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.cf.smalivm.type.VirtualClass;
import org.cf.smalivm.type.VirtualMethod;
import org.cf.smalivm.type.VirtualType;
import org.jf.dexlib2.builder.BuilderTryBlock;
import org.jf.dexlib2.builder.MutableMethodImplementation;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;

public class VirtualRealMethod
extends VirtualMethod {
    private final BuilderMethod method;
    private final VirtualType type;

    VirtualRealMethod(BuilderMethod method, VirtualClass type) {
        super(method, type);
        this.method = method;
        this.type = type;
    }

    @Override
    public MutableMethodImplementation getImplementation() {
        return (MutableMethodImplementation)this.getMethodDefinition().getImplementation();
    }

    @Override
    public BuilderMethod getMethodDefinition() {
        return this.method;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public String getSignature() {
        return ReferenceUtil.getMethodDescriptor(this.method);
    }

    @Override
    public final int getParameterSize() {
        int parameterSize = this.method.getParameters().size();
        if (!this.isStatic()) {
            ++parameterSize;
        }
        return parameterSize;
    }

    @Override
    public List<String> getParameterTypeNames() {
        List<String> parameterTypes = this.method.getParameterTypes().stream().map(BuilderTypeReference::getType).collect(Collectors.toList());
        if (!this.isStatic()) {
            parameterTypes.add(0, this.type.getName());
        }
        return parameterTypes;
    }

    @Override
    public int getRegisterCount() {
        return this.getImplementation().getRegisterCount();
    }

    @Override
    public final String getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public List<BuilderTryBlock> getTryBlocks() {
        MutableMethodImplementation implementation = (MutableMethodImplementation)this.method.getImplementation();
        if (implementation == null) {
            return new LinkedList<BuilderTryBlock>();
        }
        return implementation.getTryBlocks();
    }

    @Override
    public boolean hasImplementation() {
        return null != this.method.getImplementation();
    }

    @Override
    public boolean isNative() {
        return Modifier.isNative(this.getMethodDefinition().getAccessFlags());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getAccessFlags());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.method.getAccessFlags());
    }

    @Override
    public boolean returnsVoid() {
        return this.getReturnType().equals("V");
    }
}

