/*
 * Decompiled with CFR 0.152.
 */
package org.cf.smalivm.opcode;

import java.util.HashSet;
import java.util.Set;
import org.cf.smalivm.SideEffect;
import org.jf.dexlib2.builder.BuilderInstruction;
import org.jf.dexlib2.builder.MethodLocation;

public abstract class Op {
    private final MethodLocation location;
    private final MethodLocation[] children;
    private final Set<Throwable> exceptions;

    Op(MethodLocation location, MethodLocation child) {
        this(location, new MethodLocation[]{child});
    }

    Op(MethodLocation location, MethodLocation[] children) {
        this.location = location;
        this.children = children;
        this.exceptions = new HashSet<Throwable>();
    }

    public final int getAddress() {
        return this.location.getCodeAddress();
    }

    public final int getIndex() {
        return this.location.getIndex();
    }

    public final MethodLocation[] getChildren() {
        return this.children;
    }

    public Set<Throwable> getExceptions() {
        return this.exceptions;
    }

    public final BuilderInstruction getInstruction() {
        return (BuilderInstruction)this.location.getInstruction();
    }

    public final MethodLocation getLocation() {
        return this.location;
    }

    public final String getName() {
        if (this.getInstruction() != null) {
            return this.getInstruction().getOpcode().name;
        }
        return "*null instr*";
    }

    public SideEffect.Level getSideEffectLevel() {
        return SideEffect.Level.NONE;
    }

    public abstract String toString();

    void addException(Throwable exception) {
        this.exceptions.add(exception);
    }
}

